/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceRequest;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;

public class RestWatchServiceAction
extends WatcherRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestWatchServiceAction.class));

    public RestWatchServiceAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_watcher/_start", (RestHandler)this, RestRequest.Method.POST, URI_BASE + "/watcher/_start", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_watcher/_stop", (RestHandler)new StopRestHandler(settings), RestRequest.Method.POST, URI_BASE + "/watcher/_stop", deprecationLogger);
    }

    public String getName() {
        return "watcher_start_service";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) {
        return channel -> client.watcherService(new WatcherServiceRequest().start(), (ActionListener)new RestToXContentListener(channel));
    }

    private static class StopRestHandler
    extends WatcherRestHandler {
        StopRestHandler(Settings settings) {
            super(settings);
        }

        public String getName() {
            return "watcher_stop_service";
        }

        @Override
        public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) {
            return channel -> client.watcherService(new WatcherServiceRequest().stop(), (ActionListener)new RestToXContentListener(channel));
        }
    }
}

