/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule.tool;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.LoggingAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.xpack.core.scheduler.Cron;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CronEvalTool
extends LoggingAwareCommand {
    private static final DateTimeFormatter UTC_FORMATTER = DateTimeFormat.forPattern((String)"EEE, d MMM yyyy HH:mm:ss").withZone(DateTimeZone.UTC).withLocale(Locale.ROOT);
    private static final DateTimeFormatter LOCAL_FORMATTER = DateTimeFormat.forPattern((String)"EEE, d MMM yyyy HH:mm:ss Z").withZone(DateTimeZone.forTimeZone(null));
    private final OptionSpec<Integer> countOption;
    private final OptionSpec<String> arguments;

    public static void main(String[] args) throws Exception {
        CronEvalTool.exit((int)new CronEvalTool().main(args, Terminal.DEFAULT));
    }

    CronEvalTool() {
        super("Validates and evaluates a cron expression");
        this.countOption = this.parser.acceptsAll(Arrays.asList("c", "count"), "The number of future times this expression will be triggered").withRequiredArg().ofType(Integer.class).defaultsTo((Object)10, (Object[])new Integer[0]);
        this.arguments = this.parser.nonOptions("expression");
    }

    protected void execute(Terminal terminal, OptionSet options) throws Exception {
        int count = (Integer)this.countOption.value(options);
        List args = this.arguments.values(options);
        if (args.size() != 1) {
            throw new UserException(64, "expecting a single argument that is the cron expression to evaluate");
        }
        this.execute(terminal, (String)args.get(0), count);
    }

    void execute(Terminal terminal, String expression, int count) throws Exception {
        Cron.validate((String)expression);
        terminal.println("Valid!");
        DateTime date = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        boolean isLocalTimeUTC = UTC_FORMATTER.getZone().equals((Object)LOCAL_FORMATTER.getZone());
        if (isLocalTimeUTC) {
            terminal.println("Now is [" + UTC_FORMATTER.print((ReadableInstant)date) + "] in UTC");
        } else {
            terminal.println("Now is [" + UTC_FORMATTER.print((ReadableInstant)date) + "] in UTC, local time is [" + LOCAL_FORMATTER.print((ReadableInstant)date) + "]");
        }
        terminal.println("Here are the next " + count + " times this cron expression will trigger:");
        Cron cron = new Cron(expression);
        long time = date.getMillis();
        for (int i = 0; i < count; ++i) {
            long prevTime = time;
            if ((time = cron.getNextValidTimeAfter(time)) < 0L) {
                if (i != 0) break;
                throw new UserException(0, "Could not compute future times since [" + UTC_FORMATTER.print(prevTime) + "] (perhaps the cron expression only points to times in the past?)");
            }
            if (isLocalTimeUTC) {
                terminal.println(i + 1 + ".\t" + UTC_FORMATTER.print(time));
                continue;
            }
            terminal.println(i + 1 + ".\t" + UTC_FORMATTER.print(time));
            terminal.println("\t" + LOCAL_FORMATTER.print(time));
        }
    }
}

