/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support.search;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.Watcher;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateRequest;

public class WatcherSearchTemplateService {
    private final ScriptService scriptService;
    private final NamedXContentRegistry xContentRegistry;

    public WatcherSearchTemplateService(ScriptService scriptService, NamedXContentRegistry xContentRegistry) {
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
    }

    public String renderTemplate(Script source, WatchExecutionContext ctx, Payload payload) throws IOException {
        Map<String, Object> watcherContextParams = Variables.createCtxParamsMap(ctx, payload);
        if (source.getParams() != null) {
            watcherContextParams.putAll(source.getParams());
        }
        Script template = new Script(source.getType(), source.getType() == ScriptType.STORED ? null : "mustache", source.getIdOrCode(), source.getOptions(), watcherContextParams);
        TemplateScript.Factory compiledTemplate = (TemplateScript.Factory)this.scriptService.compile(template, Watcher.SCRIPT_TEMPLATE_CONTEXT);
        return compiledTemplate.newInstance(template.getParams()).execute();
    }

    public SearchRequest toSearchRequest(WatcherSearchTemplateRequest request) throws IOException {
        SearchRequest searchRequest = new SearchRequest(request.getIndices());
        searchRequest.types(request.getTypes());
        searchRequest.searchType(request.getSearchType());
        searchRequest.indicesOptions(request.getIndicesOptions());
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BytesReference source = request.getSearchSource();
        if (source != null && source.length() > 0) {
            try (StreamInput stream = source.streamInput();
                 XContentParser parser = XContentFactory.xContent((XContentType)XContentHelper.xContentType((BytesReference)source)).createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                sourceBuilder.parseXContent(parser);
                searchRequest.source(sourceBuilder);
            }
        }
        return searchRequest;
    }
}

