/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.pagerduty;

import java.io.IOException;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.common.http.HttpRequest;
import org.elasticsearch.xpack.watcher.common.http.HttpResponse;
import org.elasticsearch.xpack.watcher.notification.pagerduty.IncidentEvent;
import org.elasticsearch.xpack.watcher.notification.pagerduty.IncidentEventDefaults;
import org.elasticsearch.xpack.watcher.notification.pagerduty.SentEvent;

public class PagerDutyAccount {
    private static final String SERVICE_KEY_SETTING = "service_api_key";
    private static final String TRIGGER_DEFAULTS_SETTING = "event_defaults";
    private static final Setting<SecureString> SECURE_SERVICE_API_KEY_SETTING = SecureSetting.secureString((String)"secure_service_api_key", null, (Setting.Property[])new Setting.Property[0]);
    private final String name;
    private final String serviceKey;
    private final HttpClient httpClient;
    private final IncidentEventDefaults eventDefaults;

    PagerDutyAccount(String name, Settings accountSettings, Settings serviceSettings, HttpClient httpClient) {
        this.name = name;
        this.serviceKey = PagerDutyAccount.getServiceKey(name, accountSettings, serviceSettings);
        this.httpClient = httpClient;
        this.eventDefaults = new IncidentEventDefaults(accountSettings.getAsSettings(TRIGGER_DEFAULTS_SETTING));
    }

    public String getName() {
        return this.name;
    }

    public IncidentEventDefaults getDefaults() {
        return this.eventDefaults;
    }

    public SentEvent send(IncidentEvent event, Payload payload, String watchId) throws IOException {
        HttpRequest request = event.createRequest(this.serviceKey, payload, watchId);
        HttpResponse response = this.httpClient.execute(request);
        return SentEvent.responded(event, request, response);
    }

    private static String getServiceKey(String name, Settings accountSettings, Settings serviceSettings) {
        String serviceKey = accountSettings.get(SERVICE_KEY_SETTING, serviceSettings.get(SERVICE_KEY_SETTING, null));
        if (serviceKey == null) {
            SecureString secureString = (SecureString)SECURE_SERVICE_API_KEY_SETTING.get(accountSettings);
            if (secureString == null || secureString.length() < 1) {
                throw new SettingsException("invalid pagerduty account [" + name + "]. missing required [" + SERVICE_KEY_SETTING + "] setting");
            }
            serviceKey = secureString.toString();
        }
        return serviceKey;
    }
}

