/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.common.http;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.Streams;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.watcher.crypto.CryptoService;
import org.elasticsearch.xpack.watcher.common.http.HttpMethod;
import org.elasticsearch.xpack.watcher.common.http.HttpProxy;
import org.elasticsearch.xpack.watcher.common.http.HttpRequest;
import org.elasticsearch.xpack.watcher.common.http.HttpResponse;
import org.elasticsearch.xpack.watcher.common.http.HttpSettings;
import org.elasticsearch.xpack.watcher.common.http.Scheme;
import org.elasticsearch.xpack.watcher.common.http.SizeLimitInputStream;

public class HttpClient
implements Closeable {
    private static final String SETTINGS_SSL_PREFIX = "xpack.http.ssl.";
    private static final int MAX_CONNECTIONS = 500;
    private static final Logger logger = LogManager.getLogger(HttpClient.class);
    private final CloseableHttpClient client;
    private final HttpProxy settingsProxy;
    private final TimeValue defaultConnectionTimeout;
    private final TimeValue defaultReadTimeout;
    private final ByteSizeValue maxResponseSize;
    private final CryptoService cryptoService;

    public HttpClient(Settings settings, SSLService sslService, CryptoService cryptoService) {
        this.defaultConnectionTimeout = (TimeValue)HttpSettings.CONNECTION_TIMEOUT.get(settings);
        this.defaultReadTimeout = (TimeValue)HttpSettings.READ_TIMEOUT.get(settings);
        this.maxResponseSize = (ByteSizeValue)HttpSettings.MAX_HTTP_RESPONSE_SIZE.get(settings);
        this.settingsProxy = this.getProxyFromSettings(settings);
        this.cryptoService = cryptoService;
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        SSLConfiguration sslConfiguration = sslService.getSSLConfiguration(SETTINGS_SSL_PREFIX);
        boolean isHostnameVerificationEnabled = sslConfiguration.verificationMode().isHostnameVerificationEnabled();
        NoopHostnameVerifier verifier = isHostnameVerificationEnabled ? new DefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE;
        SSLConnectionSocketFactory factory = new SSLConnectionSocketFactory(sslService.sslSocketFactory(sslConfiguration), (HostnameVerifier)verifier);
        clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)factory);
        clientBuilder.evictExpiredConnections();
        clientBuilder.setMaxConnPerRoute(500);
        clientBuilder.setMaxConnTotal(500);
        this.client = clientBuilder.build();
    }

    public HttpResponse execute(HttpRequest request) throws IOException {
        XContentType xContentType;
        Object internalRequest;
        URI uri = this.createURI(request);
        if (request.method == HttpMethod.HEAD) {
            internalRequest = new HttpHead(uri);
        } else {
            HttpMethodWithEntity methodWithEntity = new HttpMethodWithEntity(uri, request.method.name());
            if (request.hasBody()) {
                ByteArrayEntity byteArrayEntity = new ByteArrayEntity(request.body.getBytes(StandardCharsets.UTF_8));
                String contentType = request.headers().get("Content-Type");
                if (Strings.hasLength((String)contentType)) {
                    byteArrayEntity.setContentType(contentType);
                } else {
                    byteArrayEntity.setContentType(ContentType.TEXT_PLAIN.toString());
                }
                methodWithEntity.setEntity((HttpEntity)byteArrayEntity);
            }
            internalRequest = methodWithEntity;
        }
        internalRequest.setHeader("Accept-Charset", StandardCharsets.UTF_8.name());
        if (!request.headers().isEmpty()) {
            for (Map.Entry entry : request.headers.entrySet()) {
                internalRequest.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (request.hasBody() && !internalRequest.containsHeader("Content-Type") && (xContentType = XContentFactory.xContentType((CharSequence)request.body())) != null) {
            internalRequest.setHeader("Content-Type", xContentType.mediaType());
        }
        RequestConfig.Builder config = RequestConfig.custom();
        HttpClient.setProxy(config, request, this.settingsProxy);
        HttpClientContext httpClientContext = HttpClientContext.create();
        if (request.auth() != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(request.auth().username, new String(request.auth().password.text(this.cryptoService)));
            credentialsProvider.setCredentials(new AuthScope(request.host, request.port), (Credentials)credentials);
            httpClientContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            BasicAuthCache authCache = new BasicAuthCache();
            Header[] basicAuth = new BasicScheme();
            authCache.put(new HttpHost(request.host, request.port, request.scheme.scheme()), (AuthScheme)basicAuth);
            httpClientContext.setAuthCache((AuthCache)authCache);
        }
        if (request.connectionTimeout() != null) {
            config.setConnectTimeout(Math.toIntExact(request.connectionTimeout.millis()));
        } else {
            config.setConnectTimeout(Math.toIntExact(this.defaultConnectionTimeout.millis()));
        }
        if (request.readTimeout() != null) {
            config.setSocketTimeout(Math.toIntExact(request.readTimeout.millis()));
            config.setConnectionRequestTimeout(Math.toIntExact(request.readTimeout.millis()));
        } else {
            config.setSocketTimeout(Math.toIntExact(this.defaultReadTimeout.millis()));
            config.setConnectionRequestTimeout(Math.toIntExact(this.defaultReadTimeout.millis()));
        }
        internalRequest.setConfig(config.build());
        try (CloseableHttpResponse response = (CloseableHttpResponse)SocketAccess.doPrivileged(() -> this.lambda$execute$0((HttpRequestBase)internalRequest, httpClientContext));){
            byte[] body;
            Header[] headers = response.getAllHeaders();
            HashMap<String, String[]> responseHeaders = new HashMap<String, String[]>(headers.length);
            for (Header header : headers) {
                if (responseHeaders.containsKey(header.getName())) {
                    String[] old = (String[])responseHeaders.get(header.getName());
                    String[] values = new String[old.length + 1];
                    System.arraycopy(old, 0, values, 0, old.length);
                    values[values.length - 1] = header.getValue();
                    responseHeaders.put(header.getName(), values);
                    continue;
                }
                responseHeaders.put(header.getName(), new String[]{header.getValue()});
            }
            if (response.getEntity() == null) {
                body = new byte[]{};
            } else {
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    try (SizeLimitInputStream is = new SizeLimitInputStream(this.maxResponseSize, response.getEntity().getContent());){
                        Streams.copy((InputStream)is, (OutputStream)outputStream);
                    }
                    body = outputStream.toByteArray();
                }
            }
            HttpResponse httpResponse = new HttpResponse(response.getStatusLine().getStatusCode(), body, responseHeaders);
            return httpResponse;
        }
    }

    static void setProxy(RequestConfig.Builder config, HttpRequest request, HttpProxy configuredProxy) {
        if (request.proxy != null && !request.proxy.equals(HttpProxy.NO_PROXY)) {
            String scheme = request.proxy.getScheme() != null ? request.proxy.getScheme().scheme() : Scheme.HTTP.scheme();
            HttpHost proxy = new HttpHost(request.proxy.getHost(), request.proxy.getPort().intValue(), scheme);
            config.setProxy(proxy);
        } else if (!HttpProxy.NO_PROXY.equals(configuredProxy)) {
            HttpHost proxy = new HttpHost(configuredProxy.getHost(), configuredProxy.getPort().intValue(), configuredProxy.getScheme().scheme());
            config.setProxy(proxy);
        }
    }

    private HttpProxy getProxyFromSettings(Settings settings) {
        String proxyHost = (String)HttpSettings.PROXY_HOST.get(settings);
        Scheme proxyScheme = HttpSettings.PROXY_SCHEME.exists(settings) ? Scheme.parse((String)HttpSettings.PROXY_SCHEME.get(settings)) : Scheme.HTTP;
        int proxyPort = (Integer)HttpSettings.PROXY_PORT.get(settings);
        if (proxyPort != 0 && Strings.hasText((String)proxyHost)) {
            logger.info("Using default proxy for http input and slack/hipchat/pagerduty/webhook actions [{}:{}]", (Object)proxyHost, (Object)proxyPort);
        } else if (proxyPort != 0 ^ Strings.hasText((String)proxyHost)) {
            throw new IllegalArgumentException("HTTP proxy requires both settings: [" + HttpSettings.PROXY_HOST.getKey() + "] and [" + HttpSettings.PROXY_PORT.getKey() + "]");
        }
        if (proxyPort > 0 && Strings.hasText((String)proxyHost)) {
            return new HttpProxy(proxyHost, proxyPort, proxyScheme);
        }
        return HttpProxy.NO_PROXY;
    }

    private URI createURI(HttpRequest request) {
        try {
            ArrayList qparams = new ArrayList(request.params.size());
            request.params.forEach((k, v) -> qparams.add(new BasicNameValuePair(k, v)));
            String format = URLEncodedUtils.format(qparams, (String)"UTF-8");
            URI uri = URIUtils.createURI((String)request.scheme.scheme(), (String)request.host, (int)request.port, (String)request.path, (String)(Strings.isNullOrEmpty((String)format) ? null : format), null);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private /* synthetic */ CloseableHttpResponse lambda$execute$0(HttpRequestBase internalRequest, HttpClientContext localContext) throws IOException {
        return this.client.execute((HttpUriRequest)internalRequest, (HttpContext)localContext);
    }

    final class HttpMethodWithEntity
    extends HttpEntityEnclosingRequestBase {
        private final String methodName;

        HttpMethodWithEntity(URI uri, String methodName) {
            this.methodName = methodName;
            this.setURI(uri);
        }

        public String getMethod() {
            return this.methodName;
        }
    }
}

