/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transport.actions.ack;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.watcher.support.WatcherUtils;

public class AckWatchRequest
extends ActionRequest {
    private String watchId;
    private String[] actionIds = Strings.EMPTY_ARRAY;

    public AckWatchRequest() {
        this(null, null);
    }

    public AckWatchRequest(String watchId, String ... actionIds) {
        this.watchId = watchId;
        this.actionIds = actionIds;
    }

    public AckWatchRequest(StreamInput in) throws IOException {
        super(in);
        this.watchId = in.readString();
        this.actionIds = in.readStringArray();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.watchId);
        out.writeStringArray(this.actionIds);
    }

    public String getWatchId() {
        return this.watchId;
    }

    public void setActionIds(String ... actionIds) {
        this.actionIds = actionIds;
    }

    public String[] getActionIds() {
        return this.actionIds;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.watchId == null) {
            validationException = ValidateActions.addValidationError((String)"watch id is missing", validationException);
        } else if (!WatcherUtils.isValidId(this.watchId)) {
            validationException = ValidateActions.addValidationError((String)"watch id contains whitespace", (ActionRequestValidationException)validationException);
        }
        if (this.actionIds != null) {
            for (String actionId : this.actionIds) {
                if (actionId == null) {
                    validationException = ValidateActions.addValidationError((String)String.format(Locale.ROOT, "action id may not be null", new Object[0]), (ActionRequestValidationException)validationException);
                    continue;
                }
                if (WatcherUtils.isValidId(actionId)) continue;
                validationException = ValidateActions.addValidationError((String)String.format(Locale.ROOT, "action id [%s] contains whitespace", actionId), (ActionRequestValidationException)validationException);
            }
        }
        return validationException;
    }

    public void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ack [").append(this.watchId).append("]");
        if (this.actionIds.length > 0) {
            sb.append("[");
            for (int i = 0; i < this.actionIds.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.actionIds[i]);
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

