/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;

public class ValidateJobConfigAction
extends Action<AcknowledgedResponse> {
    public static final ValidateJobConfigAction INSTANCE = new ValidateJobConfigAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/validate";

    protected ValidateJobConfigAction() {
        super(NAME);
    }

    public AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    public static class Request
    extends ActionRequest {
        private Job job;

        public static Request parseRequest(XContentParser parser) {
            Job.Builder job;
            job.setId((job = (Job.Builder)Job.STRICT_PARSER.apply(parser, null)).getId() != null ? job.getId() : "ok");
            List<String> invalidJobCreationSettings = job.invalidCreateTimeSettings();
            if (!invalidJobCreationSettings.isEmpty()) {
                throw new IllegalArgumentException(Messages.getMessage("The job is configured with fields [{0}] that are illegal to set at job creation", String.join((CharSequence)",", invalidJobCreationSettings)));
            }
            return new Request(job.build(new Date()));
        }

        public Request() {
            this.job = null;
        }

        public Request(Job job) {
            this.job = job;
        }

        public Job getJob() {
            return this.job;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.job.writeTo(out);
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.job = new Job(in);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.job});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals((Object)this.job, (Object)other.job);
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, AcknowledgedResponse> {
        protected RequestBuilder(ElasticsearchClient client, ValidateJobConfigAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }
}

