/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.indexlifecycle.AsyncActionStep;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleSettings;
import org.elasticsearch.xpack.core.indexlifecycle.RolloverAction;
import org.elasticsearch.xpack.core.indexlifecycle.Step;

public class RolloverStep
extends AsyncActionStep {
    private static final Logger logger = LogManager.getLogger(RolloverStep.class);
    public static final String NAME = "attempt-rollover";

    public RolloverStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public void performAction(IndexMetaData indexMetaData, ClusterState currentClusterState, AsyncActionStep.Listener listener) {
        boolean indexingComplete = (Boolean)LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING.get(indexMetaData.getSettings());
        if (indexingComplete) {
            logger.trace(indexMetaData.getIndex() + " has lifecycle complete set, skipping " + NAME);
            listener.onResponse(true);
            return;
        }
        String rolloverAlias = (String)RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING.get(indexMetaData.getSettings());
        if (Strings.isNullOrEmpty((String)rolloverAlias)) {
            listener.onFailure(new IllegalArgumentException(String.format(Locale.ROOT, "setting [%s] for index [%s] is empty or not defined", "index.lifecycle.rollover_alias", indexMetaData.getIndex().getName())));
            return;
        }
        if (!indexMetaData.getAliases().containsKey((Object)rolloverAlias)) {
            listener.onFailure(new IllegalArgumentException(String.format(Locale.ROOT, "%s [%s] does not point to index [%s]", "index.lifecycle.rollover_alias", rolloverAlias, indexMetaData.getIndex().getName())));
            return;
        }
        RolloverRequest rolloverRequest = new RolloverRequest(rolloverAlias, null);
        this.getClient().admin().indices().rolloverIndex(rolloverRequest, ActionListener.wrap(response -> {
            assert (response.isRolledOver()) : "the only way this rollover call should fail is with an exception";
            listener.onResponse(response.isRolledOver());
        }, listener::onFailure));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RolloverStep other = (RolloverStep)obj;
        return super.equals(obj);
    }
}

