/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ccr.action.ResumeFollowAction;

public final class PutFollowAction
extends Action<Response> {
    public static final PutFollowAction INSTANCE = new PutFollowAction();
    public static final String NAME = "indices:admin/xpack/ccr/put_follow";

    private PutFollowAction() {
        super(NAME);
    }

    public Response newResponse() {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    public Writeable.Reader<Response> getResponseReader() {
        return Response::new;
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final boolean followIndexCreated;
        private final boolean followIndexShardsAcked;
        private final boolean indexFollowingStarted;

        public Response(boolean followIndexCreated, boolean followIndexShardsAcked, boolean indexFollowingStarted) {
            this.followIndexCreated = followIndexCreated;
            this.followIndexShardsAcked = followIndexShardsAcked;
            this.indexFollowingStarted = indexFollowingStarted;
        }

        public boolean isFollowIndexCreated() {
            return this.followIndexCreated;
        }

        public boolean isFollowIndexShardsAcked() {
            return this.followIndexShardsAcked;
        }

        public boolean isIndexFollowingStarted() {
            return this.indexFollowingStarted;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.followIndexCreated = in.readBoolean();
            this.followIndexShardsAcked = in.readBoolean();
            this.indexFollowingStarted = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.followIndexCreated);
            out.writeBoolean(this.followIndexShardsAcked);
            out.writeBoolean(this.indexFollowingStarted);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("follow_index_created", this.followIndexCreated);
            builder.field("follow_index_shards_acked", this.followIndexShardsAcked);
            builder.field("index_following_started", this.indexFollowingStarted);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.followIndexCreated == response.followIndexCreated && this.followIndexShardsAcked == response.followIndexShardsAcked && this.indexFollowingStarted == response.indexFollowingStarted;
        }

        public int hashCode() {
            return Objects.hash(this.followIndexCreated, this.followIndexShardsAcked, this.indexFollowingStarted);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest,
    ToXContentObject {
        private static final ParseField REMOTE_CLUSTER_FIELD = new ParseField("remote_cluster", new String[0]);
        private static final ParseField LEADER_INDEX_FIELD = new ParseField("leader_index", new String[0]);
        private static final ObjectParser<Request, String> PARSER = new ObjectParser("indices:admin/xpack/ccr/put_follow", () -> {
            Request request = new Request();
            request.setFollowRequest(new ResumeFollowAction.Request());
            return request;
        });
        private String remoteCluster;
        private String leaderIndex;
        private ResumeFollowAction.Request followRequest;

        public static Request fromXContent(XContentParser parser, String followerIndex) throws IOException {
            Request request = (Request)((Object)PARSER.parse(parser, (Object)followerIndex));
            if (followerIndex != null) {
                if (request.getFollowRequest().getFollowerIndex() == null) {
                    request.getFollowRequest().setFollowerIndex(followerIndex);
                } else if (!request.getFollowRequest().getFollowerIndex().equals(followerIndex)) {
                    throw new IllegalArgumentException("provided follower_index is not equal");
                }
            }
            return request;
        }

        public Request() {
        }

        public String getRemoteCluster() {
            return this.remoteCluster;
        }

        public void setRemoteCluster(String remoteCluster) {
            this.remoteCluster = remoteCluster;
        }

        public String getLeaderIndex() {
            return this.leaderIndex;
        }

        public void setLeaderIndex(String leaderIndex) {
            this.leaderIndex = leaderIndex;
        }

        public ResumeFollowAction.Request getFollowRequest() {
            return this.followRequest;
        }

        public void setFollowRequest(ResumeFollowAction.Request followRequest) {
            this.followRequest = followRequest;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException e = this.followRequest.validate();
            if (this.remoteCluster == null) {
                e = ValidateActions.addValidationError((String)(REMOTE_CLUSTER_FIELD.getPreferredName() + " is missing"), (ActionRequestValidationException)e);
            }
            if (this.leaderIndex == null) {
                e = ValidateActions.addValidationError((String)(LEADER_INDEX_FIELD.getPreferredName() + " is missing"), (ActionRequestValidationException)e);
            }
            return e;
        }

        public String[] indices() {
            return new String[]{this.followRequest.getFollowerIndex()};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.remoteCluster = in.readString();
            this.leaderIndex = in.readString();
            this.followRequest = new ResumeFollowAction.Request(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.remoteCluster);
            out.writeString(this.leaderIndex);
            this.followRequest.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(REMOTE_CLUSTER_FIELD.getPreferredName(), this.remoteCluster);
            builder.field(LEADER_INDEX_FIELD.getPreferredName(), this.leaderIndex);
            this.followRequest.toXContentFragment(builder, params);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.remoteCluster, request.remoteCluster) && Objects.equals(this.leaderIndex, request.leaderIndex) && Objects.equals((Object)this.followRequest, (Object)request.followRequest);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.remoteCluster, this.leaderIndex, this.followRequest});
        }

        static {
            PARSER.declareString(Request::setRemoteCluster, REMOTE_CLUSTER_FIELD);
            PARSER.declareString(Request::setLeaderIndex, LEADER_INDEX_FIELD);
            PARSER.declareString((req, val) -> req.followRequest.setFollowerIndex((String)val), ResumeFollowAction.Request.FOLLOWER_INDEX_FIELD);
            PARSER.declareInt((req, val) -> req.followRequest.setMaxReadRequestOperationCount((Integer)val), ResumeFollowAction.Request.MAX_READ_REQUEST_OPERATION_COUNT);
            PARSER.declareField((req, val) -> req.followRequest.setMaxReadRequestSize((ByteSizeValue)val), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)ResumeFollowAction.Request.MAX_READ_REQUEST_SIZE.getPreferredName()), ResumeFollowAction.Request.MAX_READ_REQUEST_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareInt((req, val) -> req.followRequest.setMaxOutstandingReadRequests((Integer)val), ResumeFollowAction.Request.MAX_OUTSTANDING_READ_REQUESTS);
            PARSER.declareInt((req, val) -> req.followRequest.setMaxWriteRequestOperationCount((Integer)val), ResumeFollowAction.Request.MAX_WRITE_REQUEST_OPERATION_COUNT);
            PARSER.declareField((req, val) -> req.followRequest.setMaxWriteRequestSize((ByteSizeValue)val), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)ResumeFollowAction.Request.MAX_WRITE_REQUEST_SIZE.getPreferredName()), ResumeFollowAction.Request.MAX_WRITE_REQUEST_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareInt((req, val) -> req.followRequest.setMaxOutstandingWriteRequests((Integer)val), ResumeFollowAction.Request.MAX_OUTSTANDING_WRITE_REQUESTS);
            PARSER.declareInt((req, val) -> req.followRequest.setMaxWriteBufferCount((Integer)val), ResumeFollowAction.Request.MAX_WRITE_BUFFER_COUNT);
            PARSER.declareField((req, val) -> req.followRequest.setMaxWriteBufferSize((ByteSizeValue)val), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)ResumeFollowAction.Request.MAX_WRITE_BUFFER_SIZE.getPreferredName()), ResumeFollowAction.Request.MAX_WRITE_BUFFER_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareField((req, val) -> req.followRequest.setMaxRetryDelay((TimeValue)val), (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)ResumeFollowAction.Request.MAX_RETRY_DELAY_FIELD.getPreferredName()), ResumeFollowAction.Request.MAX_RETRY_DELAY_FIELD, ObjectParser.ValueType.STRING);
            PARSER.declareField((req, val) -> req.followRequest.setReadPollTimeout((TimeValue)val), (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)ResumeFollowAction.Request.READ_POLL_TIMEOUT.getPreferredName()), ResumeFollowAction.Request.READ_POLL_TIMEOUT, ObjectParser.ValueType.STRING);
        }
    }
}

