/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class AutoFollowStats
implements Writeable,
ToXContentObject {
    private static final ParseField NUMBER_OF_SUCCESSFUL_INDICES_AUTO_FOLLOWED = new ParseField("number_of_successful_follow_indices", new String[0]);
    private static final ParseField NUMBER_OF_FAILED_INDICES_AUTO_FOLLOWED = new ParseField("number_of_failed_follow_indices", new String[0]);
    private static final ParseField NUMBER_OF_FAILED_REMOTE_CLUSTER_STATE_REQUESTS = new ParseField("number_of_failed_remote_cluster_state_requests", new String[0]);
    private static final ParseField RECENT_AUTO_FOLLOW_ERRORS = new ParseField("recent_auto_follow_errors", new String[0]);
    private static final ParseField LEADER_INDEX = new ParseField("leader_index", new String[0]);
    private static final ParseField AUTO_FOLLOW_EXCEPTION = new ParseField("auto_follow_exception", new String[0]);
    private static final ConstructingObjectParser<AutoFollowStats, Void> STATS_PARSER = new ConstructingObjectParser("auto_follow_stats", args -> new AutoFollowStats((Long)args[0], (Long)args[1], (Long)args[2], new TreeMap<String, ElasticsearchException>(((List)args[3]).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))));
    private static final ConstructingObjectParser<Map.Entry<String, ElasticsearchException>, Void> AUTO_FOLLOW_EXCEPTIONS_PARSER = new ConstructingObjectParser("auto_follow_stats_errors", args -> new AbstractMap.SimpleEntry<String, ElasticsearchException>((String)args[0], (ElasticsearchException)args[1]));
    private final long numberOfFailedFollowIndices;
    private final long numberOfFailedRemoteClusterStateRequests;
    private final long numberOfSuccessfulFollowIndices;
    private final NavigableMap<String, ElasticsearchException> recentAutoFollowErrors;

    public static AutoFollowStats fromXContent(XContentParser parser) {
        return (AutoFollowStats)STATS_PARSER.apply(parser, null);
    }

    public AutoFollowStats(long numberOfFailedFollowIndices, long numberOfFailedRemoteClusterStateRequests, long numberOfSuccessfulFollowIndices, NavigableMap<String, ElasticsearchException> recentAutoFollowErrors) {
        this.numberOfFailedFollowIndices = numberOfFailedFollowIndices;
        this.numberOfFailedRemoteClusterStateRequests = numberOfFailedRemoteClusterStateRequests;
        this.numberOfSuccessfulFollowIndices = numberOfSuccessfulFollowIndices;
        this.recentAutoFollowErrors = recentAutoFollowErrors;
    }

    public AutoFollowStats(StreamInput in) throws IOException {
        this.numberOfFailedFollowIndices = in.readVLong();
        this.numberOfFailedRemoteClusterStateRequests = in.readVLong();
        this.numberOfSuccessfulFollowIndices = in.readVLong();
        this.recentAutoFollowErrors = new TreeMap<String, ElasticsearchException>(in.readMap(StreamInput::readString, StreamInput::readException));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.numberOfFailedFollowIndices);
        out.writeVLong(this.numberOfFailedRemoteClusterStateRequests);
        out.writeVLong(this.numberOfSuccessfulFollowIndices);
        out.writeMap(this.recentAutoFollowErrors, StreamOutput::writeString, StreamOutput::writeException);
    }

    public long getNumberOfFailedFollowIndices() {
        return this.numberOfFailedFollowIndices;
    }

    public long getNumberOfFailedRemoteClusterStateRequests() {
        return this.numberOfFailedRemoteClusterStateRequests;
    }

    public long getNumberOfSuccessfulFollowIndices() {
        return this.numberOfSuccessfulFollowIndices;
    }

    public NavigableMap<String, ElasticsearchException> getRecentAutoFollowErrors() {
        return this.recentAutoFollowErrors;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(NUMBER_OF_FAILED_INDICES_AUTO_FOLLOWED.getPreferredName(), this.numberOfFailedFollowIndices);
        builder.field(NUMBER_OF_FAILED_REMOTE_CLUSTER_STATE_REQUESTS.getPreferredName(), this.numberOfFailedRemoteClusterStateRequests);
        builder.field(NUMBER_OF_SUCCESSFUL_INDICES_AUTO_FOLLOWED.getPreferredName(), this.numberOfSuccessfulFollowIndices);
        builder.startArray(RECENT_AUTO_FOLLOW_ERRORS.getPreferredName());
        for (Map.Entry entry : this.recentAutoFollowErrors.entrySet()) {
            builder.startObject();
            builder.field(LEADER_INDEX.getPreferredName(), (String)entry.getKey());
            builder.field(AUTO_FOLLOW_EXCEPTION.getPreferredName());
            builder.startObject();
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)((Throwable)entry.getValue()));
            builder.endObject();
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoFollowStats that = (AutoFollowStats)o;
        return this.numberOfFailedFollowIndices == that.numberOfFailedFollowIndices && this.numberOfFailedRemoteClusterStateRequests == that.numberOfFailedRemoteClusterStateRequests && this.numberOfSuccessfulFollowIndices == that.numberOfSuccessfulFollowIndices && this.recentAutoFollowErrors.keySet().equals(that.recentAutoFollowErrors.keySet()) && AutoFollowStats.getFetchExceptionMessages(this).equals(AutoFollowStats.getFetchExceptionMessages(that));
    }

    public int hashCode() {
        return Objects.hash(this.numberOfFailedFollowIndices, this.numberOfFailedRemoteClusterStateRequests, this.numberOfSuccessfulFollowIndices, this.recentAutoFollowErrors.keySet(), AutoFollowStats.getFetchExceptionMessages(this));
    }

    private static List<String> getFetchExceptionMessages(AutoFollowStats status) {
        return status.getRecentAutoFollowErrors().values().stream().map(Throwable::getMessage).collect(Collectors.toList());
    }

    public String toString() {
        return "AutoFollowStats{numberOfFailedFollowIndices=" + this.numberOfFailedFollowIndices + ", numberOfFailedRemoteClusterStateRequests=" + this.numberOfFailedRemoteClusterStateRequests + ", numberOfSuccessfulFollowIndices=" + this.numberOfSuccessfulFollowIndices + ", recentAutoFollowErrors=" + this.recentAutoFollowErrors + '}';
    }

    static {
        AUTO_FOLLOW_EXCEPTIONS_PARSER.declareString(ConstructingObjectParser.constructorArg(), LEADER_INDEX);
        AUTO_FOLLOW_EXCEPTIONS_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ElasticsearchException.fromXContent((XContentParser)p), AUTO_FOLLOW_EXCEPTION);
        STATS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUMBER_OF_FAILED_INDICES_AUTO_FOLLOWED);
        STATS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUMBER_OF_FAILED_REMOTE_CLUSTER_STATE_REQUESTS);
        STATS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUMBER_OF_SUCCESSFUL_INDICES_AUTO_FOLLOWED);
        STATS_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), AUTO_FOLLOW_EXCEPTIONS_PARSER, RECENT_AUTO_FOLLOW_ERRORS);
    }
}

