/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.XPackPlugin;

public class AutoFollowMetadata
extends AbstractNamedDiffable<MetaData.Custom>
implements XPackPlugin.XPackMetaDataCustom {
    public static final String TYPE = "ccr_auto_follow";
    private static final ParseField PATTERNS_FIELD = new ParseField("patterns", new String[0]);
    private static final ParseField FOLLOWED_LEADER_INDICES_FIELD = new ParseField("followed_leader_indices", new String[0]);
    private static final ParseField HEADERS = new ParseField("headers", new String[0]);
    private static final ConstructingObjectParser<AutoFollowMetadata, Void> PARSER = new ConstructingObjectParser("auto_follow", args -> new AutoFollowMetadata((Map)args[0], (Map)args[1], (Map)args[2]));
    private final Map<String, AutoFollowPattern> patterns;
    private final Map<String, List<String>> followedLeaderIndexUUIDs;
    private final Map<String, Map<String, String>> headers;

    public static AutoFollowMetadata fromXContent(XContentParser parser) throws IOException {
        return (AutoFollowMetadata)PARSER.parse(parser, null);
    }

    public AutoFollowMetadata(Map<String, AutoFollowPattern> patterns, Map<String, List<String>> followedLeaderIndexUUIDs, Map<String, Map<String, String>> headers) {
        this.patterns = Collections.unmodifiableMap(patterns);
        this.followedLeaderIndexUUIDs = Collections.unmodifiableMap(followedLeaderIndexUUIDs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableList((List)e.getValue()))));
        this.headers = Collections.unmodifiableMap(headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableMap((Map)e.getValue()))));
    }

    public AutoFollowMetadata(StreamInput in) throws IOException {
        this(in.readMap(StreamInput::readString, AutoFollowPattern::new), in.readMapOfLists(StreamInput::readString, StreamInput::readString), in.readMap(StreamInput::readString, valIn -> valIn.readMap(StreamInput::readString, StreamInput::readString)));
    }

    public Map<String, AutoFollowPattern> getPatterns() {
        return this.patterns;
    }

    public Map<String, List<String>> getFollowedLeaderIndexUUIDs() {
        return this.followedLeaderIndexUUIDs;
    }

    public Map<String, Map<String, String>> getHeaders() {
        return this.headers;
    }

    public EnumSet<MetaData.XContentContext> context() {
        return EnumSet.of(MetaData.XContentContext.SNAPSHOT, MetaData.XContentContext.GATEWAY);
    }

    public String getWriteableName() {
        return TYPE;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_6_5_0.minimumCompatibilityVersion();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.patterns, StreamOutput::writeString, (out1, value) -> value.writeTo(out1));
        out.writeMapOfLists(this.followedLeaderIndexUUIDs, StreamOutput::writeString, StreamOutput::writeString);
        out.writeMap(this.headers, StreamOutput::writeString, (valOut, header) -> valOut.writeMap(header, StreamOutput::writeString, StreamOutput::writeString));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(PATTERNS_FIELD.getPreferredName());
        for (Map.Entry<String, AutoFollowPattern> entry : this.patterns.entrySet()) {
            builder.startObject(entry.getKey());
            builder.value((Object)entry.getValue());
            builder.endObject();
        }
        builder.endObject();
        builder.startObject(FOLLOWED_LEADER_INDICES_FIELD.getPreferredName());
        for (Map.Entry<String, Object> entry : this.followedLeaderIndexUUIDs.entrySet()) {
            builder.field(entry.getKey(), (Iterable)entry.getValue());
        }
        builder.endObject();
        builder.startObject(HEADERS.getPreferredName());
        for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
            builder.field(entry.getKey(), entry.getValue());
        }
        builder.endObject();
        return builder;
    }

    public boolean isFragment() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoFollowMetadata that = (AutoFollowMetadata)o;
        return Objects.equals(this.patterns, that.patterns) && Objects.equals(this.followedLeaderIndexUUIDs, that.followedLeaderIndexUUIDs) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.patterns, this.followedLeaderIndexUUIDs, this.headers);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            HashMap<String, AutoFollowPattern> patterns = new HashMap<String, AutoFollowPattern>();
            String fieldName = null;
            XContentParser.Token token = p.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = p.currentName();
                } else if (token == XContentParser.Token.START_OBJECT) {
                    patterns.put(fieldName, (AutoFollowPattern)AutoFollowPattern.PARSER.parse(p, c));
                } else {
                    throw new ElasticsearchParseException("unexpected token [" + token + "]", new Object[0]);
                }
                token = p.nextToken();
            }
            return patterns;
        }, PATTERNS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), FOLLOWED_LEADER_INDICES_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), HEADERS);
    }

    public static class AutoFollowPattern
    implements Writeable,
    ToXContentObject {
        public static final ParseField REMOTE_CLUSTER_FIELD = new ParseField("remote_cluster", new String[0]);
        public static final ParseField LEADER_PATTERNS_FIELD = new ParseField("leader_index_patterns", new String[0]);
        public static final ParseField FOLLOW_PATTERN_FIELD = new ParseField("follow_index_pattern", new String[0]);
        public static final ParseField MAX_READ_REQUEST_OPERATION_COUNT = new ParseField("max_read_request_operation_count", new String[0]);
        public static final ParseField MAX_READ_REQUEST_SIZE = new ParseField("max_read_request_size", new String[0]);
        public static final ParseField MAX_OUTSTANDING_READ_REQUESTS = new ParseField("max_outstanding_read_requests", new String[0]);
        public static final ParseField MAX_WRITE_REQUEST_OPERATION_COUNT = new ParseField("max_write_request_operation_count", new String[0]);
        public static final ParseField MAX_WRITE_REQUEST_SIZE = new ParseField("max_write_request_size", new String[0]);
        public static final ParseField MAX_OUTSTANDING_WRITE_REQUESTS = new ParseField("max_outstanding_write_requests", new String[0]);
        public static final ParseField MAX_WRITE_BUFFER_COUNT = new ParseField("max_write_buffer_count", new String[0]);
        public static final ParseField MAX_WRITE_BUFFER_SIZE = new ParseField("max_write_buffer_size", new String[0]);
        public static final ParseField MAX_RETRY_DELAY = new ParseField("max_retry_delay", new String[0]);
        public static final ParseField READ_POLL_TIMEOUT = new ParseField("read_poll_timeout", new String[0]);
        private static final ConstructingObjectParser<AutoFollowPattern, Void> PARSER = new ConstructingObjectParser("auto_follow_pattern", args -> new AutoFollowPattern((String)args[0], (List)args[1], (String)args[2], (Integer)args[3], (ByteSizeValue)args[4], (Integer)args[5], (Integer)args[6], (ByteSizeValue)args[7], (Integer)args[8], (Integer)args[9], (ByteSizeValue)args[10], (TimeValue)args[11], (TimeValue)args[12]));
        private final String remoteCluster;
        private final List<String> leaderIndexPatterns;
        private final String followIndexPattern;
        private final Integer maxReadRequestOperationCount;
        private final ByteSizeValue maxReadRequestSize;
        private final Integer maxOutstandingReadRequests;
        private final Integer maxWriteRequestOperationCount;
        private final ByteSizeValue maxWriteRequestSize;
        private final Integer maxOutstandingWriteRequests;
        private final Integer maxWriteBufferCount;
        private final ByteSizeValue maxWriteBufferSize;
        private final TimeValue maxRetryDelay;
        private final TimeValue pollTimeout;

        public AutoFollowPattern(String remoteCluster, List<String> leaderIndexPatterns, String followIndexPattern, Integer maxReadRequestOperationCount, ByteSizeValue maxReadRequestSize, Integer maxOutstandingReadRequests, Integer maxWriteRequestOperationCount, ByteSizeValue maxWriteRequestSize, Integer maxOutstandingWriteRequests, Integer maxWriteBufferCount, ByteSizeValue maxWriteBufferSize, TimeValue maxRetryDelay, TimeValue pollTimeout) {
            this.remoteCluster = remoteCluster;
            this.leaderIndexPatterns = leaderIndexPatterns;
            this.followIndexPattern = followIndexPattern;
            this.maxReadRequestOperationCount = maxReadRequestOperationCount;
            this.maxReadRequestSize = maxReadRequestSize;
            this.maxOutstandingReadRequests = maxOutstandingReadRequests;
            this.maxWriteRequestOperationCount = maxWriteRequestOperationCount;
            this.maxWriteRequestSize = maxWriteRequestSize;
            this.maxOutstandingWriteRequests = maxOutstandingWriteRequests;
            this.maxWriteBufferCount = maxWriteBufferCount;
            this.maxWriteBufferSize = maxWriteBufferSize;
            this.maxRetryDelay = maxRetryDelay;
            this.pollTimeout = pollTimeout;
        }

        public AutoFollowPattern(StreamInput in) throws IOException {
            this.remoteCluster = in.readString();
            this.leaderIndexPatterns = in.readList(StreamInput::readString);
            this.followIndexPattern = in.readOptionalString();
            this.maxReadRequestOperationCount = in.readOptionalVInt();
            this.maxReadRequestSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.maxOutstandingReadRequests = in.readOptionalVInt();
            this.maxWriteRequestOperationCount = in.readOptionalVInt();
            this.maxWriteRequestSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.maxOutstandingWriteRequests = in.readOptionalVInt();
            this.maxWriteBufferCount = in.readOptionalVInt();
            this.maxWriteBufferSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.maxRetryDelay = in.readOptionalTimeValue();
            this.pollTimeout = in.readOptionalTimeValue();
        }

        public boolean match(String indexName) {
            return AutoFollowPattern.match(this.leaderIndexPatterns, indexName);
        }

        public static boolean match(List<String> leaderIndexPatterns, String indexName) {
            return Regex.simpleMatch(leaderIndexPatterns, (String)indexName);
        }

        public String getRemoteCluster() {
            return this.remoteCluster;
        }

        public List<String> getLeaderIndexPatterns() {
            return this.leaderIndexPatterns;
        }

        public String getFollowIndexPattern() {
            return this.followIndexPattern;
        }

        public Integer getMaxReadRequestOperationCount() {
            return this.maxReadRequestOperationCount;
        }

        public Integer getMaxOutstandingReadRequests() {
            return this.maxOutstandingReadRequests;
        }

        public ByteSizeValue getMaxReadRequestSize() {
            return this.maxReadRequestSize;
        }

        public Integer getMaxWriteRequestOperationCount() {
            return this.maxWriteRequestOperationCount;
        }

        public ByteSizeValue getMaxWriteRequestSize() {
            return this.maxWriteRequestSize;
        }

        public Integer getMaxOutstandingWriteRequests() {
            return this.maxOutstandingWriteRequests;
        }

        public Integer getMaxWriteBufferCount() {
            return this.maxWriteBufferCount;
        }

        public ByteSizeValue getMaxWriteBufferSize() {
            return this.maxWriteBufferSize;
        }

        public TimeValue getMaxRetryDelay() {
            return this.maxRetryDelay;
        }

        public TimeValue getPollTimeout() {
            return this.pollTimeout;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.remoteCluster);
            out.writeStringList(this.leaderIndexPatterns);
            out.writeOptionalString(this.followIndexPattern);
            out.writeOptionalVInt(this.maxReadRequestOperationCount);
            out.writeOptionalWriteable((Writeable)this.maxReadRequestSize);
            out.writeOptionalVInt(this.maxOutstandingReadRequests);
            out.writeOptionalVInt(this.maxWriteRequestOperationCount);
            out.writeOptionalWriteable((Writeable)this.maxWriteRequestSize);
            out.writeOptionalVInt(this.maxOutstandingWriteRequests);
            out.writeOptionalVInt(this.maxWriteBufferCount);
            out.writeOptionalWriteable((Writeable)this.maxWriteBufferSize);
            out.writeOptionalTimeValue(this.maxRetryDelay);
            out.writeOptionalTimeValue(this.pollTimeout);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(REMOTE_CLUSTER_FIELD.getPreferredName(), this.remoteCluster);
            builder.array(LEADER_PATTERNS_FIELD.getPreferredName(), this.leaderIndexPatterns.toArray(new String[0]));
            if (this.followIndexPattern != null) {
                builder.field(FOLLOW_PATTERN_FIELD.getPreferredName(), this.followIndexPattern);
            }
            if (this.maxReadRequestOperationCount != null) {
                builder.field(MAX_READ_REQUEST_OPERATION_COUNT.getPreferredName(), this.maxReadRequestOperationCount);
            }
            if (this.maxReadRequestSize != null) {
                builder.field(MAX_READ_REQUEST_SIZE.getPreferredName(), this.maxReadRequestSize.getStringRep());
            }
            if (this.maxOutstandingReadRequests != null) {
                builder.field(MAX_OUTSTANDING_READ_REQUESTS.getPreferredName(), this.maxOutstandingReadRequests);
            }
            if (this.maxWriteRequestOperationCount != null) {
                builder.field(MAX_WRITE_REQUEST_OPERATION_COUNT.getPreferredName(), this.maxWriteRequestOperationCount);
            }
            if (this.maxWriteRequestSize != null) {
                builder.field(MAX_WRITE_REQUEST_SIZE.getPreferredName(), this.maxWriteRequestSize.getStringRep());
            }
            if (this.maxOutstandingWriteRequests != null) {
                builder.field(MAX_OUTSTANDING_WRITE_REQUESTS.getPreferredName(), this.maxOutstandingWriteRequests);
            }
            if (this.maxWriteBufferCount != null) {
                builder.field(MAX_WRITE_BUFFER_COUNT.getPreferredName(), this.maxWriteBufferCount);
            }
            if (this.maxWriteBufferSize != null) {
                builder.field(MAX_WRITE_BUFFER_SIZE.getPreferredName(), this.maxWriteBufferSize.getStringRep());
            }
            if (this.maxRetryDelay != null) {
                builder.field(MAX_RETRY_DELAY.getPreferredName(), (Object)this.maxRetryDelay);
            }
            if (this.pollTimeout != null) {
                builder.field(READ_POLL_TIMEOUT.getPreferredName(), (Object)this.pollTimeout);
            }
            return builder;
        }

        public boolean isFragment() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutoFollowPattern that = (AutoFollowPattern)o;
            return Objects.equals(this.remoteCluster, that.remoteCluster) && Objects.equals(this.leaderIndexPatterns, that.leaderIndexPatterns) && Objects.equals(this.followIndexPattern, that.followIndexPattern) && Objects.equals(this.maxReadRequestOperationCount, that.maxReadRequestOperationCount) && Objects.equals(this.maxReadRequestSize, that.maxReadRequestSize) && Objects.equals(this.maxOutstandingReadRequests, that.maxOutstandingReadRequests) && Objects.equals(this.maxWriteRequestOperationCount, that.maxWriteRequestOperationCount) && Objects.equals(this.maxWriteRequestSize, that.maxWriteRequestSize) && Objects.equals(this.maxOutstandingWriteRequests, that.maxOutstandingWriteRequests) && Objects.equals(this.maxWriteBufferCount, that.maxWriteBufferCount) && Objects.equals(this.maxWriteBufferSize, that.maxWriteBufferSize) && Objects.equals(this.maxRetryDelay, that.maxRetryDelay) && Objects.equals(this.pollTimeout, that.pollTimeout);
        }

        public int hashCode() {
            return Objects.hash(this.remoteCluster, this.leaderIndexPatterns, this.followIndexPattern, this.maxReadRequestOperationCount, this.maxReadRequestSize, this.maxOutstandingReadRequests, this.maxWriteRequestOperationCount, this.maxWriteRequestSize, this.maxOutstandingWriteRequests, this.maxWriteBufferCount, this.maxWriteBufferSize, this.maxRetryDelay, this.pollTimeout);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), REMOTE_CLUSTER_FIELD);
            PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), LEADER_PATTERNS_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FOLLOW_PATTERN_FIELD);
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_READ_REQUEST_OPERATION_COUNT);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_READ_REQUEST_SIZE.getPreferredName()), MAX_READ_REQUEST_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_OUTSTANDING_READ_REQUESTS);
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_WRITE_REQUEST_OPERATION_COUNT);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_WRITE_REQUEST_SIZE.getPreferredName()), MAX_WRITE_REQUEST_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_OUTSTANDING_WRITE_REQUESTS);
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_WRITE_BUFFER_COUNT);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_WRITE_BUFFER_SIZE.getPreferredName()), MAX_WRITE_BUFFER_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)MAX_RETRY_DELAY.getPreferredName()), MAX_RETRY_DELAY, ObjectParser.ValueType.STRING);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)READ_POLL_TIMEOUT.getPreferredName()), READ_POLL_TIMEOUT, ObjectParser.ValueType.STRING);
        }
    }
}

