/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;

public final class ClientHelper {
    public static final Set<String> SECURITY_HEADER_FILTERS = Sets.newHashSet((Object[])new String[]{"es-security-runas-user", "_xpack_security_authentication"});
    @Deprecated
    public static final String ACTION_ORIGIN_TRANSIENT_NAME = "action.origin";
    public static final String SECURITY_ORIGIN = "security";
    public static final String WATCHER_ORIGIN = "watcher";
    public static final String ML_ORIGIN = "ml";
    public static final String INDEX_LIFECYCLE_ORIGIN = "index_lifecycle";
    public static final String MONITORING_ORIGIN = "monitoring";
    public static final String DEPRECATION_ORIGIN = "deprecation";
    public static final String PERSISTENT_TASK_ORIGIN = "persistent_tasks";
    public static final String ROLLUP_ORIGIN = "rollup";

    private ClientHelper() {
    }

    @Deprecated
    public static ThreadContext.StoredContext stashWithOrigin(ThreadContext threadContext, String origin) {
        return threadContext.stashWithOrigin(origin);
    }

    @Deprecated
    public static Client clientWithOrigin(Client client, String origin) {
        return new OriginSettingClient(client, origin);
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> void executeAsyncWithOrigin(ThreadContext threadContext, String origin, Request request, ActionListener<Response> listener, BiConsumer<Request, ActionListener<Response>> consumer) {
        Supplier supplier = threadContext.newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin(threadContext, origin);){
            consumer.accept(request, (ActionListener<Response>)new ContextPreservingActionListener(supplier, listener));
        }
    }

    public static <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response>> void executeAsyncWithOrigin(Client client, String origin, Action<Response> action, Request request, ActionListener<Response> listener) {
        ThreadContext threadContext = client.threadPool().getThreadContext();
        Supplier supplier = threadContext.newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin(threadContext, origin);){
            client.execute(action, request, (ActionListener)new ContextPreservingActionListener(supplier, listener));
        }
    }

    public static <T extends ActionResponse> T executeWithHeaders(Map<String, String> headers, String origin, Client client, Supplier<T> supplier) {
        Map<String, String> filteredHeaders = headers.entrySet().stream().filter(e -> SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (filteredHeaders.isEmpty()) {
            try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin(client.threadPool().getThreadContext(), origin);){
                ActionResponse actionResponse = (ActionResponse)supplier.get();
                return (T)actionResponse;
            }
        }
        try (ThreadContext.StoredContext ignore = client.threadPool().getThreadContext().stashContext();){
            client.threadPool().getThreadContext().copyHeaders(filteredHeaders.entrySet());
            ActionResponse actionResponse = (ActionResponse)supplier.get();
            return (T)actionResponse;
        }
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> void executeWithHeadersAsync(Map<String, String> headers, String origin, Client client, Action<Response> action, Request request, ActionListener<Response> listener) {
        Map<String, String> filteredHeaders = headers.entrySet().stream().filter(e -> SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ThreadContext threadContext = client.threadPool().getThreadContext();
        if (filteredHeaders.isEmpty()) {
            ClientHelper.executeAsyncWithOrigin(client, origin, action, request, listener);
        } else {
            Supplier supplier = threadContext.newRestorableContext(false);
            try (ThreadContext.StoredContext ignore = ClientHelper.stashWithHeaders(threadContext, filteredHeaders);){
                client.execute(action, request, (ActionListener)new ContextPreservingActionListener(supplier, listener));
            }
        }
    }

    private static ThreadContext.StoredContext stashWithHeaders(ThreadContext threadContext, Map<String, String> headers) {
        ThreadContext.StoredContext storedContext = threadContext.stashContext();
        threadContext.copyHeaders(headers.entrySet());
        return storedContext;
    }
}

