/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.ParsedAggregation;
import org.elasticsearch.search.aggregations.metrics.Stats;

public class ParsedStats
extends ParsedAggregation
implements Stats {
    protected long count;
    protected double min;
    protected double max;
    protected double sum;
    protected double avg;
    protected final Map<String, String> valueAsString = new HashMap<String, String>();
    private static final ObjectParser<ParsedStats, Void> PARSER = new ObjectParser(ParsedStats.class.getSimpleName(), true, ParsedStats::new);

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public double getAvg() {
        return this.avg;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public String getMinAsString() {
        return this.valueAsString.getOrDefault("min_as_string", Double.toString(this.min));
    }

    @Override
    public String getMaxAsString() {
        return this.valueAsString.getOrDefault("max_as_string", Double.toString(this.max));
    }

    @Override
    public String getAvgAsString() {
        return this.valueAsString.getOrDefault("avg_as_string", Double.toString(this.avg));
    }

    @Override
    public String getSumAsString() {
        return this.valueAsString.getOrDefault("sum_as_string", Double.toString(this.sum));
    }

    @Override
    public String getType() {
        return "stats";
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("count", this.count);
        if (this.count != 0L) {
            builder.field("min", this.min);
            builder.field("max", this.max);
            builder.field("avg", this.avg);
            builder.field("sum", this.sum);
            if (this.valueAsString.get("min_as_string") != null) {
                builder.field("min_as_string", this.getMinAsString());
                builder.field("max_as_string", this.getMaxAsString());
                builder.field("avg_as_string", this.getAvgAsString());
                builder.field("sum_as_string", this.getSumAsString());
            }
        } else {
            builder.nullField("min");
            builder.nullField("max");
            builder.nullField("avg");
            builder.field("sum", 0.0);
        }
        this.otherStatsToXContent(builder, params);
        return builder;
    }

    protected static void declareStatsFields(ObjectParser<? extends ParsedStats, Void> objectParser) {
        ParsedStats.declareAggregationFields(objectParser);
        objectParser.declareLong((agg, value) -> {
            agg.count = value;
        }, new ParseField("count", new String[0]));
        objectParser.declareField((agg, value) -> {
            agg.min = value;
        }, (parser, context) -> ParsedStats.parseDouble(parser, Double.POSITIVE_INFINITY), new ParseField("min", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        objectParser.declareField((agg, value) -> {
            agg.max = value;
        }, (parser, context) -> ParsedStats.parseDouble(parser, Double.NEGATIVE_INFINITY), new ParseField("max", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        objectParser.declareField((agg, value) -> {
            agg.avg = value;
        }, (parser, context) -> ParsedStats.parseDouble(parser, 0.0), new ParseField("avg", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        objectParser.declareField((agg, value) -> {
            agg.sum = value;
        }, (parser, context) -> ParsedStats.parseDouble(parser, 0.0), new ParseField("sum", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        objectParser.declareString((agg, value) -> agg.valueAsString.put("min_as_string", (String)value), new ParseField("min_as_string", new String[0]));
        objectParser.declareString((agg, value) -> agg.valueAsString.put("max_as_string", (String)value), new ParseField("max_as_string", new String[0]));
        objectParser.declareString((agg, value) -> agg.valueAsString.put("avg_as_string", (String)value), new ParseField("avg_as_string", new String[0]));
        objectParser.declareString((agg, value) -> agg.valueAsString.put("sum_as_string", (String)value), new ParseField("sum_as_string", new String[0]));
    }

    public static ParsedStats fromXContent(XContentParser parser, String name) {
        ParsedStats parsedStats = PARSER.apply(parser, null);
        parsedStats.setName(name);
        return parsedStats;
    }

    protected XContentBuilder otherStatsToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    static {
        ParsedStats.declareStatsFields(PARSER);
    }
}

