/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public final class CardinalityAggregationBuilder
extends ValuesSourceAggregationBuilder.LeafOnly<ValuesSource, CardinalityAggregationBuilder> {
    public static final String NAME = "cardinality";
    private static final ParseField REHASH = new ParseField("rehash", new String[0]).withAllDeprecated("no replacement - values will always be rehashed");
    public static final ParseField PRECISION_THRESHOLD_FIELD = new ParseField("precision_threshold", new String[0]);
    private static final ObjectParser<CardinalityAggregationBuilder, Void> PARSER = new ObjectParser("cardinality");
    private Long precisionThreshold = null;

    public static AggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new CardinalityAggregationBuilder(aggregationName, null), null);
    }

    public CardinalityAggregationBuilder(String name, ValueType targetValueType) {
        super(name, ValuesSourceType.ANY, targetValueType);
    }

    public CardinalityAggregationBuilder(CardinalityAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.precisionThreshold = clone.precisionThreshold;
    }

    public CardinalityAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.ANY);
        if (in.readBoolean()) {
            this.precisionThreshold = in.readLong();
        }
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new CardinalityAggregationBuilder(this, factoriesBuilder, metaData);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        boolean hasPrecisionThreshold = this.precisionThreshold != null;
        out.writeBoolean(hasPrecisionThreshold);
        if (hasPrecisionThreshold) {
            out.writeLong(this.precisionThreshold);
        }
    }

    @Override
    protected boolean serializeTargetValueType() {
        return true;
    }

    public CardinalityAggregationBuilder precisionThreshold(long precisionThreshold) {
        if (precisionThreshold < 0L) {
            throw new IllegalArgumentException("[precisionThreshold] must be greater than or equal to 0. Found [" + precisionThreshold + "] in [" + this.name + "]");
        }
        this.precisionThreshold = precisionThreshold;
        return this;
    }

    public Long precisionThreshold() {
        return this.precisionThreshold;
    }

    @Deprecated
    public void rehash(boolean rehash) {
    }

    protected CardinalityAggregatorFactory innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new CardinalityAggregatorFactory(this.name, config, this.precisionThreshold, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.precisionThreshold != null) {
            builder.field(PRECISION_THRESHOLD_FIELD.getPreferredName(), this.precisionThreshold);
        }
        return builder;
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.precisionThreshold);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        CardinalityAggregationBuilder other = (CardinalityAggregationBuilder)obj;
        return Objects.equals(this.precisionThreshold, other.precisionThreshold);
    }

    @Override
    public String getType() {
        return NAME;
    }

    static {
        ValuesSourceParserHelper.declareAnyFields(PARSER, true, false);
        PARSER.declareLong(CardinalityAggregationBuilder::precisionThreshold, PRECISION_THRESHOLD_FIELD);
        PARSER.declareLong((b, v) -> {}, REHASH);
    }
}

