/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;

public class NodeRemovalClusterStateTaskExecutor
implements ClusterStateTaskExecutor<Task>,
ClusterStateTaskListener {
    private final AllocationService allocationService;
    private final Logger logger;

    public NodeRemovalClusterStateTaskExecutor(AllocationService allocationService, Logger logger) {
        this.allocationService = allocationService;
        this.logger = logger;
    }

    @Override
    public ClusterStateTaskExecutor.ClusterTasksResult<Task> execute(ClusterState currentState, List<Task> tasks) throws Exception {
        DiscoveryNodes.Builder remainingNodesBuilder = DiscoveryNodes.builder(currentState.nodes());
        boolean removed = false;
        for (Task task : tasks) {
            if (currentState.nodes().nodeExists(task.node())) {
                remainingNodesBuilder.remove(task.node());
                removed = true;
                continue;
            }
            this.logger.debug("node [{}] does not exist in cluster state, ignoring", (Object)task);
        }
        if (!removed) {
            return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(currentState);
        }
        ClusterState remainingNodesClusterState = this.remainingNodesClusterState(currentState, remainingNodesBuilder);
        return this.getTaskClusterTasksResult(currentState, tasks, remainingNodesClusterState);
    }

    protected ClusterStateTaskExecutor.ClusterTasksResult<Task> getTaskClusterTasksResult(ClusterState currentState, List<Task> tasks, ClusterState remainingNodesClusterState) {
        ClusterStateTaskExecutor.ClusterTasksResult.Builder<Task> resultBuilder = ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks);
        return resultBuilder.build(this.allocationService.deassociateDeadNodes(remainingNodesClusterState, true, this.describeTasks(tasks)));
    }

    protected ClusterState remainingNodesClusterState(ClusterState currentState, DiscoveryNodes.Builder remainingNodesBuilder) {
        return ClusterState.builder(currentState).nodes(remainingNodesBuilder).build();
    }

    @Override
    public void onFailure(String source, Exception e) {
        this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
    }

    @Override
    public void onNoLongerMaster(String source) {
        this.logger.debug("no longer master while processing node removal [{}]", (Object)source);
    }

    public static class Task {
        private final DiscoveryNode node;
        private final String reason;

        public Task(DiscoveryNode node, String reason) {
            this.node = node;
            this.reason = reason;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public String reason() {
            return this.reason;
        }

        public String toString() {
            return this.node + " " + this.reason;
        }
    }
}

