/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.coordination.CoordinationMetaData;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.coordination.JoinHelper;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.discovery.zen.ElectMasterService;
import org.elasticsearch.discovery.zen.UnicastZenPing;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.discovery.zen.ZenPing;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class DiscoveryUpgradeService {
    private static Logger logger = LogManager.getLogger(DiscoveryUpgradeService.class);
    public static final Setting<TimeValue> BWC_PING_TIMEOUT_SETTING = Setting.timeSetting("discovery.zen.bwc_ping_timeout", ZenDiscovery.PING_TIMEOUT_SETTING, TimeValue.timeValueMillis(1L), Setting.Property.NodeScope);
    public static final Setting<Boolean> ENABLE_UNSAFE_BOOTSTRAPPING_ON_UPGRADE_SETTING = Setting.boolSetting("discovery.zen.unsafe_rolling_upgrades_enabled", true, Setting.Property.NodeScope);
    private final ElectMasterService electMasterService;
    private final TransportService transportService;
    private final BooleanSupplier isBootstrappedSupplier;
    private final JoinHelper joinHelper;
    private final Supplier<Iterable<DiscoveryNode>> peersSupplier;
    private final Consumer<CoordinationMetaData.VotingConfiguration> initialConfigurationConsumer;
    private final TimeValue bwcPingTimeout;
    private final boolean enableUnsafeBootstrappingOnUpgrade;
    private final ClusterName clusterName;
    @Nullable
    private volatile JoiningRound joiningRound;

    public DiscoveryUpgradeService(Settings settings, ClusterSettings clusterSettings, TransportService transportService, BooleanSupplier isBootstrappedSupplier, JoinHelper joinHelper, Supplier<Iterable<DiscoveryNode>> peersSupplier, Consumer<CoordinationMetaData.VotingConfiguration> initialConfigurationConsumer) {
        assert (Version.CURRENT.major == Version.V_6_6_0.major + 1) : "remove this service once unsafe upgrades are no longer needed";
        this.electMasterService = new ElectMasterService(settings);
        this.transportService = transportService;
        this.isBootstrappedSupplier = isBootstrappedSupplier;
        this.joinHelper = joinHelper;
        this.peersSupplier = peersSupplier;
        this.initialConfigurationConsumer = initialConfigurationConsumer;
        this.bwcPingTimeout = BWC_PING_TIMEOUT_SETTING.get(settings);
        this.enableUnsafeBootstrappingOnUpgrade = ENABLE_UNSAFE_BOOTSTRAPPING_ON_UPGRADE_SETTING.get(settings);
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING, this.electMasterService::minimumMasterNodes);
    }

    public void activate(Optional<DiscoveryNode> lastKnownLeader) {
        if (this.isBootstrappedSupplier.getAsBoolean()) {
            return;
        }
        assert (!lastKnownLeader.isPresent() || Coordinator.isZen1Node(lastKnownLeader.get())) : lastKnownLeader;
        assert (this.joiningRound == null) : this.joiningRound;
        this.joiningRound = new JoiningRound(lastKnownLeader.isPresent());
        this.joiningRound.scheduleNextAttempt();
    }

    public void deactivate() {
        this.joiningRound = null;
    }

    public static DiscoveryNode createDiscoveryNodeWithImpossiblyHighId(DiscoveryNode node) {
        return new DiscoveryNode(node.getName(), "{zen2}" + node.getId(), node.getEphemeralId(), node.getHostName(), node.getHostAddress(), node.getAddress(), node.getAttributes(), node.getRoles(), node.getVersion());
    }

    private class JoiningRound {
        private final boolean upgrading;

        JoiningRound(boolean upgrading) {
            this.upgrading = upgrading;
        }

        private boolean isRunning() {
            return DiscoveryUpgradeService.this.joiningRound == this && !DiscoveryUpgradeService.this.isBootstrappedSupplier.getAsBoolean();
        }

        void scheduleNextAttempt() {
            if (!this.isRunning()) {
                return;
            }
            ThreadPool threadPool = DiscoveryUpgradeService.this.transportService.getThreadPool();
            threadPool.scheduleUnlessShuttingDown(DiscoveryUpgradeService.this.bwcPingTimeout, "same", new Runnable(){

                @Override
                public void run() {
                    if (!JoiningRound.this.isRunning()) {
                        return;
                    }
                    Set<DiscoveryNode> discoveryNodes = Stream.concat(StreamSupport.stream(((Iterable)DiscoveryUpgradeService.this.peersSupplier.get()).spliterator(), false), Stream.of(DiscoveryUpgradeService.this.transportService.getLocalNode())).filter(DiscoveryNode::isMasterNode).collect(Collectors.toSet());
                    logger.debug("nodes: {}", (Object)discoveryNodes);
                    if (DiscoveryUpgradeService.this.electMasterService.hasEnoughMasterNodes(discoveryNodes)) {
                        if (discoveryNodes.stream().anyMatch(Coordinator::isZen1Node)) {
                            this.electBestOldMaster(discoveryNodes);
                        } else if (JoiningRound.this.upgrading && DiscoveryUpgradeService.this.enableUnsafeBootstrappingOnUpgrade) {
                            DiscoveryUpgradeService.this.transportService.getThreadPool().generic().execute(() -> {
                                try {
                                    DiscoveryUpgradeService.this.initialConfigurationConsumer.accept(new CoordinationMetaData.VotingConfiguration(discoveryNodes.stream().map(DiscoveryNode::getId).collect(Collectors.toSet())));
                                }
                                catch (Exception e) {
                                    logger.debug("exception during bootstrapping upgrade, retrying", (Throwable)e);
                                }
                                finally {
                                    JoiningRound.this.scheduleNextAttempt();
                                }
                            });
                        } else {
                            JoiningRound.this.scheduleNextAttempt();
                        }
                    } else {
                        JoiningRound.this.scheduleNextAttempt();
                    }
                }

                private void electBestOldMaster(final Set<DiscoveryNode> discoveryNodes) {
                    final Set masterCandidates = ConcurrentCollections.newConcurrentSet();
                    final ListenableCountDown listenableCountDown = new ListenableCountDown(discoveryNodes.size(), new ActionListener<Void>(){

                        @Override
                        public void onResponse(Void value) {
                            assert (masterCandidates.size() == discoveryNodes.size()) : masterCandidates + " does not match " + discoveryNodes;
                            if (JoiningRound.this.isRunning()) {
                                ElectMasterService.MasterCandidate electedMaster = DiscoveryUpgradeService.this.electMasterService.electMaster(masterCandidates);
                                logger.debug("elected {}, sending join", (Object)electedMaster);
                                DiscoveryUpgradeService.this.joinHelper.sendJoinRequest(electedMaster.getNode(), Optional.empty(), JoiningRound.this::scheduleNextAttempt);
                            }
                        }

                        @Override
                        public void onFailure(Exception e) {
                            JoiningRound.this.scheduleNextAttempt();
                        }
                    });
                    boolean foundOldMaster = false;
                    for (final DiscoveryNode discoveryNode : discoveryNodes) {
                        assert (discoveryNode.isMasterNode()) : discoveryNode;
                        if (Coordinator.isZen1Node(discoveryNode)) {
                            foundOldMaster = true;
                            DiscoveryUpgradeService.this.transportService.sendRequest(discoveryNode, "internal:discovery/zen/unicast", (TransportRequest)new UnicastZenPing.UnicastPingRequest(0, TimeValue.ZERO, new ZenPing.PingResponse(DiscoveryUpgradeService.createDiscoveryNodeWithImpossiblyHighId(DiscoveryUpgradeService.this.transportService.getLocalNode()), null, DiscoveryUpgradeService.this.clusterName, -1L)), TransportRequestOptions.builder().withTimeout(DiscoveryUpgradeService.this.bwcPingTimeout).build(), new TransportResponseHandler<UnicastZenPing.UnicastPingResponse>(){

                                @Override
                                public void handleResponse(UnicastZenPing.UnicastPingResponse response) {
                                    long clusterStateVersion = -1L;
                                    for (ZenPing.PingResponse pingResponse : response.pingResponses) {
                                        if (!discoveryNode.equals(pingResponse.node())) continue;
                                        clusterStateVersion = Math.max(clusterStateVersion, pingResponse.getClusterStateVersion());
                                    }
                                    masterCandidates.add(new ElectMasterService.MasterCandidate(discoveryNode, clusterStateVersion));
                                    listenableCountDown.countDown();
                                }

                                @Override
                                public void handleException(TransportException exp) {
                                    logger.debug(new ParameterizedMessage("unexpected exception when pinging {}", (Object)discoveryNode), (Throwable)exp);
                                    listenableCountDown.onFailure(exp);
                                }

                                @Override
                                public String executor() {
                                    return "same";
                                }

                                @Override
                                public UnicastZenPing.UnicastPingResponse read(StreamInput in) throws IOException {
                                    return new UnicastZenPing.UnicastPingResponse(in);
                                }
                            });
                            continue;
                        }
                        masterCandidates.add(new ElectMasterService.MasterCandidate(DiscoveryUpgradeService.createDiscoveryNodeWithImpossiblyHighId(discoveryNode), -1L));
                        listenableCountDown.countDown();
                    }
                    assert (foundOldMaster);
                }

                public String toString() {
                    return "discovery upgrade service retry";
                }
            });
        }
    }

    private static class ListenableCountDown {
        private final CountDown countDown;
        private final ActionListener<Void> listener;

        ListenableCountDown(int count, ActionListener<Void> listener) {
            this.countDown = new CountDown(count);
            this.listener = listener;
        }

        void onFailure(Exception e) {
            if (this.countDown.fastForward()) {
                this.listener.onFailure(e);
            }
        }

        void countDown() {
            if (this.countDown.countDown()) {
                this.listener.onResponse(null);
            }
        }
    }
}

