/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.bootstrap.BootstrapConfiguration;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.coordination.ApplyCommitRequest;
import org.elasticsearch.cluster.coordination.ClusterAlreadyBootstrappedException;
import org.elasticsearch.cluster.coordination.ClusterBootstrapService;
import org.elasticsearch.cluster.coordination.ClusterFormationFailureHelper;
import org.elasticsearch.cluster.coordination.ClusterStatePublisher;
import org.elasticsearch.cluster.coordination.CoordinationMetaData;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.DiscoveryUpgradeService;
import org.elasticsearch.cluster.coordination.ElectionSchedulerFactory;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.coordination.FollowersChecker;
import org.elasticsearch.cluster.coordination.Join;
import org.elasticsearch.cluster.coordination.JoinHelper;
import org.elasticsearch.cluster.coordination.JoinRequest;
import org.elasticsearch.cluster.coordination.LagDetector;
import org.elasticsearch.cluster.coordination.LeaderChecker;
import org.elasticsearch.cluster.coordination.NodeRemovalClusterStateTaskExecutor;
import org.elasticsearch.cluster.coordination.PreVoteCollector;
import org.elasticsearch.cluster.coordination.PreVoteResponse;
import org.elasticsearch.cluster.coordination.Publication;
import org.elasticsearch.cluster.coordination.PublicationTransportHandler;
import org.elasticsearch.cluster.coordination.PublishRequest;
import org.elasticsearch.cluster.coordination.PublishResponse;
import org.elasticsearch.cluster.coordination.PublishWithJoinResponse;
import org.elasticsearch.cluster.coordination.Reconfigurator;
import org.elasticsearch.cluster.coordination.StartJoinRequest;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.DiscoveryStats;
import org.elasticsearch.discovery.HandshakingTransportAddressConnector;
import org.elasticsearch.discovery.PeerFinder;
import org.elasticsearch.discovery.UnicastConfiguredHostsResolver;
import org.elasticsearch.discovery.zen.PendingClusterStateStats;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class Coordinator
extends AbstractLifecycleComponent
implements Discovery {
    public static final long ZEN1_BWC_TERM = 0L;
    private static final Logger logger = LogManager.getLogger(Coordinator.class);
    public static final Setting<TimeValue> PUBLISH_TIMEOUT_SETTING = Setting.timeSetting("cluster.publish.timeout", TimeValue.timeValueMillis(30000L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope);
    private final Settings settings;
    private final TransportService transportService;
    private final MasterService masterService;
    private final JoinHelper joinHelper;
    private final NodeRemovalClusterStateTaskExecutor nodeRemovalExecutor;
    private final Supplier<CoordinationState.PersistedState> persistedStateSupplier;
    private final DiscoverySettings discoverySettings;
    final Object mutex = new Object();
    final SetOnce<CoordinationState> coordinationState = new SetOnce();
    private volatile ClusterState applierState;
    private final PeerFinder peerFinder;
    private final PreVoteCollector preVoteCollector;
    private final ElectionSchedulerFactory electionSchedulerFactory;
    private final UnicastConfiguredHostsResolver configuredHostsResolver;
    private final TimeValue publishTimeout;
    private final PublicationTransportHandler publicationHandler;
    private final LeaderChecker leaderChecker;
    private final FollowersChecker followersChecker;
    private final ClusterApplier clusterApplier;
    @Nullable
    private Releasable electionScheduler;
    @Nullable
    private Releasable prevotingRound;
    private long maxTermSeen;
    private final Reconfigurator reconfigurator;
    private final ClusterBootstrapService clusterBootstrapService;
    private final DiscoveryUpgradeService discoveryUpgradeService;
    private final LagDetector lagDetector;
    private final ClusterFormationFailureHelper clusterFormationFailureHelper;
    private Mode mode;
    private Optional<DiscoveryNode> lastKnownLeader;
    private Optional<Join> lastJoin;
    private JoinHelper.JoinAccumulator joinAccumulator;
    private Optional<CoordinatorPublication> currentPublication = Optional.empty();
    private final Set<ActionListener<Iterable<DiscoveryNode>>> discoveredNodesListeners = ConcurrentCollections.newConcurrentSet();
    private AtomicBoolean reconfigurationTaskScheduled = new AtomicBoolean();

    public Coordinator(String nodeName, Settings settings, ClusterSettings clusterSettings, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, AllocationService allocationService, MasterService masterService, Supplier<CoordinationState.PersistedState> persistedStateSupplier, UnicastHostsProvider unicastHostsProvider, ClusterApplier clusterApplier, Random random) {
        super(settings);
        this.settings = settings;
        this.transportService = transportService;
        this.masterService = masterService;
        this.joinHelper = new JoinHelper(settings, allocationService, masterService, transportService, this::getCurrentTerm, this::handleJoinRequest, this::joinLeaderInTerm);
        this.persistedStateSupplier = persistedStateSupplier;
        this.discoverySettings = new DiscoverySettings(settings, clusterSettings);
        this.lastKnownLeader = Optional.empty();
        this.lastJoin = Optional.empty();
        this.joinAccumulator = new JoinHelper.InitialJoinAccumulator();
        this.publishTimeout = PUBLISH_TIMEOUT_SETTING.get(settings);
        this.electionSchedulerFactory = new ElectionSchedulerFactory(settings, random, transportService.getThreadPool());
        this.preVoteCollector = new PreVoteCollector(transportService, this::startElection, this::updateMaxTermSeen);
        this.configuredHostsResolver = new UnicastConfiguredHostsResolver(nodeName, settings, transportService, unicastHostsProvider);
        this.peerFinder = new CoordinatorPeerFinder(settings, transportService, new HandshakingTransportAddressConnector(settings, transportService), this.configuredHostsResolver);
        this.publicationHandler = new PublicationTransportHandler(transportService, namedWriteableRegistry, this::handlePublishRequest, this::handleApplyCommit);
        this.leaderChecker = new LeaderChecker(settings, transportService, this.getOnLeaderFailure());
        this.followersChecker = new FollowersChecker(settings, transportService, this::onFollowerCheckRequest, this::removeNode);
        this.nodeRemovalExecutor = new NodeRemovalClusterStateTaskExecutor(allocationService, logger);
        this.clusterApplier = clusterApplier;
        masterService.setClusterStateSupplier(this::getStateForMasterService);
        this.reconfigurator = new Reconfigurator(settings, clusterSettings);
        this.clusterBootstrapService = new ClusterBootstrapService(settings, transportService);
        this.discoveryUpgradeService = new DiscoveryUpgradeService(settings, clusterSettings, transportService, this::isInitialConfigurationSet, this.joinHelper, this.peerFinder::getFoundPeers, this::unsafelySetConfigurationForUpgrade);
        this.lagDetector = new LagDetector(settings, transportService.getThreadPool(), n -> this.removeNode((DiscoveryNode)n, "lagging"), transportService::getLocalNode);
        this.clusterFormationFailureHelper = new ClusterFormationFailureHelper(settings, this::getClusterFormationState, transportService.getThreadPool());
    }

    private ClusterFormationFailureHelper.ClusterFormationState getClusterFormationState() {
        return new ClusterFormationFailureHelper.ClusterFormationState(this.settings, this.getStateForMasterService(), this.peerFinder.getLastResolvedAddresses(), StreamSupport.stream(this.peerFinder.getFoundPeers().spliterator(), false).collect(Collectors.toList()));
    }

    private Runnable getOnLeaderFailure() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = Coordinator.this.mutex;
                synchronized (object) {
                    Coordinator.this.becomeCandidate("onLeaderFailure");
                }
            }

            public String toString() {
                return "notification of leader failure";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNode(DiscoveryNode discoveryNode, String reason) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.mode == Mode.LEADER) {
                this.masterService.submitStateUpdateTask("node-left", new NodeRemovalClusterStateTaskExecutor.Task(discoveryNode, reason), ClusterStateTaskConfig.build(Priority.IMMEDIATE), this.nodeRemovalExecutor, this.nodeRemovalExecutor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFollowerCheckRequest(FollowersChecker.FollowerCheckRequest followerCheckRequest) {
        Object object = this.mutex;
        synchronized (object) {
            long previousTerm = this.getCurrentTerm();
            this.ensureTermAtLeast(followerCheckRequest.getSender(), followerCheckRequest.getTerm());
            if (this.getCurrentTerm() != followerCheckRequest.getTerm()) {
                logger.trace("onFollowerCheckRequest: current term is [{}], rejecting {}", (Object)this.getCurrentTerm(), (Object)followerCheckRequest);
                throw new CoordinationStateRejectedException("onFollowerCheckRequest: current term is [" + this.getCurrentTerm() + "], rejecting " + followerCheckRequest, new Object[0]);
            }
            if (previousTerm != this.getCurrentTerm()) {
                this.becomeFollower("onFollowerCheckRequest", followerCheckRequest.getSender());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleApplyCommit(ApplyCommitRequest applyCommitRequest, final ActionListener<Void> applyListener) {
        Object object = this.mutex;
        synchronized (object) {
            logger.trace("handleApplyCommit: applying commit {}", (Object)applyCommitRequest);
            this.coordinationState.get().handleCommit(applyCommitRequest);
            ClusterState committedState = ClusterStateUpdaters.hideStateIfNotRecovered(this.coordinationState.get().getLastAcceptedState());
            ClusterState clusterState = this.applierState = this.mode == Mode.CANDIDATE ? this.clusterStateWithNoMasterBlock(committedState) : committedState;
            if (applyCommitRequest.getSourceNode().equals(this.getLocalNode())) {
                applyListener.onResponse(null);
            } else {
                this.clusterApplier.onNewClusterState(applyCommitRequest.toString(), () -> this.applierState, new ClusterApplier.ClusterApplyListener(){

                    @Override
                    public void onFailure(String source, Exception e) {
                        applyListener.onFailure(e);
                    }

                    @Override
                    public void onSuccess(String source) {
                        applyListener.onResponse(null);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PublishWithJoinResponse handlePublishRequest(PublishRequest publishRequest) {
        assert (publishRequest.getAcceptedState().nodes().getLocalNode().equals(this.getLocalNode())) : publishRequest.getAcceptedState().nodes().getLocalNode() + " != " + this.getLocalNode();
        Object object = this.mutex;
        synchronized (object) {
            DiscoveryNode sourceNode = publishRequest.getAcceptedState().nodes().getMasterNode();
            logger.trace("handlePublishRequest: handling [{}] from [{}]", (Object)publishRequest, (Object)sourceNode);
            if (sourceNode.equals(this.getLocalNode()) && this.mode != Mode.LEADER) {
                throw new CoordinationStateRejectedException("no longer leading this publication's term: " + publishRequest, new Object[0]);
            }
            if (publishRequest.getAcceptedState().term() == 0L && this.getCurrentTerm() == 0L && this.mode == Mode.FOLLOWER && !Optional.of(sourceNode).equals(this.lastKnownLeader)) {
                logger.debug("received cluster state from {} but currently following {}, rejecting", (Object)sourceNode, (Object)this.lastKnownLeader);
                throw new CoordinationStateRejectedException("received cluster state from " + sourceNode + " but currently following " + this.lastKnownLeader + ", rejecting", new Object[0]);
            }
            this.ensureTermAtLeast(sourceNode, publishRequest.getAcceptedState().term());
            PublishResponse publishResponse = this.coordinationState.get().handlePublishRequest(publishRequest);
            if (sourceNode.equals(this.getLocalNode())) {
                this.preVoteCollector.update(this.getPreVoteResponse(), this.getLocalNode());
            } else {
                this.becomeFollower("handlePublishRequest", sourceNode);
            }
            if (this.isInitialConfigurationSet()) {
                for (ActionListener<Iterable<DiscoveryNode>> discoveredNodesListener : this.discoveredNodesListeners) {
                    discoveredNodesListener.onFailure(new ClusterAlreadyBootstrappedException());
                }
            }
            return new PublishWithJoinResponse(publishResponse, Coordinator.joinWithDestination(this.lastJoin, sourceNode, publishRequest.getAcceptedState().term()));
        }
    }

    private static Optional<Join> joinWithDestination(Optional<Join> lastJoin, DiscoveryNode leader, long term) {
        if (lastJoin.isPresent() && lastJoin.get().getTargetNode().getId().equals(leader.getId()) && lastJoin.get().getTerm() == term) {
            return lastJoin;
        }
        return Optional.empty();
    }

    private void closePrevotingAndElectionScheduler() {
        if (this.prevotingRound != null) {
            this.prevotingRound.close();
            this.prevotingRound = null;
        }
        if (this.electionScheduler != null) {
            this.electionScheduler.close();
            this.electionScheduler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMaxTermSeen(long term) {
        Object object = this.mutex;
        synchronized (object) {
            this.maxTermSeen = Math.max(this.maxTermSeen, term);
            long currentTerm = this.getCurrentTerm();
            if (this.mode == Mode.LEADER && this.maxTermSeen > currentTerm) {
                if (this.publicationInProgress()) {
                    logger.debug("updateMaxTermSeen: maxTermSeen = {} > currentTerm = {}, enqueueing term bump", (Object)this.maxTermSeen, (Object)currentTerm);
                } else {
                    try {
                        this.ensureTermAtLeast(this.getLocalNode(), this.maxTermSeen);
                        this.startElection();
                    }
                    catch (Exception e) {
                        logger.warn(new ParameterizedMessage("failed to bump term to {}", (Object)this.maxTermSeen), (Throwable)e);
                        this.becomeCandidate("updateMaxTermSeen");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startElection() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.mode == Mode.CANDIDATE) {
                StartJoinRequest startJoinRequest = new StartJoinRequest(this.getLocalNode(), Math.max(this.getCurrentTerm(), this.maxTermSeen) + 1L);
                logger.debug("starting election with {}", (Object)startJoinRequest);
                this.getDiscoveredNodes().forEach(node -> {
                    if (!Coordinator.isZen1Node(node)) {
                        this.joinHelper.sendStartJoinRequest(startJoinRequest, (DiscoveryNode)node);
                    }
                });
            }
        }
    }

    private Optional<Join> ensureTermAtLeast(DiscoveryNode sourceNode, long targetTerm) {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        if (this.getCurrentTerm() < targetTerm) {
            return Optional.of(this.joinLeaderInTerm(new StartJoinRequest(sourceNode, targetTerm)));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Join joinLeaderInTerm(StartJoinRequest startJoinRequest) {
        Object object = this.mutex;
        synchronized (object) {
            logger.debug("joinLeaderInTerm: for [{}] with term {}", (Object)startJoinRequest.getSourceNode(), (Object)startJoinRequest.getTerm());
            Join join = this.coordinationState.get().handleStartJoin(startJoinRequest);
            this.lastJoin = Optional.of(join);
            this.peerFinder.setCurrentTerm(this.getCurrentTerm());
            if (this.mode != Mode.CANDIDATE) {
                this.becomeCandidate("joinLeaderInTerm");
            } else {
                this.followersChecker.updateFastResponseState(this.getCurrentTerm(), this.mode);
                this.preVoteCollector.update(this.getPreVoteResponse(), null);
            }
            return join;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJoinRequest(JoinRequest joinRequest, JoinHelper.JoinCallback joinCallback) {
        assert (!Thread.holdsLock(this.mutex));
        assert (this.getLocalNode().isMasterNode()) : this.getLocalNode() + " received a join but is not master-eligible";
        logger.trace("handleJoinRequest: as {}, handling {}", (Object)this.mode, (Object)joinRequest);
        this.transportService.connectToNode(joinRequest.getSourceNode());
        Optional<Join> optionalJoin = joinRequest.getOptionalJoin();
        Object object = this.mutex;
        synchronized (object) {
            CoordinationState coordState = this.coordinationState.get();
            boolean prevElectionWon = coordState.electionWon();
            optionalJoin.ifPresent(this::handleJoin);
            this.joinAccumulator.handleJoinRequest(joinRequest.getSourceNode(), joinCallback);
            if (!prevElectionWon && coordState.electionWon()) {
                this.becomeLeader("handleJoinRequest");
            }
        }
    }

    void becomeCandidate(String method) {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        logger.debug("{}: becoming CANDIDATE (was {}, lastKnownLeader was [{}])", (Object)method, (Object)this.mode, (Object)this.lastKnownLeader);
        if (this.mode != Mode.CANDIDATE) {
            this.mode = Mode.CANDIDATE;
            this.cancelActivePublication();
            this.joinAccumulator.close(this.mode);
            this.joinAccumulator = new JoinHelper.CandidateJoinAccumulator(this.joinHelper);
            this.peerFinder.activate(this.coordinationState.get().getLastAcceptedState().nodes());
            this.clusterFormationFailureHelper.start();
            if (this.getCurrentTerm() == 0L) {
                this.discoveryUpgradeService.activate(this.lastKnownLeader);
            }
            this.leaderChecker.setCurrentNodes(DiscoveryNodes.EMPTY_NODES);
            this.leaderChecker.updateLeader(null);
            this.followersChecker.clearCurrentNodes();
            this.followersChecker.updateFastResponseState(this.getCurrentTerm(), this.mode);
            this.lagDetector.clearTrackedNodes();
            if (this.applierState.nodes().getMasterNodeId() != null) {
                this.applierState = this.clusterStateWithNoMasterBlock(this.applierState);
                this.clusterApplier.onNewClusterState("becoming candidate: " + method, () -> this.applierState, (source, e) -> {});
            }
        }
        this.preVoteCollector.update(this.getPreVoteResponse(), null);
    }

    void becomeLeader(String method) {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        assert (this.mode == Mode.CANDIDATE) : "expected candidate but was " + (Object)((Object)this.mode);
        assert (this.getLocalNode().isMasterNode()) : this.getLocalNode() + " became a leader but is not master-eligible";
        logger.debug("{}: becoming LEADER (was {}, lastKnownLeader was [{}])", (Object)method, (Object)this.mode, (Object)this.lastKnownLeader);
        this.mode = Mode.LEADER;
        this.joinAccumulator.close(this.mode);
        this.joinAccumulator = new JoinHelper.LeaderJoinAccumulator(this.joinHelper);
        this.lastKnownLeader = Optional.of(this.getLocalNode());
        this.peerFinder.deactivate(this.getLocalNode());
        this.discoveryUpgradeService.deactivate();
        this.clusterFormationFailureHelper.stop();
        this.closePrevotingAndElectionScheduler();
        this.preVoteCollector.update(this.getPreVoteResponse(), this.getLocalNode());
        assert (this.leaderChecker.leader() == null) : this.leaderChecker.leader();
        this.followersChecker.updateFastResponseState(this.getCurrentTerm(), this.mode);
    }

    void becomeFollower(String method, DiscoveryNode leaderNode) {
        boolean restartLeaderChecker;
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        assert (leaderNode.isMasterNode()) : leaderNode + " became a leader but is not master-eligible";
        logger.debug("{}: becoming FOLLOWER of [{}] (was {}, lastKnownLeader was [{}])", (Object)method, (Object)leaderNode, (Object)this.mode, (Object)this.lastKnownLeader);
        boolean bl = restartLeaderChecker = !(this.mode == Mode.FOLLOWER && Optional.of(leaderNode).equals(this.lastKnownLeader));
        if (this.mode != Mode.FOLLOWER) {
            this.mode = Mode.FOLLOWER;
            this.joinAccumulator.close(this.mode);
            this.joinAccumulator = new JoinHelper.FollowerJoinAccumulator();
            this.leaderChecker.setCurrentNodes(DiscoveryNodes.EMPTY_NODES);
        }
        this.lastKnownLeader = Optional.of(leaderNode);
        this.peerFinder.deactivate(leaderNode);
        this.discoveryUpgradeService.deactivate();
        this.clusterFormationFailureHelper.stop();
        this.closePrevotingAndElectionScheduler();
        this.cancelActivePublication();
        this.preVoteCollector.update(this.getPreVoteResponse(), leaderNode);
        if (restartLeaderChecker) {
            this.leaderChecker.updateLeader(leaderNode);
        }
        this.followersChecker.clearCurrentNodes();
        this.followersChecker.updateFastResponseState(this.getCurrentTerm(), this.mode);
        this.lagDetector.clearTrackedNodes();
    }

    private PreVoteResponse getPreVoteResponse() {
        return new PreVoteResponse(this.getCurrentTerm(), this.coordinationState.get().getLastAcceptedTerm(), this.coordinationState.get().getLastAcceptedVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCurrentTerm() {
        Object object = this.mutex;
        synchronized (object) {
            return this.coordinationState.get().getCurrentTerm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Mode getMode() {
        Object object = this.mutex;
        synchronized (object) {
            return this.mode;
        }
    }

    public DiscoveryNode getLocalNode() {
        return this.transportService.getLocalNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean publicationInProgress() {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentPublication.isPresent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        Object object = this.mutex;
        synchronized (object) {
            ClusterState initialState;
            CoordinationState.PersistedState persistedState = this.persistedStateSupplier.get();
            this.coordinationState.set(new CoordinationState(this.settings, this.getLocalNode(), persistedState));
            this.peerFinder.setCurrentTerm(this.getCurrentTerm());
            this.configuredHostsResolver.start();
            this.applierState = initialState = ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.get(this.settings)).blocks(ClusterBlocks.builder().addGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK).addGlobalBlock(this.discoverySettings.getNoMasterBlock())).nodes(DiscoveryNodes.builder().add(this.getLocalNode()).localNodeId(this.getLocalNode().getId())).build();
            this.clusterApplier.setInitialState(initialState);
        }
    }

    @Override
    public DiscoveryStats stats() {
        return new DiscoveryStats(new PendingClusterStateStats(0, 0, 0), this.publicationHandler.stats());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startInitialJoin() {
        Object object = this.mutex;
        synchronized (object) {
            this.becomeCandidate("startInitialJoin");
        }
        if (!this.isInitialConfigurationSet()) {
            this.clusterBootstrapService.start();
        }
    }

    @Override
    protected void doStop() {
        this.configuredHostsResolver.stop();
        this.clusterBootstrapService.stop();
    }

    @Override
    protected void doClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invariant() {
        Object object = this.mutex;
        synchronized (object) {
            Optional<DiscoveryNode> peerFinderLeader = this.peerFinder.getLeader();
            assert (this.peerFinder.getCurrentTerm() == this.getCurrentTerm());
            assert (this.followersChecker.getFastResponseState().term == this.getCurrentTerm()) : this.followersChecker.getFastResponseState();
            assert (this.followersChecker.getFastResponseState().mode == this.getMode()) : this.followersChecker.getFastResponseState();
            assert (this.applierState.nodes().getMasterNodeId() == null == this.applierState.blocks().hasGlobalBlock(2));
            assert (this.preVoteCollector.getPreVoteResponse().equals(this.getPreVoteResponse())) : this.preVoteCollector + " vs " + this.getPreVoteResponse();
            assert (!this.lagDetector.getTrackedNodes().contains(this.getLocalNode())) : this.lagDetector.getTrackedNodes();
            assert (this.followersChecker.getKnownFollowers().equals(this.lagDetector.getTrackedNodes())) : this.followersChecker.getKnownFollowers() + " vs " + this.lagDetector.getTrackedNodes();
            if (this.mode == Mode.LEADER) {
                boolean becomingMaster;
                boolean bl = becomingMaster = this.getStateForMasterService().term() != this.getCurrentTerm();
                assert (this.coordinationState.get().electionWon());
                assert (this.lastKnownLeader.isPresent() && this.lastKnownLeader.get().equals(this.getLocalNode()));
                assert (this.joinAccumulator instanceof JoinHelper.LeaderJoinAccumulator);
                assert (peerFinderLeader.equals(this.lastKnownLeader)) : peerFinderLeader;
                assert (this.electionScheduler == null) : this.electionScheduler;
                assert (this.prevotingRound == null) : this.prevotingRound;
                assert (becomingMaster || this.getStateForMasterService().nodes().getMasterNodeId() != null) : this.getStateForMasterService();
                assert (this.leaderChecker.leader() == null) : this.leaderChecker.leader();
                assert (this.applierState.nodes().getMasterNodeId() == null || this.getLocalNode().equals(this.applierState.nodes().getMasterNode()));
                assert (this.preVoteCollector.getLeader() == this.getLocalNode()) : this.preVoteCollector;
                assert (!this.clusterFormationFailureHelper.isRunning());
                boolean activePublication = this.currentPublication.map(CoordinatorPublication::isActiveForCurrentLeader).orElse(false);
                if (becomingMaster && !activePublication) {
                    assert (this.followersChecker.getKnownFollowers().isEmpty()) : this.followersChecker.getKnownFollowers();
                } else {
                    ClusterState lastPublishedState = activePublication ? this.currentPublication.get().publishedState() : this.coordinationState.get().getLastAcceptedState();
                    HashSet lastPublishedNodes = new HashSet();
                    lastPublishedState.nodes().forEach(lastPublishedNodes::add);
                    assert (lastPublishedNodes.remove(this.getLocalNode()));
                    assert (lastPublishedNodes.equals(this.followersChecker.getKnownFollowers())) : lastPublishedNodes + " != " + this.followersChecker.getKnownFollowers();
                }
                assert (becomingMaster || activePublication || this.coordinationState.get().getLastAcceptedConfiguration().equals(this.coordinationState.get().getLastCommittedConfiguration())) : this.coordinationState.get().getLastAcceptedConfiguration() + " != " + this.coordinationState.get().getLastCommittedConfiguration();
            } else if (this.mode == Mode.FOLLOWER) {
                assert (!this.coordinationState.get().electionWon()) : this.getLocalNode() + " is FOLLOWER so electionWon() should be false";
                assert (this.lastKnownLeader.isPresent() && !this.lastKnownLeader.get().equals(this.getLocalNode()));
                assert (this.joinAccumulator instanceof JoinHelper.FollowerJoinAccumulator);
                assert (peerFinderLeader.equals(this.lastKnownLeader)) : peerFinderLeader;
                assert (this.electionScheduler == null) : this.electionScheduler;
                assert (this.prevotingRound == null) : this.prevotingRound;
                assert (this.getStateForMasterService().nodes().getMasterNodeId() == null) : this.getStateForMasterService();
                assert (!this.leaderChecker.currentNodeIsMaster());
                assert (this.lastKnownLeader.equals(Optional.of(this.leaderChecker.leader())));
                assert (this.followersChecker.getKnownFollowers().isEmpty());
                assert (this.currentPublication.map(Publication::isCommitted).orElse(true).booleanValue());
                assert (this.preVoteCollector.getLeader().equals(this.lastKnownLeader.get())) : this.preVoteCollector;
                assert (!this.clusterFormationFailureHelper.isRunning());
            } else {
                assert (this.mode == Mode.CANDIDATE);
                assert (this.joinAccumulator instanceof JoinHelper.CandidateJoinAccumulator);
                assert (!peerFinderLeader.isPresent()) : peerFinderLeader;
                assert (this.prevotingRound == null || this.electionScheduler != null);
                assert (this.getStateForMasterService().nodes().getMasterNodeId() == null) : this.getStateForMasterService();
                assert (!this.leaderChecker.currentNodeIsMaster());
                assert (this.leaderChecker.leader() == null) : this.leaderChecker.leader();
                assert (this.followersChecker.getKnownFollowers().isEmpty());
                assert (this.applierState.nodes().getMasterNodeId() == null);
                assert (this.currentPublication.map(Publication::isCommitted).orElse(true).booleanValue());
                assert (this.preVoteCollector.getLeader() == null) : this.preVoteCollector;
                assert (this.clusterFormationFailureHelper.isRunning());
            }
        }
    }

    public boolean isInitialConfigurationSet() {
        return !this.getStateForMasterService().getLastAcceptedConfiguration().isEmpty();
    }

    public boolean setInitialConfiguration(BootstrapConfiguration bootstrapConfiguration) {
        ArrayList<DiscoveryNode> selfAndDiscoveredPeers = new ArrayList<DiscoveryNode>();
        selfAndDiscoveredPeers.add(this.getLocalNode());
        this.getFoundPeers().forEach(selfAndDiscoveredPeers::add);
        CoordinationMetaData.VotingConfiguration votingConfiguration = bootstrapConfiguration.resolve(selfAndDiscoveredPeers);
        return this.setInitialConfiguration(votingConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setInitialConfiguration(CoordinationMetaData.VotingConfiguration votingConfiguration) {
        Object object = this.mutex;
        synchronized (object) {
            ClusterState currentState = this.getStateForMasterService();
            if (this.isInitialConfigurationSet()) {
                return false;
            }
            if (this.mode != Mode.CANDIDATE) {
                throw new CoordinationStateRejectedException("Cannot set initial configuration in mode " + (Object)((Object)this.mode), new Object[0]);
            }
            ArrayList<DiscoveryNode> knownNodes = new ArrayList<DiscoveryNode>();
            knownNodes.add(this.getLocalNode());
            this.peerFinder.getFoundPeers().forEach(knownNodes::add);
            if (!votingConfiguration.hasQuorum(knownNodes.stream().map(DiscoveryNode::getId).collect(Collectors.toList()))) {
                throw new CoordinationStateRejectedException("not enough nodes discovered to form a quorum in the initial configuration [knownNodes=" + knownNodes + ", " + votingConfiguration + "]", new Object[0]);
            }
            logger.info("setting initial configuration to {}", (Object)votingConfiguration);
            ClusterState.Builder builder = this.masterService.incrementVersion(currentState);
            CoordinationMetaData coordinationMetaData = CoordinationMetaData.builder(currentState.coordinationMetaData()).lastAcceptedConfiguration(votingConfiguration).lastCommittedConfiguration(votingConfiguration).build();
            MetaData.Builder metaDataBuilder = MetaData.builder(currentState.metaData());
            metaDataBuilder.generateClusterUuidIfNeeded();
            metaDataBuilder.coordinationMetaData(coordinationMetaData);
            builder.metaData(metaDataBuilder);
            this.coordinationState.get().setInitialState(builder.build());
            this.preVoteCollector.update(this.getPreVoteResponse(), null);
            this.startElectionScheduler();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsafelySetConfigurationForUpgrade(CoordinationMetaData.VotingConfiguration votingConfiguration) {
        assert (Version.CURRENT.major == Version.V_6_6_0.major + 1) : "remove this method once unsafe upgrades are no longer needed";
        Object object = this.mutex;
        synchronized (object) {
            if (this.mode != Mode.CANDIDATE) {
                throw new IllegalStateException("Cannot overwrite configuration in mode " + (Object)((Object)this.mode));
            }
            if (this.isInitialConfigurationSet()) {
                throw new IllegalStateException("Cannot overwrite configuration: configuration is already set to " + this.getLastAcceptedState().getLastAcceptedConfiguration());
            }
            if (!this.lastKnownLeader.map(Coordinator::isZen1Node).orElse(false).booleanValue()) {
                throw new IllegalStateException("Cannot upgrade from last-known leader: " + this.lastKnownLeader);
            }
            if (this.getCurrentTerm() != 0L) {
                throw new IllegalStateException("Cannot upgrade, term is " + this.getCurrentTerm());
            }
            logger.info("automatically bootstrapping during rolling upgrade, using initial configuration {}", (Object)votingConfiguration);
            ClusterState currentState = this.getStateForMasterService();
            ClusterState.Builder builder = this.masterService.incrementVersion(currentState);
            builder.metaData(MetaData.builder(currentState.metaData()).coordinationMetaData(CoordinationMetaData.builder(currentState.metaData().coordinationMetaData()).term(1L).lastAcceptedConfiguration(votingConfiguration).lastCommittedConfiguration(votingConfiguration).build()));
            ClusterState newClusterState = builder.build();
            this.coordinationState.get().handleStartJoin(new StartJoinRequest(this.getLocalNode(), newClusterState.term()));
            this.coordinationState.get().handlePublishRequest(new PublishRequest(newClusterState));
            this.followersChecker.clearCurrentNodes();
            this.followersChecker.updateFastResponseState(this.getCurrentTerm(), this.mode);
            this.peerFinder.deactivate(this.getLocalNode());
            this.peerFinder.activate(newClusterState.nodes());
        }
    }

    ClusterState improveConfiguration(ClusterState clusterState) {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        Set<DiscoveryNode> liveNodes = StreamSupport.stream(clusterState.nodes().spliterator(), false).filter(this::hasJoinVoteFrom).filter(discoveryNode -> !Coordinator.isZen1Node(discoveryNode)).collect(Collectors.toSet());
        CoordinationMetaData.VotingConfiguration newConfig = this.reconfigurator.reconfigure(liveNodes, clusterState.getVotingConfigExclusions().stream().map(CoordinationMetaData.VotingConfigExclusion::getNodeId).collect(Collectors.toSet()), clusterState.getLastAcceptedConfiguration());
        if (!newConfig.equals(clusterState.getLastAcceptedConfiguration())) {
            assert (this.coordinationState.get().joinVotesHaveQuorumFor(newConfig));
            return ClusterState.builder(clusterState).metaData(MetaData.builder(clusterState.metaData()).coordinationMetaData(CoordinationMetaData.builder(clusterState.coordinationMetaData()).lastAcceptedConfiguration(newConfig).build())).build();
        }
        return clusterState;
    }

    private void scheduleReconfigurationIfNeeded() {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        assert (this.mode == Mode.LEADER) : this.mode;
        assert (!this.currentPublication.isPresent()) : "Expected no publication in progress";
        ClusterState state = this.getLastAcceptedState();
        if (this.improveConfiguration(state) != state && this.reconfigurationTaskScheduled.compareAndSet(false, true)) {
            logger.trace("scheduling reconfiguration");
            this.masterService.submitStateUpdateTask("reconfigure", new ClusterStateUpdateTask(Priority.URGENT){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ClusterState execute(ClusterState currentState) {
                    Coordinator.this.reconfigurationTaskScheduled.set(false);
                    Object object = Coordinator.this.mutex;
                    synchronized (object) {
                        return Coordinator.this.improveConfiguration(currentState);
                    }
                }

                @Override
                public void onFailure(String source, Exception e) {
                    Coordinator.this.reconfigurationTaskScheduled.set(false);
                    logger.debug("reconfiguration failed", (Throwable)e);
                }
            });
        }
    }

    boolean hasJoinVoteFrom(DiscoveryNode node) {
        return this.coordinationState.get().containsJoinVoteFor(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJoin(Join join) {
        Object object = this.mutex;
        synchronized (object) {
            this.ensureTermAtLeast(this.getLocalNode(), join.getTerm()).ifPresent(this::handleJoin);
            if (this.coordinationState.get().electionWon()) {
                boolean establishedAsMaster;
                boolean isNewJoin = this.handleJoinIgnoringExceptions(join);
                boolean bl = establishedAsMaster = this.mode == Mode.LEADER && this.getLastAcceptedState().term() == this.getCurrentTerm();
                if (isNewJoin && establishedAsMaster && !this.publicationInProgress()) {
                    this.scheduleReconfigurationIfNeeded();
                }
            } else {
                this.coordinationState.get().handleJoin(join);
            }
        }
    }

    private boolean handleJoinIgnoringExceptions(Join join) {
        try {
            return this.coordinationState.get().handleJoin(join);
        }
        catch (CoordinationStateRejectedException e) {
            logger.debug(new ParameterizedMessage("failed to add {} - ignoring", (Object)join), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState getLastAcceptedState() {
        Object object = this.mutex;
        synchronized (object) {
            return this.coordinationState.get().getLastAcceptedState();
        }
    }

    @Nullable
    public ClusterState getApplierState() {
        return this.applierState;
    }

    private List<DiscoveryNode> getDiscoveredNodes() {
        ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        nodes.add(this.getLocalNode());
        this.peerFinder.getFoundPeers().forEach(nodes::add);
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterState getStateForMasterService() {
        Object object = this.mutex;
        synchronized (object) {
            ClusterState clusterState = this.coordinationState.get().getLastAcceptedState();
            if (this.mode != Mode.LEADER || clusterState.term() != this.getCurrentTerm()) {
                return this.clusterStateWithNoMasterBlock(clusterState);
            }
            return clusterState;
        }
    }

    private ClusterState clusterStateWithNoMasterBlock(ClusterState clusterState) {
        if (clusterState.nodes().getMasterNodeId() != null) {
            assert (!clusterState.blocks().hasGlobalBlock(2)) : "NO_MASTER_BLOCK should only be added by Coordinator";
            ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(clusterState.blocks()).addGlobalBlock(this.discoverySettings.getNoMasterBlock()).build();
            DiscoveryNodes discoveryNodes = new DiscoveryNodes.Builder(clusterState.nodes()).masterNodeId(null).build();
            return ClusterState.builder(clusterState).blocks(clusterBlocks).nodes(discoveryNodes).build();
        }
        return clusterState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(ClusterChangedEvent clusterChangedEvent, ActionListener<Void> publishListener, ClusterStatePublisher.AckListener ackListener) {
        try {
            Object object = this.mutex;
            synchronized (object) {
                assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
                if (this.mode != Mode.LEADER) {
                    logger.debug(() -> new ParameterizedMessage("[{}] failed publication as not currently leading", (Object)clusterChangedEvent.source()));
                    publishListener.onFailure(new FailedToCommitClusterStateException("node stepped down as leader during publication", new Object[0]));
                    return;
                }
                if (this.currentPublication.isPresent()) {
                    assert (false) : "[" + this.currentPublication.get() + "] in progress, cannot start new publication";
                    logger.warn(() -> new ParameterizedMessage("[{}] failed publication as already publication in progress", (Object)clusterChangedEvent.source()));
                    publishListener.onFailure(new FailedToCommitClusterStateException("publication " + this.currentPublication.get() + " already in progress", new Object[0]));
                    return;
                }
                assert (clusterChangedEvent.previousState() == this.coordinationState.get().getLastAcceptedState() || Strings.toString(clusterChangedEvent.previousState()).equals(Strings.toString(this.clusterStateWithNoMasterBlock(this.coordinationState.get().getLastAcceptedState())))) : Strings.toString(clusterChangedEvent.previousState()) + " vs " + Strings.toString(this.clusterStateWithNoMasterBlock(this.coordinationState.get().getLastAcceptedState()));
                ClusterState clusterState = clusterChangedEvent.state();
                assert (this.getLocalNode().equals(clusterState.getNodes().get(this.getLocalNode().getId()))) : this.getLocalNode() + " should be in published " + clusterState;
                PublishRequest publishRequest = this.coordinationState.get().handleClientValue(clusterState);
                PublicationTransportHandler.PublicationContext publicationContext = this.publicationHandler.newPublicationContext(clusterChangedEvent);
                final CoordinatorPublication publication = new CoordinatorPublication(publishRequest, publicationContext, new ListenableFuture<Void>(), ackListener, publishListener);
                this.currentPublication = Optional.of(publication);
                this.transportService.getThreadPool().schedule(this.publishTimeout, "generic", new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = Coordinator.this.mutex;
                        synchronized (object) {
                            publication.onTimeout();
                        }
                    }

                    public String toString() {
                        return "scheduled timeout for " + publication;
                    }
                });
                DiscoveryNodes publishNodes = publishRequest.getAcceptedState().nodes();
                this.leaderChecker.setCurrentNodes(publishNodes);
                this.followersChecker.setCurrentNodes(publishNodes);
                this.lagDetector.setTrackedNodes(publishNodes);
                publication.start(this.followersChecker.getFaultyNodes());
            }
        }
        catch (Exception e) {
            logger.debug(() -> new ParameterizedMessage("[{}] publishing failed", (Object)clusterChangedEvent.source()), (Throwable)e);
            publishListener.onFailure(new FailedToCommitClusterStateException("publishing failed", (Throwable)e, new Object[0]));
        }
    }

    private <T> ActionListener<T> wrapWithMutex(final ActionListener<T> listener) {
        return new ActionListener<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(T t) {
                Object object = Coordinator.this.mutex;
                synchronized (object) {
                    listener.onResponse(t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Exception e) {
                Object object = Coordinator.this.mutex;
                synchronized (object) {
                    listener.onFailure(e);
                }
            }
        };
    }

    private void cancelActivePublication() {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        if (this.currentPublication.isPresent()) {
            this.currentPublication.get().onTimeout();
        }
    }

    private void startElectionScheduler() {
        assert (this.electionScheduler == null) : this.electionScheduler;
        if (!this.getLocalNode().isMasterNode()) {
            return;
        }
        TimeValue gracePeriod = TimeValue.ZERO;
        this.electionScheduler = this.electionSchedulerFactory.startElectionScheduler(gracePeriod, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = Coordinator.this.mutex;
                synchronized (object) {
                    if (Coordinator.this.mode == Mode.CANDIDATE) {
                        if (Coordinator.this.prevotingRound != null) {
                            Coordinator.this.prevotingRound.close();
                        }
                        ClusterState lastAcceptedState = Coordinator.this.coordinationState.get().getLastAcceptedState();
                        List<DiscoveryNode> discoveredNodes = Coordinator.this.getDiscoveredNodes().stream().filter(n -> !Coordinator.isZen1Node(n)).collect(Collectors.toList());
                        Coordinator.this.prevotingRound = Coordinator.this.preVoteCollector.start(lastAcceptedState, discoveredNodes);
                    }
                }
            }

            public String toString() {
                return "scheduling of new prevoting round";
            }
        });
    }

    public Releasable withDiscoveryListener(ActionListener<Iterable<DiscoveryNode>> listener) {
        this.discoveredNodesListeners.add(listener);
        return () -> {
            boolean removed = this.discoveredNodesListeners.remove(listener);
            assert (removed) : listener;
        };
    }

    public Iterable<DiscoveryNode> getFoundPeers() {
        return this.peerFinder.getFoundPeers();
    }

    public static Settings.Builder addZen1Attribute(boolean isZen1Node, Settings.Builder builder) {
        return builder.put("node.attr.zen1", isZen1Node);
    }

    public static boolean isZen1Node(DiscoveryNode discoveryNode) {
        return discoveryNode.getVersion().before(Version.V_7_0_0) || Booleans.isTrue(discoveryNode.getAttributes().getOrDefault("zen1", "false"));
    }

    class CoordinatorPublication
    extends Publication {
        private final PublishRequest publishRequest;
        private final ListenableFuture<Void> localNodeAckEvent;
        private final ClusterStatePublisher.AckListener ackListener;
        private final ActionListener<Void> publishListener;
        private final PublicationTransportHandler.PublicationContext publicationContext;
        private final List<Join> receivedJoins;
        private boolean receivedJoinsProcessed;

        CoordinatorPublication(final PublishRequest publishRequest, PublicationTransportHandler.PublicationContext publicationContext, final ListenableFuture<Void> localNodeAckEvent, final ClusterStatePublisher.AckListener ackListener, ActionListener<Void> publishListener) {
            super(publishRequest, new ClusterStatePublisher.AckListener(){

                @Override
                public void onCommit(TimeValue commitTime) {
                    ackListener.onCommit(commitTime);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNodeAck(DiscoveryNode node, Exception e) {
                    if (node.equals(Coordinator.this.getLocalNode())) {
                        Object object = Coordinator.this.mutex;
                        synchronized (object) {
                            if (e == null) {
                                localNodeAckEvent.onResponse(null);
                            } else {
                                localNodeAckEvent.onFailure(e);
                            }
                        }
                    } else {
                        ackListener.onNodeAck(node, e);
                        if (e == null) {
                            Coordinator.this.lagDetector.setAppliedVersion(node, publishRequest.getAcceptedState().version());
                        }
                    }
                }
            }, Coordinator.this.transportService.getThreadPool()::relativeTimeInMillis);
            this.receivedJoins = new ArrayList<Join>();
            this.publishRequest = publishRequest;
            this.publicationContext = publicationContext;
            this.localNodeAckEvent = localNodeAckEvent;
            this.ackListener = ackListener;
            this.publishListener = publishListener;
        }

        private void removePublicationAndPossiblyBecomeCandidate(String reason) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            assert (Coordinator.this.currentPublication.get() == this);
            Coordinator.this.currentPublication = Optional.empty();
            this.logger.debug("publication ended unsuccessfully: {}", (Object)this);
            if (this.isActiveForCurrentLeader()) {
                Coordinator.this.becomeCandidate(reason);
            }
        }

        boolean isActiveForCurrentLeader() {
            return Coordinator.this.mode == Mode.LEADER && this.publishRequest.getAcceptedState().term() == Coordinator.this.getCurrentTerm();
        }

        @Override
        protected void onCompletion(final boolean committed) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            this.localNodeAckEvent.addListener(new ActionListener<Void>(){

                @Override
                public void onResponse(Void ignore) {
                    assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
                    assert (committed);
                    CoordinatorPublication.this.receivedJoins.forEach(x$0 -> CoordinatorPublication.this.handleAssociatedJoin(x$0));
                    assert (!CoordinatorPublication.this.receivedJoinsProcessed);
                    CoordinatorPublication.this.receivedJoinsProcessed = true;
                    Coordinator.this.clusterApplier.onNewClusterState(CoordinatorPublication.this.toString(), () -> Coordinator.this.applierState, new ClusterApplier.ClusterApplyListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onFailure(String source, Exception e) {
                            Object object = Coordinator.this.mutex;
                            synchronized (object) {
                                CoordinatorPublication.this.removePublicationAndPossiblyBecomeCandidate("clusterApplier#onNewClusterState");
                            }
                            CoordinatorPublication.this.ackListener.onNodeAck(Coordinator.this.getLocalNode(), e);
                            CoordinatorPublication.this.publishListener.onFailure(e);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onSuccess(String source) {
                            Object object = Coordinator.this.mutex;
                            synchronized (object) {
                                assert (Coordinator.this.currentPublication.get() == CoordinatorPublication.this);
                                Coordinator.this.currentPublication = Optional.empty();
                                CoordinatorPublication.this.logger.debug("publication ended successfully: {}", (Object)CoordinatorPublication.this);
                                Coordinator.this.updateMaxTermSeen(Coordinator.this.getCurrentTerm());
                                if (Coordinator.this.mode == Mode.LEADER) {
                                    Coordinator.this.scheduleReconfigurationIfNeeded();
                                }
                                Coordinator.this.lagDetector.startLagDetector(CoordinatorPublication.this.publishRequest.getAcceptedState().version());
                            }
                            CoordinatorPublication.this.ackListener.onNodeAck(Coordinator.this.getLocalNode(), null);
                            CoordinatorPublication.this.publishListener.onResponse(null);
                        }
                    });
                }

                @Override
                public void onFailure(Exception e) {
                    assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
                    CoordinatorPublication.this.removePublicationAndPossiblyBecomeCandidate("Publication.onCompletion(false)");
                    FailedToCommitClusterStateException exception = new FailedToCommitClusterStateException("publication failed", (Throwable)e, new Object[0]);
                    CoordinatorPublication.this.ackListener.onNodeAck(Coordinator.this.getLocalNode(), exception);
                    CoordinatorPublication.this.publishListener.onFailure(exception);
                }
            }, EsExecutors.newDirectExecutorService(), Coordinator.this.transportService.getThreadPool().getThreadContext());
        }

        private void handleAssociatedJoin(Join join) {
            if (join.getTerm() == Coordinator.this.getCurrentTerm() && !Coordinator.this.hasJoinVoteFrom(join.getSourceNode())) {
                this.logger.trace("handling {}", (Object)join);
                Coordinator.this.handleJoin(join);
            }
        }

        @Override
        protected boolean isPublishQuorum(CoordinationState.VoteCollection votes) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            return Coordinator.this.coordinationState.get().isPublishQuorum(votes);
        }

        @Override
        protected Optional<ApplyCommitRequest> handlePublishResponse(DiscoveryNode sourceNode, PublishResponse publishResponse) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            assert (Coordinator.this.getCurrentTerm() >= publishResponse.getTerm());
            return Coordinator.this.coordinationState.get().handlePublishResponse(sourceNode, publishResponse);
        }

        @Override
        protected void onJoin(Join join) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            if (this.receivedJoinsProcessed) {
                this.handleAssociatedJoin(join);
            } else {
                this.receivedJoins.add(join);
            }
        }

        @Override
        protected void onMissingJoin(DiscoveryNode discoveryNode) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            if (!Coordinator.this.hasJoinVoteFrom(discoveryNode)) {
                long term = this.publishRequest.getAcceptedState().term();
                this.logger.debug("onMissingJoin: no join vote from {}, bumping term to exceed {}", (Object)discoveryNode, (Object)term);
                Coordinator.this.updateMaxTermSeen(term + 1L);
            }
        }

        @Override
        protected void sendPublishRequest(DiscoveryNode destination, PublishRequest publishRequest, ActionListener<PublishWithJoinResponse> responseActionListener) {
            this.publicationContext.sendPublishRequest(destination, publishRequest, Coordinator.this.wrapWithMutex(responseActionListener));
        }

        @Override
        protected void sendApplyCommit(DiscoveryNode destination, ApplyCommitRequest applyCommit, ActionListener<TransportResponse.Empty> responseActionListener) {
            this.publicationContext.sendApplyCommit(destination, applyCommit, Coordinator.this.wrapWithMutex(responseActionListener));
        }
    }

    private class CoordinatorPeerFinder
    extends PeerFinder {
        CoordinatorPeerFinder(Settings settings, TransportService transportService, PeerFinder.TransportAddressConnector transportAddressConnector, PeerFinder.ConfiguredHostsResolver configuredHostsResolver) {
            super(settings, transportService, transportAddressConnector, configuredHostsResolver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onActiveMasterFound(DiscoveryNode masterNode, long term) {
            Object object = Coordinator.this.mutex;
            synchronized (object) {
                Coordinator.this.ensureTermAtLeast(masterNode, term);
                Coordinator.this.joinHelper.sendJoinRequest(masterNode, Coordinator.joinWithDestination(Coordinator.this.lastJoin, masterNode, term));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onFoundPeersUpdated() {
            Iterable<DiscoveryNode> foundPeers;
            Iterator iterator = Coordinator.this.mutex;
            synchronized (iterator) {
                foundPeers = this.getFoundPeers();
                if (Coordinator.this.mode == Mode.CANDIDATE) {
                    CoordinationState.VoteCollection expectedVotes = new CoordinationState.VoteCollection();
                    foundPeers.forEach(expectedVotes::addVote);
                    expectedVotes.addVote(Coordinator.this.getLocalNode());
                    ClusterState lastAcceptedState = Coordinator.this.coordinationState.get().getLastAcceptedState();
                    boolean foundQuorum = CoordinationState.isElectionQuorum(expectedVotes, lastAcceptedState);
                    if (foundQuorum) {
                        if (Coordinator.this.electionScheduler == null) {
                            Coordinator.this.startElectionScheduler();
                        }
                    } else {
                        Coordinator.this.closePrevotingAndElectionScheduler();
                    }
                }
            }
            for (ActionListener discoveredNodesListener : Coordinator.this.discoveredNodesListeners) {
                discoveredNodesListener.onResponse(foundPeers);
            }
        }
    }

    public static enum Mode {
        CANDIDATE,
        LEADER,
        FOLLOWER;

    }
}

