/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class MultiSearchResponse
extends ActionResponse
implements Iterable<Item>,
ToXContentObject {
    private static final ParseField RESPONSES = new ParseField("responses", new String[0]);
    private static final ParseField TOOK_IN_MILLIS = new ParseField("took", new String[0]);
    private static final ConstructingObjectParser<MultiSearchResponse, Void> PARSER = new ConstructingObjectParser("multi_search", true, a -> new MultiSearchResponse(((List)a[0]).toArray(new Item[0]), (Long)a[1]));
    private Item[] items;
    private long tookInMillis;

    MultiSearchResponse() {
    }

    MultiSearchResponse(StreamInput in) throws IOException {
        this.readFrom(in);
    }

    public MultiSearchResponse(Item[] items, long tookInMillis) {
        this.items = items;
        this.tookInMillis = tookInMillis;
    }

    @Override
    public Iterator<Item> iterator() {
        return Arrays.stream(this.items).iterator();
    }

    public Item[] getResponses() {
        return this.items;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.items = new Item[in.readVInt()];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = Item.readItem(in);
        }
        if (in.getVersion().onOrAfter(Version.V_7_0_0)) {
            this.tookInMillis = in.readVLong();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.items.length);
        for (Item item : this.items) {
            item.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
            out.writeVLong(this.tookInMillis);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("took", this.tookInMillis);
        builder.startArray("responses");
        for (Item item : this.items) {
            builder.startObject();
            if (item.isFailure()) {
                ElasticsearchException.generateFailureXContent(builder, params, item.getFailure(), true);
                builder.field("status", ExceptionsHelper.status(item.getFailure()).getStatus());
            } else {
                item.getResponse().innerToXContent(builder, params);
                builder.field("status", item.getResponse().status().getStatus());
            }
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static MultiSearchResponse fromXContext(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Item itemFromXContent(XContentParser parser) throws IOException {
        Item item = null;
        String fieldName = null;
        XContentParser.Token token = parser.nextToken();
        assert (token == XContentParser.Token.FIELD_NAME);
        block4: while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    fieldName = parser.currentName();
                    if ("error".equals(fieldName)) {
                        item = new Item(null, ElasticsearchException.failureFromXContent(parser));
                        break;
                    }
                    if ("status".equals(fieldName)) break;
                    item = new Item(SearchResponse.innerFromXContent(parser), null);
                    break block4;
                }
                case VALUE_NUMBER: {
                    if (!"status".equals(fieldName)) break;
                }
            }
            token = parser.nextToken();
        }
        assert (parser.currentToken() == XContentParser.Token.END_OBJECT);
        return item;
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> MultiSearchResponse.itemFromXContent(p), RESPONSES);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOOK_IN_MILLIS);
    }

    static final class Fields {
        static final String RESPONSES = "responses";
        static final String STATUS = "status";

        Fields() {
        }
    }

    public static class Item
    implements Streamable {
        private SearchResponse response;
        private Exception exception;

        Item() {
        }

        public Item(SearchResponse response, Exception exception) {
            this.response = response;
            this.exception = exception;
        }

        public boolean isFailure() {
            return this.exception != null;
        }

        @Nullable
        public String getFailureMessage() {
            return this.exception == null ? null : this.exception.getMessage();
        }

        @Nullable
        public SearchResponse getResponse() {
            return this.response;
        }

        public static Item readItem(StreamInput in) throws IOException {
            Item item = new Item();
            item.readFrom(in);
            return item;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.response = new SearchResponse();
                this.response.readFrom(in);
            } else {
                this.exception = in.readException();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (this.response != null) {
                out.writeBoolean(true);
                this.response.writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeException(this.exception);
            }
        }

        public Exception getFailure() {
            return this.exception;
        }
    }
}

