/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.resync;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.resync.ResyncReplicationRequest;
import org.elasticsearch.action.resync.ResyncReplicationResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class TransportResyncReplicationAction
extends TransportWriteAction<ResyncReplicationRequest, ResyncReplicationRequest, ResyncReplicationResponse>
implements PrimaryReplicaSyncer.SyncAction {
    private static String ACTION_NAME = "internal:index/seq_no/resync";

    @Inject
    public TransportResyncReplicationAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, ResyncReplicationRequest::new, ResyncReplicationRequest::new, "write");
    }

    @Override
    protected void registerRequestHandlers(String actionName, TransportService transportService, Supplier<ResyncReplicationRequest> request, Supplier<ResyncReplicationRequest> replicaRequest, String executor) {
        transportService.registerRequestHandler(actionName, request, "same", new TransportReplicationAction.OperationTransportHandler(this));
        transportService.registerRequestHandler(this.transportPrimaryAction, () -> new TransportReplicationAction.ConcreteShardRequest(request), executor, true, true, new TransportReplicationAction.PrimaryOperationTransportHandler(this));
        transportService.registerRequestHandler(this.transportReplicaAction, () -> new TransportReplicationAction.ConcreteReplicaRequest(replicaRequest), executor, true, true, new TransportReplicationAction.ReplicaOperationTransportHandler(this));
    }

    @Override
    protected ResyncReplicationResponse newResponseInstance() {
        return new ResyncReplicationResponse();
    }

    @Override
    protected ReplicationOperation.Replicas newReplicasProxy(long primaryTerm) {
        return new ResyncActionReplicasProxy(primaryTerm);
    }

    @Override
    protected void sendReplicaRequest(TransportReplicationAction.ConcreteReplicaRequest<ResyncReplicationRequest> replicaRequest, DiscoveryNode node, ActionListener<ReplicationOperation.ReplicaResponse> listener) {
        if (node.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            super.sendReplicaRequest(replicaRequest, node, listener);
        } else {
            long pre60NodeCheckpoint = -3L;
            listener.onResponse(new TransportReplicationAction.ReplicaResponse(-3L, -3L));
        }
    }

    @Override
    protected ClusterBlockLevel globalBlockLevel() {
        return null;
    }

    @Override
    protected ClusterBlockLevel indexBlockLevel() {
        return null;
    }

    @Override
    protected TransportWriteAction.WritePrimaryResult<ResyncReplicationRequest, ResyncReplicationResponse> shardOperationOnPrimary(ResyncReplicationRequest request, IndexShard primary) throws Exception {
        ResyncReplicationRequest replicaRequest = TransportResyncReplicationAction.performOnPrimary(request, primary);
        return new TransportWriteAction.WritePrimaryResult<ResyncReplicationRequest, ResyncReplicationResponse>(replicaRequest, new ResyncReplicationResponse(), null, null, primary, this.logger);
    }

    public static ResyncReplicationRequest performOnPrimary(ResyncReplicationRequest request, IndexShard primary) {
        return request;
    }

    @Override
    protected TransportWriteAction.WriteReplicaResult shardOperationOnReplica(ResyncReplicationRequest request, IndexShard replica) throws Exception {
        Translog.Location location = TransportResyncReplicationAction.performOnReplica(request, replica);
        return new TransportWriteAction.WriteReplicaResult<ResyncReplicationRequest>(request, location, null, replica, this.logger);
    }

    public static Translog.Location performOnReplica(ResyncReplicationRequest request, IndexShard replica) throws Exception {
        Translog.Location location = null;
        replica.updateMaxUnsafeAutoIdTimestamp(request.getMaxSeenAutoIdTimestampOnPrimary());
        for (Translog.Operation operation : request.getOperations()) {
            Engine.Result operationResult = replica.applyTranslogOperation(operation, Engine.Operation.Origin.REPLICA);
            if (operationResult.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                throw new TransportReplicationAction.RetryOnReplicaException(replica.shardId(), "Mappings are not available on the replica yet, triggered update: " + operationResult.getRequiredMappingUpdate());
            }
            location = TransportResyncReplicationAction.syncOperationResultOrThrow(operationResult, location);
        }
        if (request.getTrimAboveSeqNo() != -2L) {
            replica.trimOperationOfPreviousPrimaryTerms(request.getTrimAboveSeqNo());
        }
        return location;
    }

    @Override
    public void sync(ResyncReplicationRequest request, Task parentTask, String primaryAllocationId, long primaryTerm, final ActionListener<ResyncReplicationResponse> listener) {
        this.transportService.sendChildRequest(this.clusterService.localNode(), this.transportPrimaryAction, new TransportReplicationAction.ConcreteShardRequest<ResyncReplicationRequest>(request, primaryAllocationId, primaryTerm), parentTask, this.transportOptions, new TransportResponseHandler<ResyncReplicationResponse>(){

            @Override
            public ResyncReplicationResponse read(StreamInput in) throws IOException {
                ResyncReplicationResponse response = TransportResyncReplicationAction.this.newResponseInstance();
                response.readFrom(in);
                return response;
            }

            @Override
            public String executor() {
                return "same";
            }

            @Override
            public void handleResponse(ResyncReplicationResponse response) {
                ReplicationResponse.ShardInfo.Failure[] failures = response.getShardInfo().getFailures();
                for (int i = 0; i < failures.length; ++i) {
                    ReplicationResponse.ShardInfo.Failure f = failures[i];
                    TransportResyncReplicationAction.this.logger.info(new ParameterizedMessage("{} primary-replica resync to replica on node [{}] failed", (Object)f.fullShardId(), (Object)f.nodeId()), f.getCause());
                }
                listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp) {
                listener.onFailure(exp);
            }
        });
    }

    class ResyncActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        ResyncActionReplicasProxy(long primaryTerm) {
            super(TransportResyncReplicationAction.this, primaryTerm);
        }

        @Override
        public void failShardIfNeeded(ShardRouting replica, String message, Exception exception, Runnable onSuccess, Consumer<Exception> onPrimaryDemoted, Consumer<Exception> onIgnoredFailure) {
            TransportResyncReplicationAction.this.shardStateAction.remoteShardFailed(replica.shardId(), replica.allocationId().getId(), this.primaryTerm, false, message, exception, this.createShardActionListener(onSuccess, onPrimaryDemoted, onIgnoredFailure));
        }
    }
}

