/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;

public class FieldCapabilitiesResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    private Map<String, Map<String, FieldCapabilities>> responseMap;
    private List<FieldCapabilitiesIndexResponse> indexResponses;
    private static final ConstructingObjectParser<FieldCapabilitiesResponse, Void> PARSER = new ConstructingObjectParser("field_capabilities_response", true, a -> new FieldCapabilitiesResponse(((List)a[0]).stream().collect(Collectors.toMap(Tuple::v1, Tuple::v2))));

    FieldCapabilitiesResponse(Map<String, Map<String, FieldCapabilities>> responseMap) {
        this(responseMap, Collections.emptyList());
    }

    FieldCapabilitiesResponse(List<FieldCapabilitiesIndexResponse> indexResponses) {
        this(Collections.emptyMap(), indexResponses);
    }

    private FieldCapabilitiesResponse(Map<String, Map<String, FieldCapabilities>> responseMap, List<FieldCapabilitiesIndexResponse> indexResponses) {
        this.responseMap = Objects.requireNonNull(responseMap);
        this.indexResponses = Objects.requireNonNull(indexResponses);
    }

    FieldCapabilitiesResponse() {
        this(Collections.emptyMap(), Collections.emptyList());
    }

    public Map<String, Map<String, FieldCapabilities>> get() {
        return this.responseMap;
    }

    List<FieldCapabilitiesIndexResponse> getIndexResponses() {
        return this.indexResponses;
    }

    public Map<String, FieldCapabilities> getField(String field) {
        return this.responseMap.get(field);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.responseMap = in.readMap(StreamInput::readString, FieldCapabilitiesResponse::readField);
        this.indexResponses = in.readList(FieldCapabilitiesIndexResponse::new);
    }

    private static Map<String, FieldCapabilities> readField(StreamInput in) throws IOException {
        return in.readMap(StreamInput::readString, FieldCapabilities::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.responseMap, StreamOutput::writeString, FieldCapabilitiesResponse::writeField);
        out.writeList(this.indexResponses);
    }

    private static void writeField(StreamOutput out, Map<String, FieldCapabilities> map) throws IOException {
        out.writeMap(map, StreamOutput::writeString, (valueOut, fc) -> fc.writeTo(valueOut));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(FIELDS_FIELD.getPreferredName(), this.responseMap).endObject();
    }

    public static FieldCapabilitiesResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    private static Map<String, FieldCapabilities> parseTypeToCapabilities(XContentParser parser, String name) throws IOException {
        XContentParser.Token token;
        HashMap<String, FieldCapabilities> typeToCapabilities = new HashMap<String, FieldCapabilities>();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser::getTokenLocation);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser::getTokenLocation);
            String type = parser.currentName();
            FieldCapabilities capabilities = FieldCapabilities.fromXContent(name, parser);
            typeToCapabilities.put(type, capabilities);
        }
        return typeToCapabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesResponse that = (FieldCapabilitiesResponse)o;
        return this.responseMap.equals(that.responseMap);
    }

    public int hashCode() {
        return this.responseMap.hashCode();
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> {
            Map<String, FieldCapabilities> typeToCapabilities = FieldCapabilitiesResponse.parseTypeToCapabilities(p, n);
            return new Tuple<String, Map<String, FieldCapabilities>>(n, typeToCapabilities);
        }, FIELDS_FIELD);
    }
}

