/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.bootstrap;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.bootstrap.GetDiscoveredNodesRequest;
import org.elasticsearch.action.admin.cluster.bootstrap.GetDiscoveredNodesResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.coordination.ClusterAlreadyBootstrappedException;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDiscoveredNodesAction
extends HandledTransportAction<GetDiscoveredNodesRequest, GetDiscoveredNodesResponse> {
    @Nullable
    private final Coordinator coordinator;
    private final TransportService transportService;
    private final String discoveryType;

    @Inject
    public TransportGetDiscoveredNodesAction(Settings settings, ActionFilters actionFilters, TransportService transportService, Discovery discovery) {
        super("cluster:admin/bootstrap/discover_nodes", transportService, actionFilters, GetDiscoveredNodesRequest::new);
        this.discoveryType = DiscoveryModule.DISCOVERY_TYPE_SETTING.get(settings);
        this.transportService = transportService;
        this.coordinator = discovery instanceof Coordinator ? (Coordinator)discovery : null;
    }

    @Override
    protected void doExecute(Task task, final GetDiscoveredNodesRequest request, ActionListener<GetDiscoveredNodesResponse> listener) {
        if (this.coordinator == null) {
            throw new IllegalArgumentException("discovered nodes are not exposed by discovery type [" + this.discoveryType + "]");
        }
        final DiscoveryNode localNode = this.transportService.getLocalNode();
        assert (localNode != null);
        if (!localNode.isMasterNode()) {
            throw new IllegalArgumentException("this node is not master-eligible, but discovered nodes are only exposed by master-eligible nodes");
        }
        ExecutorService directExecutor = EsExecutors.newDirectExecutorService();
        final AtomicBoolean listenerNotified = new AtomicBoolean();
        final ListenableFuture<GetDiscoveredNodesResponse> listenableFuture = new ListenableFuture<GetDiscoveredNodesResponse>();
        ThreadPool threadPool = this.transportService.getThreadPool();
        listenableFuture.addListener(listener, directExecutor, threadPool.getThreadContext());
        final ActionListener<Iterable<DiscoveryNode>> respondIfRequestSatisfied = new ActionListener<Iterable<DiscoveryNode>>(){

            @Override
            public void onResponse(Iterable<DiscoveryNode> nodes) {
                LinkedHashSet<DiscoveryNode> nodesSet = new LinkedHashSet<DiscoveryNode>();
                nodesSet.add(localNode);
                nodes.forEach(nodesSet::add);
                TransportGetDiscoveredNodesAction.this.logger.trace("discovered {}", (Object)nodesSet);
                try {
                    if (TransportGetDiscoveredNodesAction.checkWaitRequirements(request, nodesSet)) {
                        GetDiscoveredNodesResponse response = new GetDiscoveredNodesResponse(nodesSet);
                        if (listenerNotified.compareAndSet(false, true)) {
                            listenableFuture.onResponse(response);
                        }
                    }
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                if (listenerNotified.compareAndSet(false, true)) {
                    listenableFuture.onFailure(e);
                }
            }

            public String toString() {
                return "waiting for " + request;
            }
        };
        Releasable releasable = this.coordinator.withDiscoveryListener(respondIfRequestSatisfied);
        listenableFuture.addListener(ActionListener.wrap(releasable::close), directExecutor, threadPool.getThreadContext());
        if (this.coordinator.isInitialConfigurationSet()) {
            respondIfRequestSatisfied.onFailure(new ClusterAlreadyBootstrappedException());
        } else {
            respondIfRequestSatisfied.onResponse(this.coordinator.getFoundPeers());
        }
        if (request.getTimeout() != null) {
            threadPool.schedule(request.getTimeout(), "same", new Runnable(){

                @Override
                public void run() {
                    respondIfRequestSatisfied.onFailure(new ElasticsearchTimeoutException("timed out while waiting for " + request, new Object[0]));
                }

                public String toString() {
                    return "timeout handler for " + request;
                }
            });
        }
    }

    private static boolean matchesRequirement(DiscoveryNode discoveryNode, String requirement) {
        return discoveryNode.getName().equals(requirement) || discoveryNode.getAddress().toString().equals(requirement) || discoveryNode.getAddress().getAddress().equals(requirement);
    }

    private static boolean checkWaitRequirements(GetDiscoveredNodesRequest request, Set<DiscoveryNode> nodes) {
        if (nodes.size() < request.getWaitForNodes()) {
            return false;
        }
        List<String> requirements = request.getRequiredNodes();
        HashSet<DiscoveryNode> selectedNodes = new HashSet<DiscoveryNode>();
        for (String requirement : requirements) {
            Set matchingNodes = nodes.stream().filter(n -> TransportGetDiscoveredNodesAction.matchesRequirement(n, requirement)).collect(Collectors.toSet());
            if (matchingNodes.isEmpty()) {
                return false;
            }
            if (matchingNodes.size() > 1) {
                throw new IllegalArgumentException("[" + requirement + "] matches " + matchingNodes);
            }
            for (DiscoveryNode matchingNode : matchingNodes) {
                if (selectedNodes.add(matchingNode)) continue;
                throw new IllegalArgumentException("[" + matchingNode + "] matches " + requirements.stream().filter(r -> TransportGetDiscoveredNodesAction.matchesRequirement(matchingNode, requirement)).collect(Collectors.toList()));
            }
        }
        return true;
    }
}

