/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.bootstrap;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.bootstrap.BootstrapClusterRequest;
import org.elasticsearch.action.admin.cluster.bootstrap.BootstrapClusterResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportBootstrapClusterAction
extends HandledTransportAction<BootstrapClusterRequest, BootstrapClusterResponse> {
    @Nullable
    private final Coordinator coordinator;
    private final TransportService transportService;
    private final String discoveryType;

    @Inject
    public TransportBootstrapClusterAction(Settings settings, ActionFilters actionFilters, TransportService transportService, Discovery discovery) {
        super("cluster:admin/bootstrap/set_voting_config", transportService, actionFilters, BootstrapClusterRequest::new);
        this.transportService = transportService;
        this.discoveryType = DiscoveryModule.DISCOVERY_TYPE_SETTING.get(settings);
        this.coordinator = discovery instanceof Coordinator ? (Coordinator)discovery : null;
    }

    @Override
    protected void doExecute(Task task, final BootstrapClusterRequest request, final ActionListener<BootstrapClusterResponse> listener) {
        if (this.coordinator == null) {
            throw new IllegalArgumentException("cluster bootstrapping is not supported by discovery type [" + this.discoveryType + "]");
        }
        DiscoveryNode localNode = this.transportService.getLocalNode();
        assert (localNode != null);
        if (!localNode.isMasterNode()) {
            throw new IllegalArgumentException("this node is not master-eligible, but cluster bootstrapping can only happen on a master-eligible node");
        }
        this.transportService.getThreadPool().generic().execute(new AbstractRunnable(){

            @Override
            public void doRun() {
                listener.onResponse(new BootstrapClusterResponse(!TransportBootstrapClusterAction.this.coordinator.setInitialConfiguration(request.getBootstrapConfiguration())));
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public String toString() {
                return "setting initial configuration with " + request;
            }
        });
    }
}

