/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.bootstrap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.coordination.CoordinationMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class BootstrapConfiguration
implements Writeable {
    private final List<NodeDescription> nodeDescriptions;

    public BootstrapConfiguration(List<NodeDescription> nodeDescriptions) {
        if (nodeDescriptions.isEmpty()) {
            throw new IllegalArgumentException("cannot create empty bootstrap configuration");
        }
        this.nodeDescriptions = Collections.unmodifiableList(new ArrayList<NodeDescription>(nodeDescriptions));
    }

    public BootstrapConfiguration(StreamInput in) throws IOException {
        this.nodeDescriptions = Collections.unmodifiableList(in.readList(NodeDescription::new));
        assert (!this.nodeDescriptions.isEmpty());
    }

    public List<NodeDescription> getNodeDescriptions() {
        return this.nodeDescriptions;
    }

    public CoordinationMetaData.VotingConfiguration resolve(Iterable<DiscoveryNode> discoveredNodes) {
        HashSet<DiscoveryNode> selectedNodes = new HashSet<DiscoveryNode>();
        for (NodeDescription nodeDescription : this.nodeDescriptions) {
            DiscoveryNode discoveredNode = nodeDescription.resolve(discoveredNodes);
            if (selectedNodes.add(discoveredNode)) continue;
            throw new ElasticsearchException("multiple nodes matching {} in {}", discoveredNode, this);
        }
        Set<String> nodeIds = selectedNodes.stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
        assert (nodeIds.size() == selectedNodes.size()) : selectedNodes + " does not contain distinct IDs";
        return new CoordinationMetaData.VotingConfiguration(nodeIds);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.nodeDescriptions);
    }

    public String toString() {
        return "BootstrapConfiguration{nodeDescriptions=" + this.nodeDescriptions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BootstrapConfiguration that = (BootstrapConfiguration)o;
        return Objects.equals(this.nodeDescriptions, that.nodeDescriptions);
    }

    public int hashCode() {
        return Objects.hash(this.nodeDescriptions);
    }

    public static class NodeDescription
    implements Writeable {
        @Nullable
        private final String id;
        private final String name;

        @Nullable
        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public NodeDescription(@Nullable String id, String name) {
            this.id = id;
            this.name = Objects.requireNonNull(name);
        }

        public NodeDescription(DiscoveryNode discoveryNode) {
            this(discoveryNode.getId(), discoveryNode.getName());
        }

        public NodeDescription(StreamInput in) throws IOException {
            this(in.readOptionalString(), in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.id);
            out.writeString(this.name);
        }

        public String toString() {
            return "NodeDescription{id='" + this.id + '\'' + ", name='" + this.name + '\'' + '}';
        }

        public DiscoveryNode resolve(Iterable<DiscoveryNode> discoveredNodes) {
            DiscoveryNode selectedNode = null;
            for (DiscoveryNode discoveredNode : discoveredNodes) {
                assert (discoveredNode.isMasterNode()) : discoveredNode;
                if (discoveredNode.getName().equals(this.name)) {
                    if (this.id == null || this.id.equals(discoveredNode.getId())) {
                        if (selectedNode != null) {
                            throw new ElasticsearchException("discovered multiple nodes matching {} in {}", this, discoveredNodes);
                        }
                        selectedNode = discoveredNode;
                        continue;
                    }
                    throw new ElasticsearchException("node id mismatch comparing {} to {}", this, discoveredNode);
                }
                if (this.id == null || !this.id.equals(discoveredNode.getId())) continue;
                throw new ElasticsearchException("node name mismatch comparing {} to {}", this, discoveredNode);
            }
            if (selectedNode == null) {
                throw new ElasticsearchException("no node matching {} found in {}", this, discoveredNodes);
            }
            return selectedNode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeDescription that = (NodeDescription)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }
    }
}

