/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Objects;

public final class TotalHits {
    public final long value;
    public final Relation relation;

    public TotalHits(long value, Relation relation) {
        if (value < 0L) {
            throw new IllegalArgumentException("value must be >= 0, got " + value);
        }
        this.value = value;
        this.relation = Objects.requireNonNull(relation);
    }

    public String toString() {
        return this.value + (this.relation == Relation.EQUAL_TO ? "" : "+") + " hits";
    }

    public static enum Relation {
        EQUAL_TO,
        GREATER_THAN_OR_EQUAL_TO;

    }
}

