/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.InPlaceMergeSorter;

public abstract class BlendedTermQuery
extends Query {
    private final Term[] terms;
    private final float[] boosts;
    private volatile Term[] equalTerms = null;

    public BlendedTermQuery(Term[] terms, float[] boosts) {
        if (terms == null || terms.length == 0) {
            throw new IllegalArgumentException("terms must not be null or empty");
        }
        if (boosts != null && boosts.length != terms.length) {
            throw new IllegalArgumentException("boosts must have the same size as terms");
        }
        this.terms = terms;
        this.boosts = boosts;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = super.rewrite(reader);
        if (rewritten != this) {
            return rewritten;
        }
        IndexReaderContext context = reader.getContext();
        TermStates[] ctx = new TermStates[this.terms.length];
        int[] docFreqs = new int[ctx.length];
        for (int i = 0; i < this.terms.length; ++i) {
            ctx[i] = TermStates.build(context, this.terms[i], true);
            docFreqs[i] = ctx[i].docFreq();
        }
        int maxDoc = reader.maxDoc();
        this.blend(ctx, maxDoc, reader);
        return this.topLevelQuery(this.terms, ctx, docFreqs, maxDoc);
    }

    protected abstract Query topLevelQuery(Term[] var1, TermStates[] var2, int[] var3, int var4);

    protected void blend(final TermStates[] contexts, int maxDoc, IndexReader reader) throws IOException {
        int i;
        TermStates ctx;
        if (contexts.length <= 1) {
            return;
        }
        int max = 0;
        long minSumTTF = Long.MAX_VALUE;
        for (int i2 = 0; i2 < contexts.length; ++i2) {
            TermStates ctx2 = contexts[i2];
            int df = ctx2.docFreq();
            max = Math.max(df, max);
            minSumTTF = minSumTTF != -1L && ctx2.totalTermFreq() != -1L ? Math.min(minSumTTF, reader.getSumTotalTermFreq(this.terms[i2].field())) : -1L;
        }
        if (minSumTTF != -1L && (long)maxDoc > minSumTTF) {
            maxDoc = (int)minSumTTF;
        }
        if (max == 0) {
            return;
        }
        long sumTTF = minSumTTF == -1L ? -1L : 0L;
        final int[] tieBreak = new int[contexts.length];
        for (int i3 = 0; i3 < tieBreak.length; ++i3) {
            tieBreak[i3] = i3;
        }
        new InPlaceMergeSorter(){

            @Override
            protected void swap(int i, int j) {
                int tmp = tieBreak[i];
                tieBreak[i] = tieBreak[j];
                tieBreak[j] = tmp;
            }

            @Override
            protected int compare(int i, int j) {
                return Integer.compare(contexts[tieBreak[j]].docFreq(), contexts[tieBreak[i]].docFreq());
            }
        }.sort(0, tieBreak.length);
        int prev = contexts[tieBreak[0]].docFreq();
        int actualDf = Math.min(maxDoc, max);
        assert (actualDf >= 0) : "DF must be >= 0";
        int[] nArray = tieBreak;
        int n = nArray.length;
        for (int j = 0; j < n && (ctx = contexts[i = nArray[j]]).docFreq() != 0; ++j) {
            int current = ctx.docFreq();
            if (prev > current) {
                ++actualDf;
            }
            contexts[i] = ctx = BlendedTermQuery.adjustDF(reader.getContext(), ctx, Math.min(maxDoc, actualDf));
            prev = current;
            if (sumTTF >= 0L && ctx.totalTermFreq() >= 0L) {
                sumTTF += ctx.totalTermFreq();
                continue;
            }
            sumTTF = -1L;
        }
        sumTTF = Math.min(sumTTF, minSumTTF);
        for (int i4 = 0; i4 < contexts.length; ++i4) {
            int df = contexts[i4].docFreq();
            if (df == 0) continue;
            long fixedTTF = sumTTF == -1L ? -1L : sumTTF;
            contexts[i4] = this.adjustTTF(reader.getContext(), contexts[i4], fixedTTF);
        }
    }

    private TermStates adjustTTF(IndexReaderContext readerContext, TermStates termContext, long sumTTF) throws IOException {
        assert (termContext.wasBuiltFor(readerContext));
        if (sumTTF == -1L && termContext.totalTermFreq() == -1L) {
            return termContext;
        }
        TermStates newTermContext = new TermStates(readerContext);
        List<LeafReaderContext> leaves = readerContext.leaves();
        int len = leaves == null ? 1 : leaves.size();
        int df = termContext.docFreq();
        long ttf = sumTTF;
        for (int i = 0; i < len; ++i) {
            TermState termState = termContext.get(leaves.get(i));
            if (termState == null) continue;
            newTermContext.register(termState, i, df, ttf);
            df = 0;
            ttf = 0L;
        }
        return newTermContext;
    }

    private static TermStates adjustDF(IndexReaderContext readerContext, TermStates ctx, int newDocFreq) throws IOException {
        assert (ctx.wasBuiltFor(readerContext));
        long newTTF = ctx.totalTermFreq() < 0L ? -1L : Math.max(ctx.totalTermFreq(), (long)newDocFreq);
        List<LeafReaderContext> leaves = readerContext.leaves();
        int len = leaves == null ? 1 : leaves.size();
        TermStates newCtx = new TermStates(readerContext);
        for (int i = 0; i < len; ++i) {
            TermState termState = ctx.get(leaves.get(i));
            if (termState == null) continue;
            newCtx.register(termState, i, newDocFreq, newTTF);
            newDocFreq = 0;
            newTTF = 0L;
        }
        return newCtx;
    }

    public List<Term> getTerms() {
        return Arrays.asList(this.terms);
    }

    @Override
    public String toString(String field) {
        StringBuilder builder = new StringBuilder("blended(terms:[");
        for (int i = 0; i < this.terms.length; ++i) {
            builder.append(this.terms[i]);
            float boost = 1.0f;
            if (this.boosts != null) {
                boost = this.boosts[i];
            }
            if (boost != 1.0f) {
                builder.append('^').append(boost);
            }
            builder.append(", ");
        }
        if (this.terms.length > 0) {
            builder.setLength(builder.length() - 2);
        }
        builder.append("])");
        return builder.toString();
    }

    private Term[] equalsTerms() {
        if (this.terms.length == 1) {
            return this.terms;
        }
        if (this.equalTerms == null) {
            Comparable[] t = new Term[this.terms.length];
            System.arraycopy(this.terms, 0, t, 0, this.terms.length);
            ArrayUtil.timSort((Comparable[])t);
            this.equalTerms = t;
        }
        return this.equalTerms;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        BlendedTermQuery that = (BlendedTermQuery)o;
        return Arrays.equals(this.equalsTerms(), that.equalsTerms());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), Arrays.hashCode(this.equalsTerms()));
    }

    public static BlendedTermQuery commonTermsBlendedQuery(Term[] terms, final float[] boosts, final float maxTermFrequency) {
        return new BlendedTermQuery(terms, boosts){

            @Override
            protected Query topLevelQuery(Term[] terms, TermStates[] ctx, int[] docFreqs, int maxDoc) {
                BooleanQuery.Builder highBuilder = new BooleanQuery.Builder();
                BooleanQuery.Builder lowBuilder = new BooleanQuery.Builder();
                for (int i = 0; i < terms.length; ++i) {
                    Query query = new TermQuery(terms[i], ctx[i]);
                    if (boosts != null && boosts[i] != 1.0f) {
                        query = new BoostQuery(query, boosts[i]);
                    }
                    if (maxTermFrequency >= 1.0f && (float)docFreqs[i] > maxTermFrequency || docFreqs[i] > (int)Math.ceil(maxTermFrequency * (float)maxDoc)) {
                        highBuilder.add(query, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    lowBuilder.add(query, BooleanClause.Occur.SHOULD);
                }
                BooleanQuery high = highBuilder.build();
                BooleanQuery low = lowBuilder.build();
                if (low.clauses().isEmpty()) {
                    BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
                    for (BooleanClause booleanClause : high) {
                        queryBuilder.add(booleanClause.getQuery(), BooleanClause.Occur.MUST);
                    }
                    return queryBuilder.build();
                }
                if (high.clauses().isEmpty()) {
                    return low;
                }
                return new BooleanQuery.Builder().add(high, BooleanClause.Occur.SHOULD).add(low, BooleanClause.Occur.MUST).build();
            }
        };
    }

    public static BlendedTermQuery dismaxBlendedQuery(Term[] terms, float tieBreakerMultiplier) {
        return BlendedTermQuery.dismaxBlendedQuery(terms, null, tieBreakerMultiplier);
    }

    public static BlendedTermQuery dismaxBlendedQuery(Term[] terms, final float[] boosts, final float tieBreakerMultiplier) {
        return new BlendedTermQuery(terms, boosts){

            @Override
            protected Query topLevelQuery(Term[] terms, TermStates[] ctx, int[] docFreqs, int maxDoc) {
                ArrayList<Query> queries = new ArrayList<Query>(ctx.length);
                for (int i = 0; i < terms.length; ++i) {
                    Query query = new TermQuery(terms[i], ctx[i]);
                    if (boosts != null && boosts[i] != 1.0f) {
                        query = new BoostQuery(query, boosts[i]);
                    }
                    queries.add(query);
                }
                return new DisjunctionMaxQuery(queries, tieBreakerMultiplier);
            }
        };
    }
}

