/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.blocktree.FieldReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.Outputs;

public final class BlockTreeTermsReader
extends FieldsProducer {
    static final Outputs<BytesRef> FST_OUTPUTS = ByteSequenceOutputs.getSingleton();
    static final BytesRef NO_OUTPUT = FST_OUTPUTS.getNoOutput();
    static final int OUTPUT_FLAGS_NUM_BITS = 2;
    static final int OUTPUT_FLAGS_MASK = 3;
    static final int OUTPUT_FLAG_IS_FLOOR = 1;
    static final int OUTPUT_FLAG_HAS_TERMS = 2;
    static final String TERMS_EXTENSION = "tim";
    static final String TERMS_CODEC_NAME = "BlockTreeTermsDict";
    public static final int VERSION_START = 2;
    public static final int VERSION_AUTO_PREFIX_TERMS_REMOVED = 3;
    public static final int VERSION_CURRENT = 3;
    static final String TERMS_INDEX_EXTENSION = "tip";
    static final String TERMS_INDEX_CODEC_NAME = "BlockTreeTermsIndex";
    final IndexInput termsIn;
    final PostingsReaderBase postingsReader;
    private final TreeMap<String, FieldReader> fields = new TreeMap();
    final String segment;
    final int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BlockTreeTermsReader(PostingsReaderBase postingsReader, SegmentReadState state) throws IOException {
        boolean success = false;
        IndexInput indexIn = null;
        this.postingsReader = postingsReader;
        this.segment = state.segmentInfo.name;
        String termsName = IndexFileNames.segmentFileName(this.segment, state.segmentSuffix, TERMS_EXTENSION);
        try {
            byte b;
            this.termsIn = state.directory.openInput(termsName, state.context);
            this.version = CodecUtil.checkIndexHeader(this.termsIn, TERMS_CODEC_NAME, 2, 3, state.segmentInfo.getId(), state.segmentSuffix);
            if (this.version < 3 && (b = this.termsIn.readByte()) != 0) {
                throw new CorruptIndexException("Index header pretends the index has auto-prefix terms: " + b, this.termsIn);
            }
            String indexName = IndexFileNames.segmentFileName(this.segment, state.segmentSuffix, TERMS_INDEX_EXTENSION);
            indexIn = state.directory.openInput(indexName, state.context);
            CodecUtil.checkIndexHeader(indexIn, TERMS_INDEX_CODEC_NAME, this.version, this.version, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.checksumEntireFile(indexIn);
            postingsReader.init(this.termsIn, state);
            CodecUtil.retrieveChecksum(this.termsIn);
            BlockTreeTermsReader.seekDir(this.termsIn);
            BlockTreeTermsReader.seekDir(indexIn);
            int numFields = this.termsIn.readVInt();
            if (numFields < 0) {
                throw new CorruptIndexException("invalid numFields: " + numFields, this.termsIn);
            }
            for (int i = 0; i < numFields; ++i) {
                int field = this.termsIn.readVInt();
                long numTerms = this.termsIn.readVLong();
                if (numTerms <= 0L) {
                    throw new CorruptIndexException("Illegal numTerms for field number: " + field, this.termsIn);
                }
                BytesRef rootCode = BlockTreeTermsReader.readBytesRef(this.termsIn);
                FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field);
                if (fieldInfo == null) {
                    throw new CorruptIndexException("invalid field number: " + field, this.termsIn);
                }
                long sumTotalTermFreq = this.termsIn.readVLong();
                long sumDocFreq = fieldInfo.getIndexOptions() == IndexOptions.DOCS ? sumTotalTermFreq : this.termsIn.readVLong();
                int docCount = this.termsIn.readVInt();
                int longsSize = this.termsIn.readVInt();
                if (longsSize < 0) {
                    throw new CorruptIndexException("invalid longsSize for field: " + fieldInfo.name + ", longsSize=" + longsSize, this.termsIn);
                }
                BytesRef minTerm = BlockTreeTermsReader.readBytesRef(this.termsIn);
                BytesRef maxTerm = BlockTreeTermsReader.readBytesRef(this.termsIn);
                if (docCount < 0 || docCount > state.segmentInfo.maxDoc()) {
                    throw new CorruptIndexException("invalid docCount: " + docCount + " maxDoc: " + state.segmentInfo.maxDoc(), this.termsIn);
                }
                if (sumDocFreq < (long)docCount) {
                    throw new CorruptIndexException("invalid sumDocFreq: " + sumDocFreq + " docCount: " + docCount, this.termsIn);
                }
                if (sumTotalTermFreq < sumDocFreq) {
                    throw new CorruptIndexException("invalid sumTotalTermFreq: " + sumTotalTermFreq + " sumDocFreq: " + sumDocFreq, this.termsIn);
                }
                long indexStartFP = indexIn.readVLong();
                FieldReader previous = this.fields.put(fieldInfo.name, new FieldReader(this, fieldInfo, numTerms, rootCode, sumTotalTermFreq, sumDocFreq, docCount, indexStartFP, longsSize, indexIn, minTerm, maxTerm));
                if (previous == null) continue;
                throw new CorruptIndexException("duplicate field: " + fieldInfo.name, this.termsIn);
            }
            indexIn.close();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(indexIn, this);
            throw throwable;
        }
    }

    private static BytesRef readBytesRef(IndexInput in) throws IOException {
        int numBytes = in.readVInt();
        if (numBytes < 0) {
            throw new CorruptIndexException("invalid bytes length: " + numBytes, in);
        }
        BytesRef bytes = new BytesRef();
        bytes.length = numBytes;
        bytes.bytes = new byte[numBytes];
        in.readBytes(bytes.bytes, 0, numBytes);
        return bytes;
    }

    private static void seekDir(IndexInput input) throws IOException {
        input.seek(input.length() - (long)CodecUtil.footerLength() - 8L);
        long offset = input.readLong();
        input.seek(offset);
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.termsIn, this.postingsReader);
        }
        finally {
            this.fields.clear();
        }
    }

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.fields.keySet()).iterator();
    }

    @Override
    public Terms terms(String field) throws IOException {
        assert (field != null);
        return this.fields.get(field);
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    String brToString(BytesRef b) {
        if (b == null) {
            return "null";
        }
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t) {
            return b.toString();
        }
    }

    @Override
    public long ramBytesUsed() {
        long sizeInBytes = this.postingsReader.ramBytesUsed();
        for (FieldReader reader : this.fields.values()) {
            sizeInBytes += reader.ramBytesUsed();
        }
        return sizeInBytes;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        resources.addAll(Accountables.namedAccountables("field", this.fields));
        resources.add(Accountables.namedAccountable("delegate", this.postingsReader));
        return Collections.unmodifiableList(resources);
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.termsIn);
        this.postingsReader.checkIntegrity();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.fields.size() + ",delegate=" + this.postingsReader + ")";
    }
}

