/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;

public class IndexDeprecationChecks {
    private static void fieldLevelMappingIssue(IndexMetaData indexMetaData, BiConsumer<MappingMetaData, Map<String, Object>> checker) {
        for (ObjectCursor mappingMetaData : indexMetaData.getMappings().values()) {
            Map sourceAsMap = ((MappingMetaData)mappingMetaData.value).sourceAsMap();
            checker.accept((MappingMetaData)mappingMetaData.value, sourceAsMap);
        }
    }

    private static List<String> findInPropertiesRecursively(String type, Map<String, Object> parentMap, Function<Map<?, ?>, Boolean> predicate) {
        ArrayList<String> issues = new ArrayList<String>();
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return issues;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (predicate.apply(valueMap).booleanValue()) {
                issues.add("[type: " + type + ", field: " + entry.getKey() + "]");
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (predicate.apply(multifieldValueMap).booleanValue()) {
                        issues.add("[type: " + type + ", field: " + entry.getKey() + ", multifield: " + multifieldEntry.getKey() + "]");
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, multifieldValueMap, predicate));
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, valueMap, predicate));
        }
        return issues;
    }

    static DeprecationIssue dynamicTemplateWithMatchMappingTypeCheck(IndexMetaData indexMetaData) {
        if (indexMetaData.getCreationVersion().before(Version.V_6_0_0_alpha1)) {
            ArrayList issues = new ArrayList();
            IndexDeprecationChecks.fieldLevelMappingIssue(indexMetaData, (mappingMetaData, sourceAsMap) -> {
                List dynamicTemplates = mappingMetaData.getSourceAsMap().getOrDefault("dynamic_templates", Collections.emptyList());
                for (Object template : dynamicTemplates) {
                    for (Map.Entry prop : ((Map)template).entrySet()) {
                        Map val = (Map)prop.getValue();
                        if (!val.containsKey("match_mapping_type")) continue;
                        Object mappingMatchType = val.get("match_mapping_type");
                        boolean isValidMatchType = Arrays.stream(DynamicTemplate.XContentFieldType.values()).anyMatch(v -> v.toString().equals(mappingMatchType));
                        if (isValidMatchType) continue;
                        issues.add("type: " + mappingMetaData.type() + ", dynamicFieldDefinition" + prop.getKey() + ", unknown match_mapping_type[" + mappingMatchType + "]");
                    }
                }
            });
            if (issues.size() > 0) {
                return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Unrecognized match_mapping_type options not silently ignored", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking_60_mappings_changes.html#_unrecognized_literal_match_mapping_type_literal_options_not_silently_ignored", ((Object)issues).toString());
            }
        }
        return null;
    }

    static DeprecationIssue baseSimilarityDefinedCheck(IndexMetaData indexMetaData) {
        Settings settings;
        if (indexMetaData.getCreationVersion().before(Version.V_6_0_0_alpha1) && (settings = indexMetaData.getSettings().getAsSettings("index.similarity.base")).size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "The base similarity is now ignored as coords and query normalization have been removed.If provided, this setting will be ignored and issue a deprecation warning", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking_60_settings_changes.html#_similarity_settings", null);
        }
        return null;
    }

    static DeprecationIssue delimitedPayloadFilterCheck(IndexMetaData indexMetaData) {
        if (indexMetaData.getCreationVersion().before(Version.V_7_0_0)) {
            ArrayList<String> issues = new ArrayList<String>();
            Map filters = indexMetaData.getSettings().getGroups("index.analysis.filter");
            for (Map.Entry entry : filters.entrySet()) {
                if (!"delimited_payload_filter".equals(((Settings)entry.getValue()).get("type"))) continue;
                issues.add("The filter [" + (String)entry.getKey() + "] is of deprecated 'delimited_payload_filter' type. The filter type should be changed to 'delimited_payload'.");
            }
            if (issues.size() > 0) {
                return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Use of 'delimited_payload_filter'.", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking_70_analysis_changes.html", ((Object)issues).toString());
            }
        }
        return null;
    }

    static DeprecationIssue indexStoreTypeCheck(IndexMetaData indexMetaData) {
        if (indexMetaData.getCreationVersion().before(Version.V_6_0_0_alpha1) && indexMetaData.getSettings().get("index.store.type") != null) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "The default index.store.type has been removed. If you were using it, we advise that you simply remove it from your index settings and Elasticsearchwill use the best store implementation for your operating system.", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking_60_settings_changes.html#_store_settings", null);
        }
        return null;
    }

    static DeprecationIssue storeThrottleSettingsCheck(IndexMetaData indexMetaData) {
        if (indexMetaData.getCreationVersion().before(Version.V_6_0_0_alpha1)) {
            Settings settings = indexMetaData.getSettings();
            Settings throttleSettings = settings.getAsSettings("index.store.throttle");
            ArrayList<String> foundSettings = new ArrayList<String>();
            if (throttleSettings.get("max_bytes_per_sec") != null) {
                foundSettings.add("index.store.throttle.max_bytes_per_sec");
            }
            if (throttleSettings.get("type") != null) {
                foundSettings.add("index.store.throttle.type");
            }
            if (!foundSettings.isEmpty()) {
                return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "index.store.throttle settings are no longer recognized. these settings should be removed", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking_60_settings_changes.html#_store_throttling_settings", "present settings: " + foundSettings);
            }
        }
        return null;
    }

    static DeprecationIssue indexSharedFileSystemCheck(IndexMetaData indexMetaData) {
        if (indexMetaData.getCreationVersion().before(Version.V_6_0_0_alpha1) && indexMetaData.getSettings().get("index.shared_filesystem") != null) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "[index.shared_filesystem] setting should be removed", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_indices_changes.html#_shadow_replicas_have_been_removed", null);
        }
        return null;
    }
}

