/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.Streams;

public class TemplateUtils {
    private TemplateUtils() {
    }

    public static void loadTemplateIntoMap(String resource, Map<String, IndexTemplateMetaData> map, String templateName, String version, String versionProperty, Logger logger) {
        String template = TemplateUtils.loadTemplate(resource, version, versionProperty);
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, template);){
            map.put(templateName, IndexTemplateMetaData.Builder.fromXContent((XContentParser)parser, (String)templateName));
        }
        catch (IOException e) {
            logger.error("Error loading template [{}] as part of metadata upgrading", (Object)templateName);
        }
    }

    public static String loadTemplate(String resource, String version, String versionProperty) {
        try {
            BytesReference source = TemplateUtils.load(resource);
            TemplateUtils.validate(source);
            return TemplateUtils.filter(source, version, versionProperty);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load template [" + resource + "]", e);
        }
    }

    public static BytesReference load(String name) throws IOException {
        try (InputStream is = TemplateUtils.class.getResourceAsStream(name);){
            BytesArray bytesArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                Streams.copy((InputStream)is, (OutputStream)out);
                bytesArray = new BytesArray(out.toByteArray());
            }
            return bytesArray;
        }
    }

    public static void validate(BytesReference source) {
        if (source == null) {
            throw new ElasticsearchParseException("Template must not be null", new Object[0]);
        }
        try {
            XContentHelper.convertToMap((BytesReference)source, (boolean)false, (XContentType)XContentType.JSON).v2();
        }
        catch (NotXContentException e) {
            throw new ElasticsearchParseException("Template must not be empty", new Object[0]);
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("Invalid template", (Throwable)e, new Object[0]);
        }
    }

    public static String filter(BytesReference source, String version, String versionProperty) {
        return Pattern.compile(versionProperty).matcher(source.utf8ToString()).replaceAll(version);
    }

    public static boolean checkTemplateExistsAndVersionIsGTECurrentVersion(String templateName, ClusterState state) {
        IndexTemplateMetaData templateMetaData = (IndexTemplateMetaData)state.metaData().templates().get((Object)templateName);
        if (templateMetaData == null) {
            return false;
        }
        return templateMetaData.version() != null && templateMetaData.version() >= Version.CURRENT.id;
    }

    public static boolean checkTemplateExistsAndIsUpToDate(String templateName, String versionKey, ClusterState state, Logger logger) {
        return TemplateUtils.checkTemplateExistsAndVersionMatches(templateName, versionKey, state, logger, arg_0 -> ((Version)Version.CURRENT).equals(arg_0));
    }

    public static boolean checkTemplateExistsAndVersionMatches(String templateName, String versionKey, ClusterState state, Logger logger, Predicate<Version> predicate) {
        IndexTemplateMetaData templateMeta = (IndexTemplateMetaData)state.metaData().templates().get((Object)templateName);
        if (templateMeta == null) {
            return false;
        }
        ImmutableOpenMap mappings = templateMeta.getMappings();
        for (Object typeMapping : mappings.values().toArray()) {
            CompressedXContent typeMappingXContent = (CompressedXContent)typeMapping;
            try {
                Map typeMappingMap = (Map)XContentHelper.convertToMap((BytesReference)new BytesArray(typeMappingXContent.uncompressed()), (boolean)false, (XContentType)XContentType.JSON).v2();
                assert (typeMappingMap.size() == 1);
                String key = (String)typeMappingMap.keySet().iterator().next();
                Map mappingMap = (Map)typeMappingMap.get(key);
                if (TemplateUtils.containsCorrectVersion(versionKey, mappingMap, predicate)) continue;
                return false;
            }
            catch (ElasticsearchParseException e) {
                logger.error((Message)new ParameterizedMessage("Cannot parse the template [{}]", (Object)templateName), (Throwable)e);
                throw new IllegalStateException("Cannot parse the template " + templateName, e);
            }
        }
        return true;
    }

    private static boolean containsCorrectVersion(String versionKey, Map<String, Object> typeMappingMap, Predicate<Version> predicate) {
        Map meta = (Map)typeMappingMap.get("_meta");
        if (meta == null) {
            return false;
        }
        return predicate.test(Version.fromString((String)((String)meta.get(versionKey))));
    }
}

