/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl.action;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.ssl.action.GetCertificateInfoAction;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

public class TransportGetCertificateInfoAction
extends HandledTransportAction<GetCertificateInfoAction.Request, GetCertificateInfoAction.Response> {
    private final SSLService sslService;

    @Inject
    public TransportGetCertificateInfoAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SSLService sslService) {
        super(settings, "cluster:monitor/xpack/ssl/certificates/get", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetCertificateInfoAction.Request::new);
        this.sslService = sslService;
    }

    protected void doExecute(GetCertificateInfoAction.Request request, ActionListener<GetCertificateInfoAction.Response> listener) {
        try {
            Set<CertificateInfo> certificates = this.sslService.getLoadedCertificates();
            listener.onResponse((Object)new GetCertificateInfoAction.Response(certificates));
        }
        catch (IOException | GeneralSecurityException e) {
            listener.onFailure(e);
        }
    }
}

