/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.BoostingQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.index.search.NestedHelper;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.core.security.authz.support.SecurityQueryTemplateEvaluator;
import org.elasticsearch.xpack.core.security.user.User;

public final class DocumentPermissions {
    private final Set<BytesReference> queries;
    private final Set<BytesReference> limitedByQueries;
    private static DocumentPermissions ALLOW_ALL = new DocumentPermissions();

    DocumentPermissions() {
        this.queries = null;
        this.limitedByQueries = null;
    }

    DocumentPermissions(Set<BytesReference> queries) {
        this(queries, null);
    }

    DocumentPermissions(Set<BytesReference> queries, Set<BytesReference> scopedByQueries) {
        if (queries == null && scopedByQueries == null) {
            throw new IllegalArgumentException("one of the queries or scoped queries must be provided");
        }
        this.queries = queries != null ? Collections.unmodifiableSet(queries) : queries;
        this.limitedByQueries = scopedByQueries != null ? Collections.unmodifiableSet(scopedByQueries) : scopedByQueries;
    }

    public Set<BytesReference> getQueries() {
        return this.queries;
    }

    public Set<BytesReference> getLimitedByQueries() {
        return this.limitedByQueries;
    }

    public boolean hasDocumentLevelPermissions() {
        return this.queries != null || this.limitedByQueries != null;
    }

    public BooleanQuery filter(User user, ScriptService scriptService, ShardId shardId, Function<ShardId, QueryShardContext> queryShardContextProvider) throws IOException {
        if (this.hasDocumentLevelPermissions()) {
            BooleanQuery.Builder filter;
            if (this.queries != null && this.limitedByQueries != null) {
                filter = new BooleanQuery.Builder();
                BooleanQuery.Builder scopedFilter = new BooleanQuery.Builder();
                DocumentPermissions.buildRoleQuery(user, scriptService, shardId, queryShardContextProvider, this.limitedByQueries, scopedFilter);
                filter.add((Query)scopedFilter.build(), BooleanClause.Occur.FILTER);
                DocumentPermissions.buildRoleQuery(user, scriptService, shardId, queryShardContextProvider, this.queries, filter);
            } else if (this.queries != null) {
                filter = new BooleanQuery.Builder();
                DocumentPermissions.buildRoleQuery(user, scriptService, shardId, queryShardContextProvider, this.queries, filter);
            } else if (this.limitedByQueries != null) {
                filter = new BooleanQuery.Builder();
                DocumentPermissions.buildRoleQuery(user, scriptService, shardId, queryShardContextProvider, this.limitedByQueries, filter);
            } else {
                return null;
            }
            return filter.build();
        }
        return null;
    }

    private static void buildRoleQuery(User user, ScriptService scriptService, ShardId shardId, Function<ShardId, QueryShardContext> queryShardContextProvider, Set<BytesReference> queries, BooleanQuery.Builder filter) throws IOException {
        for (BytesReference bytesReference : queries) {
            QueryShardContext queryShardContext = queryShardContextProvider.apply(shardId);
            String templateResult = SecurityQueryTemplateEvaluator.evaluateTemplate(bytesReference.utf8ToString(), scriptService, user);
            XContentParser parser = XContentFactory.xContent((CharSequence)templateResult).createParser(queryShardContext.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, templateResult);
            try {
                QueryBuilder queryBuilder = queryShardContext.parseInnerQueryBuilder(parser);
                DocumentPermissions.verifyRoleQuery(queryBuilder);
                DocumentPermissions.failIfQueryUsesClient(queryBuilder, (QueryRewriteContext)queryShardContext);
                Query roleQuery = queryShardContext.toQuery(queryBuilder).query();
                filter.add(roleQuery, BooleanClause.Occur.SHOULD);
                if (!queryShardContext.getMapperService().hasNested()) continue;
                NestedHelper nestedHelper = new NestedHelper(queryShardContext.getMapperService());
                if (nestedHelper.mightMatchNestedDocs(roleQuery)) {
                    roleQuery = new BooleanQuery.Builder().add(roleQuery, BooleanClause.Occur.FILTER).add(Queries.newNonNestedFilter((Version)queryShardContext.indexVersionCreated()), BooleanClause.Occur.FILTER).build();
                }
                BitSetProducer rootDocs = queryShardContext.bitsetFilter(Queries.newNonNestedFilter((Version)queryShardContext.indexVersionCreated()));
                ToChildBlockJoinQuery includeNestedDocs = new ToChildBlockJoinQuery(roleQuery, rootDocs);
                filter.add((Query)includeNestedDocs, BooleanClause.Occur.SHOULD);
            }
            finally {
                if (parser == null) continue;
                parser.close();
            }
        }
        filter.setMinimumNumberShouldMatch(1);
    }

    static void verifyRoleQuery(QueryBuilder queryBuilder) throws IOException {
        if (queryBuilder instanceof TermsQueryBuilder) {
            TermsQueryBuilder termsQueryBuilder = (TermsQueryBuilder)queryBuilder;
            if (termsQueryBuilder.termsLookup() != null) {
                throw new IllegalArgumentException("terms query with terms lookup isn't supported as part of a role query");
            }
        } else if (queryBuilder instanceof GeoShapeQueryBuilder) {
            GeoShapeQueryBuilder geoShapeQueryBuilder = (GeoShapeQueryBuilder)queryBuilder;
            if (geoShapeQueryBuilder.shape() == null) {
                throw new IllegalArgumentException("geoshape query referring to indexed shapes isn't support as part of a role query");
            }
        } else {
            if (queryBuilder.getName().equals("percolate")) {
                throw new IllegalArgumentException("percolate query isn't support as part of a role query");
            }
            if (queryBuilder.getName().equals("has_child")) {
                throw new IllegalArgumentException("has_child query isn't support as part of a role query");
            }
            if (queryBuilder.getName().equals("has_parent")) {
                throw new IllegalArgumentException("has_parent query isn't support as part of a role query");
            }
            if (queryBuilder instanceof BoolQueryBuilder) {
                BoolQueryBuilder boolQueryBuilder = (BoolQueryBuilder)queryBuilder;
                ArrayList clauses = new ArrayList();
                clauses.addAll(boolQueryBuilder.filter());
                clauses.addAll(boolQueryBuilder.must());
                clauses.addAll(boolQueryBuilder.mustNot());
                clauses.addAll(boolQueryBuilder.should());
                for (QueryBuilder clause : clauses) {
                    DocumentPermissions.verifyRoleQuery(clause);
                }
            } else if (queryBuilder instanceof ConstantScoreQueryBuilder) {
                DocumentPermissions.verifyRoleQuery(((ConstantScoreQueryBuilder)queryBuilder).innerQuery());
            } else if (queryBuilder instanceof FunctionScoreQueryBuilder) {
                DocumentPermissions.verifyRoleQuery(((FunctionScoreQueryBuilder)queryBuilder).query());
            } else if (queryBuilder instanceof BoostingQueryBuilder) {
                DocumentPermissions.verifyRoleQuery(((BoostingQueryBuilder)queryBuilder).negativeQuery());
                DocumentPermissions.verifyRoleQuery(((BoostingQueryBuilder)queryBuilder).positiveQuery());
            }
        }
    }

    static void failIfQueryUsesClient(QueryBuilder queryBuilder, QueryRewriteContext original) throws IOException {
        QueryRewriteContext copy = new QueryRewriteContext(original.getXContentRegistry(), original.getWriteableRegistry(), null, () -> ((QueryRewriteContext)original).nowInMillis());
        Rewriteable.rewrite((Rewriteable)queryBuilder, (QueryRewriteContext)copy);
        if (copy.hasAsyncActions()) {
            throw new IllegalStateException("role queries are not allowed to execute additional requests");
        }
    }

    public static DocumentPermissions filteredBy(Set<BytesReference> queries) {
        if (queries == null || queries.isEmpty()) {
            throw new IllegalArgumentException("null or empty queries not permitted");
        }
        return new DocumentPermissions(queries);
    }

    public static DocumentPermissions allowAll() {
        return ALLOW_ALL;
    }

    public DocumentPermissions limitDocumentPermissions(DocumentPermissions limitedByDocumentPermissions) {
        assert (this.limitedByQueries == null && limitedByDocumentPermissions.limitedByQueries == null) : "nested scoping for document permissions is not permitted";
        if (this.queries == null && limitedByDocumentPermissions.queries == null) {
            return DocumentPermissions.allowAll();
        }
        return new DocumentPermissions(this.queries, limitedByDocumentPermissions.queries);
    }

    public String toString() {
        return "DocumentPermissions [queries=" + this.queries + ", scopedByQueries=" + this.limitedByQueries + "]";
    }
}

