/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseStateListener;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.monitoring.MonitoringField;

public class XPackLicenseState {
    static final Map<String, String[]> EXPIRATION_MESSAGES;
    static final Map<String, BiFunction<License.OperationMode, License.OperationMode, String[]>> ACKNOWLEDGMENT_MESSAGES;
    private static final Logger logger;
    private static final DeprecationLogger deprecationLogger;
    private final List<LicenseStateListener> listeners;
    private final boolean isSecurityEnabled;
    private final boolean isSecurityExplicitlyEnabled;
    private Status status = new Status(License.OperationMode.TRIAL, true);
    private boolean isSecurityEnabledByTrialVersion;

    private static String[] securityAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                switch (currentMode) {
                    case STANDARD: {
                        return new String[]{"Security will default to disabled (set " + XPackSettings.SECURITY_ENABLED.getKey() + " to enable security)."};
                    }
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: {
                        return new String[]{"Security will default to disabled (set " + XPackSettings.SECURITY_ENABLED.getKey() + " to enable security).", "Authentication will be limited to the native and file realms.", "Security tokens and API keys will not be supported.", "IP filtering and auditing will be disabled.", "Field and document level access control will be disabled.", "Custom realms will be ignored.", "A custom authorization engine will be ignored."};
                    }
                }
                break;
            }
            case GOLD: {
                switch (currentMode) {
                    case STANDARD: 
                    case TRIAL: 
                    case PLATINUM: 
                    case BASIC: {
                        return new String[]{"Field and document level access control will be disabled.", "Custom realms will be ignored.", "A custom authorization engine will be ignored."};
                    }
                }
                break;
            }
            case STANDARD: {
                switch (currentMode) {
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: 
                    case BASIC: {
                        return new String[]{"Authentication will be limited to the native realms.", "IP filtering and auditing will be disabled.", "Field and document level access control will be disabled.", "Custom realms will be ignored.", "A custom authorization engine will be ignored."};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] watcherAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                switch (currentMode) {
                    case STANDARD: 
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: {
                        return new String[]{"Watcher will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] monitoringAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                switch (currentMode) {
                    case STANDARD: 
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: {
                        return new String[]{LoggerMessageFormat.format((String)"Multi-cluster support is disabled for clusters with [{}] license. If you are\nrunning multiple clusters, users won't be able to access the clusters with\n[{}] licenses from within a single X-Pack Kibana instance. You will have to deploy a\nseparate and dedicated X-pack Kibana instance for each [{}] cluster you wish to monitor.", (Object[])new Object[]{newMode, newMode, newMode}), LoggerMessageFormat.format((String)"Automatic index cleanup is locked to {} days for clusters with [{}] license.", (Object[])new Object[]{((TimeValue)MonitoringField.HISTORY_DURATION.getDefault(Settings.EMPTY)).days(), newMode})};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] graphAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case STANDARD: 
            case GOLD: 
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case PLATINUM: {
                        return new String[]{"Graph will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] machineLearningAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case STANDARD: 
            case GOLD: 
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case PLATINUM: {
                        return new String[]{"Machine learning will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] logstashAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                if (XPackLicenseState.isBasic(currentMode)) break;
                return new String[]{"Logstash will no longer poll for centrally-managed pipelines"};
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] beatsAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                if (XPackLicenseState.isBasic(currentMode)) break;
                return new String[]{"Beats will no longer be able to use centrally-managed configuration"};
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] sqlAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case STANDARD: 
            case GOLD: 
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case PLATINUM: {
                        return new String[]{"JDBC and ODBC support will be disabled, but you can continue to use SQL CLI and REST endpoint"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static boolean isBasic(License.OperationMode mode) {
        return mode == License.OperationMode.BASIC;
    }

    public XPackLicenseState(Settings settings) {
        this.listeners = new CopyOnWriteArrayList<LicenseStateListener>();
        this.isSecurityEnabled = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings);
        this.isSecurityExplicitlyEnabled = XPackLicenseState.checkSecurityExplicitlyEnabled(settings);
        this.isSecurityEnabledByTrialVersion = false;
    }

    private static boolean checkSecurityExplicitlyEnabled(Settings settings) {
        if (((Boolean)XPackSettings.SECURITY_ENABLED.get(settings)).booleanValue()) {
            if (settings.hasValue(XPackSettings.SECURITY_ENABLED.getKey())) {
                return true;
            }
            if (((Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings)).booleanValue()) {
                deprecationLogger.deprecated("Automatically enabling security because [{}] is true. This behaviour will be removed in a future version of Elasticsearch. Please set [{}] to true", new Object[]{XPackSettings.TRANSPORT_SSL_ENABLED.getKey(), XPackSettings.SECURITY_ENABLED.getKey()});
                return true;
            }
        }
        return false;
    }

    private XPackLicenseState(XPackLicenseState xPackLicenseState) {
        this.listeners = xPackLicenseState.listeners;
        this.isSecurityEnabled = xPackLicenseState.isSecurityEnabled;
        this.isSecurityExplicitlyEnabled = xPackLicenseState.isSecurityExplicitlyEnabled;
        this.status = xPackLicenseState.status;
        this.isSecurityEnabledByTrialVersion = xPackLicenseState.isSecurityEnabledByTrialVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(License.OperationMode mode, boolean active, @Nullable Version mostRecentTrialVersion) {
        XPackLicenseState xPackLicenseState = this;
        synchronized (xPackLicenseState) {
            this.status = new Status(mode, active);
            if (this.isSecurityEnabled && !this.isSecurityExplicitlyEnabled && mode == License.OperationMode.TRIAL && !this.isSecurityEnabledByTrialVersion && (mostRecentTrialVersion == null || mostRecentTrialVersion.before(Version.V_6_3_0))) {
                logger.info("Automatically enabling security for older trial license ({})", (Object)(mostRecentTrialVersion == null ? "[pre 6.1.0]" : mostRecentTrialVersion.toString()));
                deprecationLogger.deprecated("Automatically enabling security because the current trial license was generated before 6.3.0. This behaviour will be removed in a future version of Elasticsearch. Please set [{}] to true", new Object[]{XPackSettings.SECURITY_ENABLED.getKey()});
                this.isSecurityEnabledByTrialVersion = true;
            }
        }
        this.listeners.forEach(LicenseStateListener::licenseStateChanged);
    }

    public void addListener(LicenseStateListener listener) {
        this.listeners.add(Objects.requireNonNull(listener));
    }

    public void removeListener(LicenseStateListener listener) {
        this.listeners.remove(Objects.requireNonNull(listener));
    }

    public synchronized License.OperationMode getOperationMode() {
        return this.status.mode;
    }

    public synchronized boolean isActive() {
        return this.status.active;
    }

    public synchronized boolean isAuthAllowed() {
        License.OperationMode mode = this.status.mode;
        boolean isSecurityCurrentlyEnabled = XPackLicenseState.isSecurityEnabled(mode, this.isSecurityExplicitlyEnabled, this.isSecurityEnabledByTrialVersion, this.isSecurityEnabled);
        if (isSecurityCurrentlyEnabled) {
            switch (mode) {
                case STANDARD: 
                case TRIAL: 
                case GOLD: 
                case PLATINUM: 
                case BASIC: {
                    return true;
                }
            }
        }
        return false;
    }

    public synchronized boolean isIpFilteringAllowed() {
        License.OperationMode mode = this.status.mode;
        boolean isSecurityCurrentlyEnabled = XPackLicenseState.isSecurityEnabled(mode, this.isSecurityExplicitlyEnabled, this.isSecurityEnabledByTrialVersion, this.isSecurityEnabled);
        return isSecurityCurrentlyEnabled && (mode == License.OperationMode.GOLD || mode == License.OperationMode.PLATINUM || mode == License.OperationMode.TRIAL);
    }

    public synchronized boolean isAuditingAllowed() {
        License.OperationMode mode = this.status.mode;
        boolean isSecurityCurrentlyEnabled = XPackLicenseState.isSecurityEnabled(mode, this.isSecurityExplicitlyEnabled, this.isSecurityEnabledByTrialVersion, this.isSecurityEnabled);
        return isSecurityCurrentlyEnabled && (mode == License.OperationMode.GOLD || mode == License.OperationMode.PLATINUM || mode == License.OperationMode.TRIAL);
    }

    public synchronized boolean isStatsAndHealthAllowed() {
        return this.status.active;
    }

    public synchronized boolean isDocumentAndFieldLevelSecurityAllowed() {
        License.OperationMode mode = this.status.mode;
        boolean isSecurityCurrentlyEnabled = XPackLicenseState.isSecurityEnabled(mode, this.isSecurityExplicitlyEnabled, this.isSecurityEnabledByTrialVersion, this.isSecurityEnabled);
        return isSecurityCurrentlyEnabled && (mode == License.OperationMode.TRIAL || mode == License.OperationMode.PLATINUM);
    }

    public synchronized AllowedRealmType allowedRealmType() {
        boolean isSecurityCurrentlyEnabled = XPackLicenseState.isSecurityEnabled(this.status.mode, this.isSecurityExplicitlyEnabled, this.isSecurityEnabledByTrialVersion, this.isSecurityEnabled);
        if (isSecurityCurrentlyEnabled) {
            switch (this.status.mode) {
                case TRIAL: 
                case PLATINUM: {
                    return AllowedRealmType.ALL;
                }
                case GOLD: {
                    return AllowedRealmType.DEFAULT;
                }
                case STANDARD: 
                case BASIC: {
                    return AllowedRealmType.NATIVE;
                }
            }
            return AllowedRealmType.NONE;
        }
        return AllowedRealmType.NONE;
    }

    public synchronized boolean isCustomRoleProvidersAllowed() {
        boolean isSecurityCurrentlyEnabled = XPackLicenseState.isSecurityEnabled(this.status.mode, this.isSecurityExplicitlyEnabled, this.isSecurityEnabledByTrialVersion, this.isSecurityEnabled);
        return isSecurityCurrentlyEnabled && (this.status.mode == License.OperationMode.PLATINUM || this.status.mode == License.OperationMode.TRIAL) && this.status.active;
    }

    public synchronized boolean isTokenServiceAllowed() {
        License.OperationMode mode = this.status.mode;
        boolean isSecurityCurrentlyEnabled = XPackLicenseState.isSecurityEnabled(mode, this.isSecurityExplicitlyEnabled, this.isSecurityEnabledByTrialVersion, this.isSecurityEnabled);
        return isSecurityCurrentlyEnabled && (mode == License.OperationMode.GOLD || mode == License.OperationMode.PLATINUM || mode == License.OperationMode.TRIAL);
    }

    public synchronized boolean isApiKeyServiceAllowed() {
        License.OperationMode mode = this.status.mode;
        boolean isSecurityCurrentlyEnabled = XPackLicenseState.isSecurityEnabled(mode, this.isSecurityExplicitlyEnabled, this.isSecurityEnabledByTrialVersion, this.isSecurityEnabled);
        return isSecurityCurrentlyEnabled && (mode == License.OperationMode.GOLD || mode == License.OperationMode.PLATINUM || mode == License.OperationMode.TRIAL);
    }

    public boolean isAuthorizationRealmAllowed() {
        Status localStatus = this.status;
        return (localStatus.mode == License.OperationMode.PLATINUM || localStatus.mode == License.OperationMode.TRIAL) && localStatus.active;
    }

    public synchronized boolean isAuthorizationEngineAllowed() {
        boolean isSecurityCurrentlyEnabled = XPackLicenseState.isSecurityEnabled(this.status.mode, this.isSecurityExplicitlyEnabled, this.isSecurityEnabledByTrialVersion, this.isSecurityEnabled);
        return isSecurityCurrentlyEnabled && (this.status.mode == License.OperationMode.PLATINUM || this.status.mode == License.OperationMode.TRIAL) && this.status.active;
    }

    public synchronized boolean isWatcherAllowed() {
        Status localStatus = this.status;
        if (!localStatus.active) {
            return false;
        }
        switch (localStatus.mode) {
            case STANDARD: 
            case TRIAL: 
            case GOLD: 
            case PLATINUM: {
                return true;
            }
        }
        return false;
    }

    public synchronized boolean isMonitoringAllowed() {
        return this.status.active;
    }

    public synchronized boolean isMonitoringClusterAlertsAllowed() {
        return this.isWatcherAllowed();
    }

    public synchronized boolean isUpdateRetentionAllowed() {
        License.OperationMode mode = this.status.mode;
        return mode != License.OperationMode.BASIC && mode != License.OperationMode.MISSING;
    }

    public synchronized boolean isGraphAllowed() {
        Status localStatus = this.status;
        License.OperationMode operationMode = localStatus.mode;
        boolean licensed = operationMode == License.OperationMode.TRIAL || operationMode == License.OperationMode.PLATINUM;
        return licensed && localStatus.active;
    }

    public synchronized boolean isMachineLearningAllowed() {
        Status currentStatus = this.status;
        return currentStatus.active && XPackLicenseState.isMachineLearningAllowedForOperationMode(currentStatus.mode);
    }

    public static boolean isMachineLearningAllowedForOperationMode(License.OperationMode operationMode) {
        return XPackLicenseState.isPlatinumOrTrialOperationMode(operationMode);
    }

    public synchronized boolean isRollupAllowed() {
        return this.status.active;
    }

    public synchronized boolean isLogstashAllowed() {
        Status localStatus = this.status;
        return localStatus.active && !XPackLicenseState.isBasic(localStatus.mode);
    }

    public boolean isBeatsAllowed() {
        Status localStatus = this.status;
        return localStatus.active && !XPackLicenseState.isBasic(localStatus.mode);
    }

    public synchronized boolean isDeprecationAllowed() {
        return this.status.active;
    }

    public synchronized boolean isUpgradeAllowed() {
        return this.status.active;
    }

    public boolean isIndexLifecycleAllowed() {
        Status localStatus = this.status;
        return localStatus.active;
    }

    public synchronized boolean isSqlAllowed() {
        return this.status.active;
    }

    public synchronized boolean isJdbcAllowed() {
        Status localStatus = this.status;
        License.OperationMode operationMode = localStatus.mode;
        boolean licensed = operationMode == License.OperationMode.TRIAL || operationMode == License.OperationMode.PLATINUM;
        return licensed && localStatus.active;
    }

    public synchronized boolean isOdbcAllowed() {
        Status localStatus = this.status;
        License.OperationMode operationMode = localStatus.mode;
        boolean licensed = operationMode == License.OperationMode.TRIAL || operationMode == License.OperationMode.PLATINUM;
        return licensed && localStatus.active;
    }

    public synchronized boolean isTrialLicense() {
        return this.status.mode == License.OperationMode.TRIAL;
    }

    public synchronized boolean isSecurityAvailable() {
        License.OperationMode mode = this.status.mode;
        return mode == License.OperationMode.GOLD || mode == License.OperationMode.PLATINUM || mode == License.OperationMode.STANDARD || mode == License.OperationMode.TRIAL || mode == License.OperationMode.BASIC;
    }

    public synchronized boolean isSecurityDisabledByLicenseDefaults() {
        switch (this.status.mode) {
            case TRIAL: {
                return this.isSecurityEnabled && !this.isSecurityExplicitlyEnabled && !this.isSecurityEnabledByTrialVersion;
            }
            case BASIC: {
                return this.isSecurityEnabled && !this.isSecurityExplicitlyEnabled;
            }
        }
        return false;
    }

    public static boolean isTransportTlsRequired(License license, Settings settings) {
        if (license == null) {
            return false;
        }
        switch (license.operationMode()) {
            case STANDARD: 
            case GOLD: 
            case PLATINUM: {
                return (Boolean)XPackSettings.SECURITY_ENABLED.get(settings);
            }
            case BASIC: {
                return (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false && XPackLicenseState.checkSecurityExplicitlyEnabled(settings);
            }
            case TRIAL: 
            case MISSING: {
                return false;
            }
        }
        throw new AssertionError((Object)("unknown operation mode [" + (Object)((Object)license.operationMode()) + "]"));
    }

    private static boolean isSecurityEnabled(License.OperationMode mode, boolean isSecurityExplicitlyEnabled, boolean isSecurityEnabledByTrialVersion, boolean isSecurityEnabled) {
        switch (mode) {
            case TRIAL: {
                return isSecurityExplicitlyEnabled || isSecurityEnabledByTrialVersion;
            }
            case BASIC: {
                return isSecurityExplicitlyEnabled;
            }
        }
        return isSecurityEnabled;
    }

    public synchronized boolean isCcrAllowed() {
        Status currentStatus = this.status;
        return currentStatus.active && XPackLicenseState.isCcrAllowedForOperationMode(currentStatus.mode);
    }

    public static boolean isCcrAllowedForOperationMode(License.OperationMode operationMode) {
        return XPackLicenseState.isPlatinumOrTrialOperationMode(operationMode);
    }

    public static boolean isPlatinumOrTrialOperationMode(License.OperationMode operationMode) {
        return operationMode == License.OperationMode.PLATINUM || operationMode == License.OperationMode.TRIAL;
    }

    public synchronized XPackLicenseState copyCurrentLicenseState() {
        return new XPackLicenseState(this);
    }

    static {
        LinkedHashMap<String, Object> messages = new LinkedHashMap<String, Object>();
        messages.put("security", new String[]{"Cluster health, cluster stats and indices stats operations are blocked", "All data operations (read and write) continue to work"});
        messages.put("watcher", new String[]{"PUT / GET watch APIs are disabled, DELETE watch API continues to work", "Watches execute and write to the history", "The actions of the watches don't execute"});
        messages.put("monitoring", new String[]{"The agent will stop collecting cluster and indices metrics", "The agent will stop automatically cleaning indices older than [xpack.monitoring.history.duration]"});
        messages.put("graph", new String[]{"Graph explore APIs are disabled"});
        messages.put("ml", new String[]{"Machine learning APIs are disabled"});
        messages.put("logstash", new String[]{"Logstash will continue to poll centrally-managed pipelines"});
        messages.put("beats", new String[]{"Beats will continue to poll centrally-managed configuration"});
        messages.put("deprecation", new String[]{"Deprecation APIs are disabled"});
        messages.put("upgrade", new String[]{"Upgrade API is disabled"});
        messages.put("sql", new String[]{"SQL support is disabled"});
        messages.put("rollup", new String[]{"Creating and Starting rollup jobs will no longer be allowed.", "Stopping/Deleting existing jobs, RollupCaps API and RollupSearch continue to function."});
        EXPIRATION_MESSAGES = Collections.unmodifiableMap(messages);
        messages = new LinkedHashMap();
        messages.put("security", XPackLicenseState::securityAcknowledgementMessages);
        messages.put("watcher", XPackLicenseState::watcherAcknowledgementMessages);
        messages.put("monitoring", XPackLicenseState::monitoringAcknowledgementMessages);
        messages.put("graph", XPackLicenseState::graphAcknowledgementMessages);
        messages.put("ml", XPackLicenseState::machineLearningAcknowledgementMessages);
        messages.put("logstash", XPackLicenseState::logstashAcknowledgementMessages);
        messages.put("beats", XPackLicenseState::beatsAcknowledgementMessages);
        messages.put("sql", XPackLicenseState::sqlAcknowledgementMessages);
        ACKNOWLEDGMENT_MESSAGES = Collections.unmodifiableMap(messages);
        logger = LogManager.getLogger(XPackLicenseState.class);
        deprecationLogger = new DeprecationLogger(logger);
    }

    public static enum AllowedRealmType {
        NONE,
        NATIVE,
        DEFAULT,
        ALL;

    }

    private static class Status {
        final License.OperationMode mode;
        final boolean active;

        Status(License.OperationMode mode, boolean active) {
            this.mode = mode;
            this.active = active;
        }
    }
}

