/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedRequest;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedResult;
import com.unboundid.ldap.protocol.IntermediateResponseProtocolOp;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
abstract class InterceptedOperation
implements InMemoryInterceptedRequest,
InMemoryInterceptedResult {
    private final int messageID;
    private final LDAPListenerClientConnection clientConnection;
    private final Map<String, Object> propertyMap;

    InterceptedOperation(LDAPListenerClientConnection clientConnection, int messageID) {
        this.clientConnection = clientConnection;
        this.messageID = messageID;
        this.propertyMap = new HashMap<String, Object>(10);
    }

    InterceptedOperation(InterceptedOperation operation) {
        this.clientConnection = operation.clientConnection;
        this.messageID = operation.messageID;
        this.propertyMap = operation.propertyMap;
    }

    LDAPListenerClientConnection getClientConnection() {
        return this.clientConnection;
    }

    @Override
    public final long getConnectionID() {
        if (this.clientConnection == null) {
            return -1L;
        }
        return this.clientConnection.getConnectionID();
    }

    @Override
    public String getConnectedAddress() {
        if (this.clientConnection == null) {
            return null;
        }
        Socket s = this.clientConnection.getSocket();
        if (s == null) {
            return null;
        }
        InetAddress localAddress = s.getLocalAddress();
        if (localAddress == null) {
            return null;
        }
        return localAddress.getHostAddress();
    }

    @Override
    public int getConnectedPort() {
        if (this.clientConnection == null) {
            return -1;
        }
        Socket s = this.clientConnection.getSocket();
        if (s == null) {
            return -1;
        }
        return s.getLocalPort();
    }

    @Override
    public final int getMessageID() {
        return this.messageID;
    }

    @Override
    public final void sendIntermediateResponse(IntermediateResponse intermediateResponse) throws LDAPException {
        this.clientConnection.sendIntermediateResponse(this.messageID, new IntermediateResponseProtocolOp(intermediateResponse), intermediateResponse.getControls());
    }

    @Override
    public final void sendUnsolicitedNotification(ExtendedResult unsolicitedNotification) throws LDAPException {
        this.clientConnection.sendUnsolicitedNotification(unsolicitedNotification);
    }

    @Override
    public final Object getProperty(String name) {
        return this.propertyMap.get(name);
    }

    @Override
    public final Object setProperty(String name, Object value) {
        if (value == null) {
            return this.propertyMap.remove(name);
        }
        return this.propertyMap.put(name, value);
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);

    protected final void appendCommonToString(StringBuilder buffer) {
        buffer.append("connectionID=");
        buffer.append(this.getConnectionID());
        buffer.append(", connectedAddress='");
        buffer.append(this.getConnectedAddress());
        buffer.append("', connectedPort=");
        buffer.append(this.getConnectedPort());
        buffer.append(", messageID=");
        buffer.append(this.messageID);
    }
}

