/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.cli;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.LogManager;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.LoggingAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.xpack.sql.cli.CliRepl;
import org.elasticsearch.xpack.sql.cli.CliTerminal;
import org.elasticsearch.xpack.sql.cli.ConnectionBuilder;
import org.elasticsearch.xpack.sql.cli.JLineTerminal;
import org.elasticsearch.xpack.sql.cli.command.ClearScreenCliCommand;
import org.elasticsearch.xpack.sql.cli.command.CliCommands;
import org.elasticsearch.xpack.sql.cli.command.CliSession;
import org.elasticsearch.xpack.sql.cli.command.FetchSeparatorCliCommand;
import org.elasticsearch.xpack.sql.cli.command.FetchSizeCliCommand;
import org.elasticsearch.xpack.sql.cli.command.PrintLogoCommand;
import org.elasticsearch.xpack.sql.cli.command.ServerInfoCliCommand;
import org.elasticsearch.xpack.sql.cli.command.ServerQueryCliCommand;
import org.elasticsearch.xpack.sql.client.ClientException;
import org.elasticsearch.xpack.sql.client.ConnectionConfiguration;
import org.elasticsearch.xpack.sql.client.HttpClient;
import org.elasticsearch.xpack.sql.client.Version;
import org.jline.terminal.TerminalBuilder;

public class Cli
extends LoggingAwareCommand {
    private final OptionSpec<String> keystoreLocation;
    private final OptionSpec<Boolean> checkOption;
    private final OptionSpec<String> connectionString;
    private final CliTerminal cliTerminal;

    public static void main(String[] args) throws Exception {
        Cli.configureJLineLogging();
        Cli cli = new Cli(new JLineTerminal(TerminalBuilder.builder().name("Elasticsearch SQL CLI").jansi(false).build(), true));
        int status = cli.main(args, Terminal.DEFAULT);
        if (status != 0) {
            Cli.exit(status);
        }
    }

    private static void configureJLineLogging() {
        try {
            LogManager.getLogManager().readConfiguration(Cli.class.getResourceAsStream("/logging.properties"));
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot setup logging", ex);
        }
    }

    public Cli(CliTerminal cliTerminal) {
        super("Elasticsearch SQL CLI");
        this.cliTerminal = cliTerminal;
        this.parser.acceptsAll(Arrays.asList("d", "debug"), "Enable debug logging");
        this.keystoreLocation = this.parser.acceptsAll(Arrays.asList("k", "keystore_location"), "Location of a keystore to use when setting up SSL. If specified then the CLI will prompt for a keystore password. If specified when the uri isn't https then an error is thrown.").withRequiredArg().ofType(String.class);
        this.checkOption = this.parser.acceptsAll(Arrays.asList("c", "check"), "Enable initial connection check on startup").withRequiredArg().ofType(Boolean.class).defaultsTo(Boolean.parseBoolean(System.getProperty("cli.check", "true")), (Boolean[])new Boolean[0]);
        this.connectionString = this.parser.nonOptions("uri");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options) throws Exception {
        boolean debug = options.has("d") || options.has("debug");
        boolean checkConnection = this.checkOption.value(options);
        List<String> args = this.connectionString.values(options);
        if (args.size() > 1) {
            throw new UserException(64, "expecting a single uri");
        }
        String uri = args.size() == 1 ? args.get(0) : null;
        args = this.keystoreLocation.values(options);
        if (args.size() > 1) {
            throw new UserException(64, "expecting a single keystore file");
        }
        String keystoreLocationValue = args.size() == 1 ? args.get(0) : null;
        this.execute(uri, debug, keystoreLocationValue, checkConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String uri, boolean debug, String keystoreLocation, boolean checkConnection) throws Exception {
        CliCommands cliCommand = new CliCommands(new PrintLogoCommand(), new ClearScreenCliCommand(), new FetchSizeCliCommand(), new FetchSeparatorCliCommand(), new ServerInfoCliCommand(), new ServerQueryCliCommand());
        try {
            ConnectionBuilder connectionBuilder = new ConnectionBuilder(this.cliTerminal);
            ConnectionConfiguration con = connectionBuilder.buildConnection(uri, keystoreLocation);
            CliSession cliSession = new CliSession(new HttpClient(con));
            cliSession.setDebug(debug);
            if (checkConnection) {
                this.checkConnection(cliSession, this.cliTerminal, con);
            }
            new CliRepl(this.cliTerminal, cliSession, cliCommand).execute();
        }
        finally {
            this.cliTerminal.close();
        }
    }

    private void checkConnection(CliSession cliSession, CliTerminal cliTerminal, ConnectionConfiguration con) throws UserException {
        try {
            cliSession.checkConnection();
        }
        catch (ClientException ex) {
            if (cliSession.isDebug()) {
                cliTerminal.error("Client Exception", ex.getMessage());
                cliTerminal.println();
                cliTerminal.printStackTrace(ex);
                cliTerminal.flush();
            }
            if (ex.getCause() != null && ex.getCause() instanceof ConnectException) {
                throw new UserException(74, "Cannot connect to the server " + con.connectionString() + " - " + ex.getCause().getMessage());
            }
            if (ex.getCause() != null && ex.getCause() instanceof SQLInvalidAuthorizationSpecException) {
                throw new UserException(77, "Cannot establish a secure connection to the server " + con.connectionString() + " - " + ex.getCause().getMessage());
            }
            throw new UserException(65, "Cannot communicate with the server " + con.connectionString() + ". This version of CLI only works with Elasticsearch version " + Version.CURRENT.toString());
        }
    }
}

