/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.ScriptType;

public final class Script
implements ToXContentObject,
Writeable {
    public static final String DEFAULT_SCRIPT_LANG = "painless";
    public static final String DEFAULT_TEMPLATE_LANG = "mustache";
    public static final ScriptType DEFAULT_SCRIPT_TYPE = ScriptType.INLINE;
    public static final String CONTENT_TYPE_OPTION = "content_type";
    public static final ParseField SCRIPT_PARSE_FIELD = new ParseField("script", new String[0]);
    public static final ParseField SOURCE_PARSE_FIELD = new ParseField("source", new String[0]);
    public static final ParseField LANG_PARSE_FIELD = new ParseField("lang", new String[0]);
    public static final ParseField OPTIONS_PARSE_FIELD = new ParseField("options", new String[0]);
    public static final ParseField PARAMS_PARSE_FIELD = new ParseField("params", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("script", () -> new Builder());
    private final ScriptType type;
    private final String lang;
    private final String idOrCode;
    private final Map<String, String> options;
    private final Map<String, Object> params;

    public static Script parse(XContentParser parser) throws IOException {
        return Script.parse(parser, DEFAULT_SCRIPT_LANG);
    }

    /*
     * Exception decompiling
     */
    public static Script parse(Settings settings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Script parse(XContentParser parser, String defaultLang) throws IOException {
        Objects.requireNonNull(defaultLang);
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return new Script(ScriptType.INLINE, defaultLang, parser.text(), Collections.emptyMap());
        }
        return Script.PARSER.apply(parser, null).build(defaultLang);
    }

    public Script(String idOrCode) {
        this(DEFAULT_SCRIPT_TYPE, DEFAULT_SCRIPT_LANG, idOrCode, Collections.emptyMap(), Collections.emptyMap());
    }

    public Script(ScriptType type, String lang, String idOrCode, Map<String, Object> params) {
        this(type, lang, idOrCode, type == ScriptType.INLINE ? Collections.emptyMap() : null, params);
    }

    public Script(ScriptType type, String lang, String idOrCode, Map<String, String> options, Map<String, Object> params) {
        this.type = Objects.requireNonNull(type);
        this.idOrCode = Objects.requireNonNull(idOrCode);
        this.params = Collections.unmodifiableMap(Objects.requireNonNull(params));
        if (type == ScriptType.INLINE) {
            this.lang = Objects.requireNonNull(lang);
            this.options = Collections.unmodifiableMap(Objects.requireNonNull(options));
        } else if (type == ScriptType.STORED) {
            if (lang != null) {
                throw new IllegalArgumentException("lang cannot be specified for stored scripts");
            }
            this.lang = null;
            if (options != null) {
                throw new IllegalStateException("options cannot be specified for stored scripts");
            }
            this.options = null;
        } else {
            throw new IllegalStateException("unknown script type [" + type.getName() + "]");
        }
    }

    public Script(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_5_3_0)) {
            this.type = ScriptType.readFrom(in);
            this.lang = in.readOptionalString();
            this.idOrCode = in.readString();
            Map<String, Object> options = in.readMap();
            this.options = options;
            this.params = in.readMap();
        } else if (in.getVersion().onOrAfter(Version.V_5_1_1)) {
            this.type = ScriptType.readFrom(in);
            String lang = in.readString();
            this.lang = this.type == ScriptType.STORED ? null : lang;
            this.idOrCode = in.readString();
            Map<String, Object> options = in.readMap();
            this.options = this.type != ScriptType.INLINE && options.isEmpty() ? null : options;
            this.params = in.readMap();
        } else {
            this.idOrCode = in.readString();
            this.type = in.readBoolean() ? ScriptType.readFrom(in) : DEFAULT_SCRIPT_TYPE;
            String lang = in.readOptionalString();
            this.lang = lang == null ? (this.type == ScriptType.STORED ? null : DEFAULT_SCRIPT_LANG) : lang;
            Map<String, Object> params = in.readMap();
            this.params = params == null ? new HashMap<String, Object>() : params;
            if (in.readBoolean()) {
                this.options = new HashMap<String, String>();
                XContentType contentType = in.readEnum(XContentType.class);
                this.options.put(CONTENT_TYPE_OPTION, contentType.mediaType());
            } else {
                this.options = this.type == ScriptType.INLINE ? new HashMap<String, String>() : null;
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
            this.type.writeTo(out);
            out.writeOptionalString(this.lang);
            out.writeString(this.idOrCode);
            Map<String, Object> options = this.options;
            out.writeMap(options);
            out.writeMap(this.params);
        } else if (out.getVersion().onOrAfter(Version.V_5_1_1)) {
            this.type.writeTo(out);
            if (this.lang == null) {
                out.writeString("");
            } else {
                out.writeString(this.lang);
            }
            out.writeString(this.idOrCode);
            Map<String, Object> options = this.options;
            if (options == null) {
                out.writeMap(new HashMap<String, Object>());
            } else {
                out.writeMap(options);
            }
            out.writeMap(this.params);
        } else {
            out.writeString(this.idOrCode);
            out.writeBoolean(true);
            this.type.writeTo(out);
            out.writeOptionalString(this.lang);
            if (this.params.isEmpty()) {
                out.writeMap(null);
            } else {
                out.writeMap(this.params);
            }
            if (this.options != null && this.options.containsKey(CONTENT_TYPE_OPTION)) {
                XContentType contentType = XContentType.fromMediaTypeOrFormat(this.options.get(CONTENT_TYPE_OPTION));
                out.writeBoolean(true);
                out.writeEnum(contentType);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        String contentType;
        builder.startObject();
        String string = contentType = this.options == null ? null : this.options.get(CONTENT_TYPE_OPTION);
        if (this.type == ScriptType.INLINE) {
            if (contentType != null && builder.contentType().mediaType().equals(contentType)) {
                try (StreamInput stream = new BytesArray(this.idOrCode).streamInput();){
                    builder.rawField(SOURCE_PARSE_FIELD.getPreferredName(), stream);
                }
            } else {
                builder.field(SOURCE_PARSE_FIELD.getPreferredName(), this.idOrCode);
            }
        } else {
            builder.field("id", this.idOrCode);
        }
        if (this.lang != null) {
            builder.field(LANG_PARSE_FIELD.getPreferredName(), this.lang);
        }
        if (this.options != null && !this.options.isEmpty()) {
            builder.field(OPTIONS_PARSE_FIELD.getPreferredName(), this.options);
        }
        if (!this.params.isEmpty()) {
            builder.field(PARAMS_PARSE_FIELD.getPreferredName(), this.params);
        }
        builder.endObject();
        return builder;
    }

    public ScriptType getType() {
        return this.type;
    }

    public String getLang() {
        return this.lang;
    }

    public String getIdOrCode() {
        return this.idOrCode;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Script script = (Script)o;
        if (this.type != script.type) {
            return false;
        }
        if (this.lang != null ? !this.lang.equals(script.lang) : script.lang != null) {
            return false;
        }
        if (!this.idOrCode.equals(script.idOrCode)) {
            return false;
        }
        if (this.options != null ? !this.options.equals(script.options) : script.options != null) {
            return false;
        }
        return this.params.equals(script.params);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.lang != null ? this.lang.hashCode() : 0);
        result = 31 * result + this.idOrCode.hashCode();
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        result = 31 * result + this.params.hashCode();
        return result;
    }

    public String toString() {
        return "Script{type=" + this.type + ", lang='" + this.lang + '\'' + ", idOrCode='" + this.idOrCode + '\'' + ", options=" + this.options + ", params=" + this.params + '}';
    }

    static {
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setInline(x$0), parser -> parser, ScriptType.INLINE.getParseField(), ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setStored(x$0), ScriptType.STORED.getParseField());
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setLang(x$0), LANG_PARSE_FIELD);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setOptions(x$0), XContentParser::mapStrings, OPTIONS_PARSE_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setParams(x$0), XContentParser::map, PARAMS_PARSE_FIELD, ObjectParser.ValueType.OBJECT);
    }

    private static final class Builder {
        private ScriptType type;
        private String lang;
        private String idOrCode;
        private Map<String, String> options = new HashMap<String, String>();
        private Map<String, Object> params = Collections.emptyMap();

        private Builder() {
        }

        private void setInline(XContentParser parser) {
            try {
                if (this.type != null) {
                    this.throwOnlyOneOfType();
                }
                this.type = ScriptType.INLINE;
                if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    this.idOrCode = Strings.toString(builder.copyCurrentStructure(parser));
                    this.options.put(Script.CONTENT_TYPE_OPTION, XContentType.JSON.mediaType());
                } else {
                    this.idOrCode = parser.text();
                }
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }

        private void setStored(String idOrCode) {
            if (this.type != null) {
                this.throwOnlyOneOfType();
            }
            this.type = ScriptType.STORED;
            this.idOrCode = idOrCode;
        }

        private void throwOnlyOneOfType() {
            throw new IllegalArgumentException("must only use one of [" + ScriptType.INLINE.getParseField().getPreferredName() + ", " + ScriptType.STORED.getParseField().getPreferredName() + "] when specifying a script");
        }

        private void setLang(String lang) {
            this.lang = lang;
        }

        private void setOptions(Map<String, String> options) {
            this.options.putAll(options);
        }

        private void setParams(Map<String, Object> params) {
            this.params = params;
        }

        private Script build(String defaultLang) {
            if (this.type == null) {
                throw new IllegalArgumentException("must specify either [source] for an inline script or [id] for a stored script");
            }
            if (this.type == ScriptType.INLINE) {
                if (this.lang == null) {
                    this.lang = defaultLang;
                }
                if (this.idOrCode == null) {
                    throw new IllegalArgumentException("must specify <id> for an inline script");
                }
                if (this.options.size() > 1 || this.options.size() == 1 && this.options.get(Script.CONTENT_TYPE_OPTION) == null) {
                    this.options.remove(Script.CONTENT_TYPE_OPTION);
                    throw new IllegalArgumentException("illegal compiler options [" + this.options + "] specified");
                }
            } else if (this.type == ScriptType.STORED) {
                if (this.lang != null) {
                    throw new IllegalArgumentException("illegally specified <lang> for a stored script");
                }
                if (this.idOrCode == null) {
                    throw new IllegalArgumentException("must specify <code> for a stored script");
                }
                if (this.options.isEmpty()) {
                    this.options = null;
                } else {
                    throw new IllegalArgumentException("field [" + OPTIONS_PARSE_FIELD.getPreferredName() + "] cannot be specified using a stored script");
                }
            }
            return new Script(this.type, this.lang, this.idOrCode, this.options, this.params);
        }
    }
}

