/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestGetFieldMappingAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestGetFieldMappingAction.class));
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] The parameter include_type_name should be explicitly specified in get field mapping requests to prepare for 7.0. In 7.0 include_type_name will default to 'false', which means responses will omit the type name in mapping definitions.";

    public RestGetFieldMappingAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping/field/{fields}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping/{type}/field/{fields}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping/field/{fields}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mapping/field/{fields}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping/{type}/field/{fields}", this);
    }

    @Override
    public String getName() {
        return "get_field_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        final String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        final String[] types = request.paramAsStringArrayOrEmptyIfAll("type");
        final String[] fields = Strings.splitStringByCommaToArray(request.param("fields"));
        boolean includeTypeName = request.paramAsBoolean("include_type_name", true);
        if (!request.hasParam("include_type_name")) {
            deprecationLogger.deprecatedAndMaybeLog("get_field_mapping_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        if (!includeTypeName && types.length > 0) {
            throw new IllegalArgumentException("Cannot set include_type_name=false and specify types at the same time.");
        }
        GetFieldMappingsRequest getMappingsRequest = new GetFieldMappingsRequest();
        getMappingsRequest.indices(indices).types(types).fields(fields).includeDefaults(request.paramAsBoolean("include_defaults", false));
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest(request, getMappingsRequest.indicesOptions()));
        getMappingsRequest.local(request.paramAsBoolean("local", getMappingsRequest.local()));
        return channel -> client.admin().indices().getFieldMappings(getMappingsRequest, (ActionListener<GetFieldMappingsResponse>)new RestBuilderListener<GetFieldMappingsResponse>(channel){

            @Override
            public RestResponse buildResponse(GetFieldMappingsResponse response, XContentBuilder builder) throws Exception {
                boolean isPossibleSingleFieldRequest;
                Map<String, Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>>> mappingsByIndex = response.mappings();
                boolean bl = isPossibleSingleFieldRequest = indices.length == 1 && types.length == 1 && fields.length == 1;
                if (isPossibleSingleFieldRequest && RestGetFieldMappingAction.this.isFieldMappingMissingField(mappingsByIndex)) {
                    return new BytesRestResponse(RestStatus.OK, builder.startObject().endObject());
                }
                RestStatus status = RestStatus.OK;
                if (mappingsByIndex.isEmpty() && fields.length > 0) {
                    status = RestStatus.NOT_FOUND;
                }
                response.toXContent(builder, request);
                return new BytesRestResponse(status, builder);
            }
        });
    }

    private boolean isFieldMappingMissingField(Map<String, Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>>> mappingsByIndex) {
        if (mappingsByIndex.size() != 1) {
            return false;
        }
        for (Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>> value : mappingsByIndex.values()) {
            for (Map<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldValue : value.values()) {
                for (Map.Entry<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldMappingMetaDataEntry : fieldValue.entrySet()) {
                    if (!fieldMappingMetaDataEntry.getValue().isNull()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

