/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.Arrays;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.lucene.util.SetOnce;

@Plugin(category="Converter", name="NodeNamePatternConverter")
@ConverterKeys(value={"node_name"})
public final class NodeNamePatternConverter
extends LogEventPatternConverter {
    private static final SetOnce<String> NODE_NAME = new SetOnce();

    static void setNodeName(String nodeName) {
        NODE_NAME.set(nodeName);
    }

    public static NodeNamePatternConverter newInstance(String[] options) {
        if (options.length > 0) {
            throw new IllegalArgumentException("no options supported but options provided: " + Arrays.toString(options));
        }
        return new NodeNamePatternConverter();
    }

    private NodeNamePatternConverter() {
        super("NodeName", "node_name");
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        String nodeName = NODE_NAME.get();
        toAppendTo.append(nodeName == null ? "unknown" : nodeName);
    }
}

