/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.ReplicationTask;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ReplicationGroup;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.shard.ShardNotInPrimaryModeException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportChannelResponseHandler;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public abstract class TransportReplicationAction<Request extends ReplicationRequest<Request>, ReplicaRequest extends ReplicationRequest<ReplicaRequest>, Response extends ReplicationResponse>
extends TransportAction<Request, Response> {
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    protected final ShardStateAction shardStateAction;
    protected final IndicesService indicesService;
    protected final TransportRequestOptions transportOptions;
    protected final String executor;
    protected final String transportReplicaAction;
    protected final String transportPrimaryAction;
    private final boolean syncGlobalCheckpointAfterOperation;

    protected TransportReplicationAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request, Supplier<ReplicaRequest> replicaRequest, String executor) {
        this(settings, actionName, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, request, replicaRequest, executor, false);
    }

    protected TransportReplicationAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request, Supplier<ReplicaRequest> replicaRequest, String executor, boolean syncGlobalCheckpointAfterOperation) {
        super(settings, actionName, threadPool, actionFilters, indexNameExpressionResolver, transportService.getTaskManager());
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.shardStateAction = shardStateAction;
        this.executor = executor;
        this.transportPrimaryAction = actionName + "[p]";
        this.transportReplicaAction = actionName + "[r]";
        this.registerRequestHandlers(actionName, transportService, request, replicaRequest, executor);
        this.transportOptions = this.transportOptions(settings);
        this.syncGlobalCheckpointAfterOperation = syncGlobalCheckpointAfterOperation;
    }

    protected void registerRequestHandlers(String actionName, TransportService transportService, Supplier<Request> request, Supplier<ReplicaRequest> replicaRequest, String executor) {
        transportService.registerRequestHandler(actionName, request, "same", new OperationTransportHandler());
        transportService.registerRequestHandler(this.transportPrimaryAction, () -> new ConcreteShardRequest(request), executor, new PrimaryOperationTransportHandler());
        transportService.registerRequestHandler(this.transportReplicaAction, () -> new ConcreteReplicaRequest(replicaRequest), executor, true, true, new ReplicaOperationTransportHandler());
    }

    @Override
    protected final void doExecute(Request request, ActionListener<Response> listener) {
        throw new UnsupportedOperationException("the task parameter is required for this operation");
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        new ReroutePhase(this, (ReplicationTask)task, request, listener).run();
    }

    protected ReplicationOperation.Replicas<ReplicaRequest> newReplicasProxy(long primaryTerm) {
        return new ReplicasProxy(primaryTerm);
    }

    protected abstract Response newResponseInstance();

    protected void resolveRequest(IndexMetaData indexMetaData, Request request) {
        if (((ReplicationRequest)request).waitForActiveShards() == ActiveShardCount.DEFAULT) {
            ((ReplicationRequest)request).waitForActiveShards(indexMetaData.getWaitForActiveShards());
        }
    }

    protected abstract PrimaryResult<ReplicaRequest, Response> shardOperationOnPrimary(Request var1, IndexShard var2) throws Exception;

    protected abstract ReplicaResult shardOperationOnReplica(ReplicaRequest var1, IndexShard var2) throws Exception;

    @Nullable
    protected ClusterBlockLevel globalBlockLevel() {
        return null;
    }

    @Nullable
    public ClusterBlockLevel indexBlockLevel() {
        return null;
    }

    protected boolean resolveIndex() {
        return true;
    }

    protected TransportRequestOptions transportOptions(Settings settings) {
        return TransportRequestOptions.EMPTY;
    }

    private String concreteIndex(ClusterState state, ReplicationRequest request) {
        return this.resolveIndex() ? this.indexNameExpressionResolver.concreteSingleIndex(state, request).getName() : request.index();
    }

    private ClusterBlockException blockExceptions(ClusterState state, String indexName) {
        ClusterBlockException blockException;
        ClusterBlockException blockException2;
        ClusterBlockLevel globalBlockLevel = this.globalBlockLevel();
        if (globalBlockLevel != null && (blockException2 = state.blocks().globalBlockedException(globalBlockLevel)) != null) {
            return blockException2;
        }
        ClusterBlockLevel indexBlockLevel = this.indexBlockLevel();
        if (indexBlockLevel != null && (blockException = state.blocks().indexBlockedException(indexBlockLevel, indexName)) != null) {
            return blockException;
        }
        return null;
    }

    protected boolean retryPrimaryException(Throwable e) {
        return e.getClass() == ReplicationOperation.RetryOnPrimaryException.class || TransportActions.isShardNotAvailableException(e) || this.isRetryableClusterBlockException(e);
    }

    boolean isRetryableClusterBlockException(Throwable e) {
        if (e instanceof ClusterBlockException) {
            return ((ClusterBlockException)e).retryable();
        }
        return false;
    }

    protected IndexShard getIndexShard(ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getShard(shardId.id());
    }

    protected void acquirePrimaryOperationPermit(IndexShard primary, Request request, ActionListener<Releasable> onAcquired) {
        primary.acquirePrimaryOperationPermit(onAcquired, this.executor, request);
    }

    protected void acquireReplicaOperationPermit(IndexShard replica, ReplicaRequest request, ActionListener<Releasable> onAcquired, long primaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes) {
        replica.acquireReplicaOperationPermit(primaryTerm, globalCheckpoint, maxSeqNoOfUpdatesOrDeletes, onAcquired, this.executor, request);
    }

    protected void sendReplicaRequest(ConcreteReplicaRequest<ReplicaRequest> replicaRequest, DiscoveryNode node, ActionListener<ReplicationOperation.ReplicaResponse> listener) {
        ActionListenerResponseHandler<ReplicaResponse> handler = new ActionListenerResponseHandler<ReplicaResponse>(listener, in -> {
            ReplicaResponse replicaResponse = new ReplicaResponse();
            replicaResponse.readFrom(in);
            return replicaResponse;
        });
        this.transportService.sendRequest(node, this.transportReplicaAction, replicaRequest, this.transportOptions, handler);
    }

    static void setPhase(ReplicationTask task, String phase) {
        if (task != null) {
            task.setPhase(phase);
        }
    }

    protected static final class ConcreteReplicaRequest<R extends TransportRequest>
    extends ConcreteShardRequest<R> {
        private long globalCheckpoint;
        private long maxSeqNoOfUpdatesOrDeletes;

        public ConcreteReplicaRequest(Supplier<R> requestSupplier) {
            super(requestSupplier);
        }

        public ConcreteReplicaRequest(R request, String targetAllocationID, long primaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes) {
            super(request, targetAllocationID, primaryTerm);
            this.globalCheckpoint = globalCheckpoint;
            this.maxSeqNoOfUpdatesOrDeletes = maxSeqNoOfUpdatesOrDeletes;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.globalCheckpoint = in.getVersion().onOrAfter(Version.V_6_0_0_alpha1) ? in.readZLong() : -2L;
            this.maxSeqNoOfUpdatesOrDeletes = in.getVersion().onOrAfter(Version.V_6_5_0) ? in.readZLong() : -2L;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
                out.writeZLong(this.globalCheckpoint);
            }
            if (out.getVersion().onOrAfter(Version.V_6_5_0)) {
                out.writeZLong(this.maxSeqNoOfUpdatesOrDeletes);
            }
        }

        public long getGlobalCheckpoint() {
            return this.globalCheckpoint;
        }

        public long getMaxSeqNoOfUpdatesOrDeletes() {
            return this.maxSeqNoOfUpdatesOrDeletes;
        }

        @Override
        public String toString() {
            return "ConcreteReplicaRequest{targetAllocationID='" + this.getTargetAllocationID() + '\'' + ", primaryTerm='" + this.getPrimaryTerm() + '\'' + ", request=" + this.getRequest() + ", globalCheckpoint=" + this.globalCheckpoint + ", maxSeqNoOfUpdatesOrDeletes=" + this.maxSeqNoOfUpdatesOrDeletes + '}';
        }
    }

    public static class ConcreteShardRequest<R extends TransportRequest>
    extends TransportRequest {
        private String targetAllocationID;
        private long primaryTerm;
        private R request;

        public ConcreteShardRequest(Supplier<R> requestSupplier) {
            this.request = (TransportRequest)requestSupplier.get();
            this.targetAllocationID = null;
            this.primaryTerm = 0L;
        }

        public ConcreteShardRequest(R request, String targetAllocationID, long primaryTerm) {
            Objects.requireNonNull(request);
            Objects.requireNonNull(targetAllocationID);
            this.request = request;
            this.targetAllocationID = targetAllocationID;
            this.primaryTerm = primaryTerm;
        }

        @Override
        public void setParentTask(String parentTaskNode, long parentTaskId) {
            this.request.setParentTask(parentTaskNode, parentTaskId);
        }

        @Override
        public void setParentTask(TaskId taskId) {
            ((TransportRequest)this.request).setParentTask(taskId);
        }

        @Override
        public TaskId getParentTask() {
            return ((TransportRequest)this.request).getParentTask();
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return this.request.createTask(id, type, action, parentTaskId, headers);
        }

        @Override
        public String getDescription() {
            return "[" + this.request.getDescription() + "] for aID [" + this.targetAllocationID + "] and term [" + this.primaryTerm + "]";
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.targetAllocationID = in.readString();
            this.primaryTerm = in.readVLong();
            ((TransportRequest)this.request).readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.targetAllocationID);
            out.writeVLong(this.primaryTerm);
            ((TransportRequest)this.request).writeTo(out);
        }

        public R getRequest() {
            return this.request;
        }

        public String getTargetAllocationID() {
            return this.targetAllocationID;
        }

        public long getPrimaryTerm() {
            return this.primaryTerm;
        }

        public String toString() {
            return "request: " + this.request + ", target allocation id: " + this.targetAllocationID + ", primary term: " + this.primaryTerm;
        }
    }

    protected class ReplicasProxy
    implements ReplicationOperation.Replicas<ReplicaRequest> {
        protected final long primaryTerm;

        public ReplicasProxy(long primaryTerm) {
            this.primaryTerm = primaryTerm;
        }

        @Override
        public void performOn(ShardRouting replica, ReplicaRequest request, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<ReplicationOperation.ReplicaResponse> listener) {
            String nodeId = replica.currentNodeId();
            DiscoveryNode node = TransportReplicationAction.this.clusterService.state().nodes().get(nodeId);
            if (node == null) {
                listener.onFailure(new NoNodeAvailableException("unknown node [" + nodeId + "]"));
                return;
            }
            ConcreteReplicaRequest replicaRequest = new ConcreteReplicaRequest(request, replica.allocationId().getId(), this.primaryTerm, globalCheckpoint, maxSeqNoOfUpdatesOrDeletes);
            TransportReplicationAction.this.sendReplicaRequest(replicaRequest, node, listener);
        }

        @Override
        public void failShardIfNeeded(ShardRouting replica, String message, Exception exception, ActionListener<Void> listener) {
            listener.onResponse(null);
        }

        @Override
        public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, ActionListener<Void> listener) {
            listener.onResponse(null);
        }
    }

    public static class ReplicaResponse
    extends ActionResponse
    implements ReplicationOperation.ReplicaResponse {
        private long localCheckpoint;
        private long globalCheckpoint;

        ReplicaResponse() {
        }

        public ReplicaResponse(long localCheckpoint, long globalCheckpoint) {
            assert (localCheckpoint != -2L);
            this.localCheckpoint = localCheckpoint;
            this.globalCheckpoint = globalCheckpoint;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.localCheckpoint = in.getVersion().onOrAfter(Version.V_6_0_0_alpha1) ? in.readZLong() : -3L;
            this.globalCheckpoint = in.getVersion().onOrAfter(Version.V_6_0_0_rc1) ? in.readZLong() : -3L;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
                out.writeZLong(this.localCheckpoint);
            }
            if (out.getVersion().onOrAfter(Version.V_6_0_0_rc1)) {
                out.writeZLong(this.globalCheckpoint);
            }
        }

        @Override
        public long localCheckpoint() {
            return this.localCheckpoint;
        }

        @Override
        public long globalCheckpoint() {
            return this.globalCheckpoint;
        }
    }

    class PrimaryShardReference
    extends ShardReference
    implements ReplicationOperation.Primary<Request, ReplicaRequest, PrimaryResult<ReplicaRequest, Response>> {
        PrimaryShardReference(IndexShard indexShard, Releasable operationLock) {
            super(indexShard, operationLock);
        }

        public boolean isRelocated() {
            return this.indexShard.isRelocatedPrimary();
        }

        @Override
        public void failShard(String reason, Exception e) {
            try {
                this.indexShard.failShard(reason, e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
        }

        @Override
        public PrimaryResult perform(Request request) throws Exception {
            PrimaryResult result = TransportReplicationAction.this.shardOperationOnPrimary(request, this.indexShard);
            assert (result.replicaRequest() == null || result.finalFailure == null) : "a replica request [" + result.replicaRequest() + "] with a primary failure [" + result.finalFailure + "]";
            return result;
        }

        @Override
        public void updateLocalCheckpointForShard(String allocationId, long checkpoint) {
            this.indexShard.updateLocalCheckpointForShard(allocationId, checkpoint);
        }

        @Override
        public void updateGlobalCheckpointForShard(String allocationId, long globalCheckpoint) {
            this.indexShard.updateGlobalCheckpointForShard(allocationId, globalCheckpoint);
        }

        @Override
        public long localCheckpoint() {
            return this.indexShard.getLocalCheckpoint();
        }

        @Override
        public long globalCheckpoint() {
            return this.indexShard.getGlobalCheckpoint();
        }

        @Override
        public long maxSeqNoOfUpdatesOrDeletes() {
            return this.indexShard.getMaxSeqNoOfUpdatesOrDeletes();
        }

        @Override
        public ReplicationGroup getReplicationGroup() {
            return this.indexShard.getReplicationGroup();
        }
    }

    class ShardReference
    implements Releasable {
        protected final IndexShard indexShard;
        private final Releasable operationLock;

        ShardReference(IndexShard indexShard, Releasable operationLock) {
            this.indexShard = indexShard;
            this.operationLock = operationLock;
        }

        @Override
        public void close() {
            this.operationLock.close();
        }

        public long getLocalCheckpoint() {
            return this.indexShard.getLocalCheckpoint();
        }

        public ShardRouting routingEntry() {
            return this.indexShard.routingEntry();
        }
    }

    static final class ReroutePhase
    extends AbstractRunnable {
        private final ActionListener<Response> listener;
        private final Request request;
        private final ReplicationTask task;
        private final ClusterStateObserver observer;
        private final AtomicBoolean finished = new AtomicBoolean();
        final /* synthetic */ TransportReplicationAction this$0;

        ReroutePhase(ReplicationTask task, Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.request = request;
            if (task != null) {
                this.request.setParentTask(this$0.clusterService.localNode().getId(), task.getId());
            }
            this.listener = listener;
            this.task = task;
            this.observer = new ClusterStateObserver(this$0.clusterService, ((ReplicationRequest)request).timeout(), ((TransportReplicationAction)this$0).logger, ((TransportReplicationAction)this$0).threadPool.getThreadContext());
        }

        @Override
        public void onFailure(Exception e) {
            this.finishWithUnexpectedFailure(e);
        }

        @Override
        protected void doRun() {
            TransportReplicationAction.setPhase(this.task, "routing");
            ClusterState state = this.observer.setAndGetObservedState();
            String concreteIndex = this.this$0.concreteIndex(state, this.request);
            ClusterBlockException blockException = this.this$0.blockExceptions(state, concreteIndex);
            if (blockException != null) {
                if (blockException.retryable()) {
                    this.this$0.logger.trace("cluster is blocked, scheduling a retry", (Throwable)blockException);
                    this.retry(blockException);
                } else {
                    this.finishAsFailed(blockException);
                }
            } else {
                IndexMetaData indexMetaData = state.metaData().index(concreteIndex);
                if (indexMetaData == null) {
                    this.retry(new IndexNotFoundException(concreteIndex));
                    return;
                }
                if (indexMetaData.getState() == IndexMetaData.State.CLOSE) {
                    throw new IndexClosedException(indexMetaData.getIndex());
                }
                this.this$0.resolveRequest(indexMetaData, this.request);
                assert (((ReplicationRequest)this.request).shardId() != null) : "request shardId must be set in resolveRequest";
                assert (((ReplicationRequest)this.request).waitForActiveShards() != ActiveShardCount.DEFAULT) : "request waitForActiveShards must be set in resolveRequest";
                ShardRouting primary = this.primary(state);
                if (this.retryIfUnavailable(state, primary)) {
                    return;
                }
                DiscoveryNode node = state.nodes().get(primary.currentNodeId());
                if (primary.currentNodeId().equals(state.nodes().getLocalNodeId())) {
                    this.performLocalAction(state, primary, node, indexMetaData);
                } else {
                    this.performRemoteAction(state, primary, node);
                }
            }
        }

        private void performLocalAction(ClusterState state, ShardRouting primary, DiscoveryNode node, IndexMetaData indexMetaData) {
            TransportReplicationAction.setPhase(this.task, "waiting_on_primary");
            if (this.this$0.logger.isTraceEnabled()) {
                this.this$0.logger.trace("send action [{}] to local primary [{}] for request [{}] with cluster state version [{}] to [{}] ", (Object)this.this$0.transportPrimaryAction, (Object)((ReplicationRequest)this.request).shardId(), this.request, (Object)state.version(), (Object)primary.currentNodeId());
            }
            this.performAction(node, this.this$0.transportPrimaryAction, true, new ConcreteShardRequest(this.request, primary.allocationId().getId(), indexMetaData.primaryTerm(primary.id())));
        }

        private void performRemoteAction(ClusterState state, ShardRouting primary, DiscoveryNode node) {
            if (state.version() < ((ReplicationRequest)this.request).routedBasedOnClusterVersion()) {
                this.this$0.logger.trace("failed to find primary [{}] for request [{}] despite sender thinking it would be here. Local cluster state version [{}]] is older than on sending node (version [{}]), scheduling a retry...", (Object)((ReplicationRequest)this.request).shardId(), this.request, (Object)state.version(), (Object)((ReplicationRequest)this.request).routedBasedOnClusterVersion());
                this.retryBecauseUnavailable(((ReplicationRequest)this.request).shardId(), "failed to find primary as current cluster state with version [" + state.version() + "] is stale (expected at least [" + ((ReplicationRequest)this.request).routedBasedOnClusterVersion() + "]");
                return;
            }
            ((ReplicationRequest)this.request).routedBasedOnClusterVersion(state.version());
            if (this.this$0.logger.isTraceEnabled()) {
                this.this$0.logger.trace("send action [{}] on primary [{}] for request [{}] with cluster state version [{}] to [{}]", (Object)this.this$0.actionName, (Object)((ReplicationRequest)this.request).shardId(), this.request, (Object)state.version(), (Object)primary.currentNodeId());
            }
            TransportReplicationAction.setPhase(this.task, "rerouted");
            this.performAction(node, this.this$0.actionName, false, (TransportRequest)this.request);
        }

        private boolean retryIfUnavailable(ClusterState state, ShardRouting primary) {
            if (primary == null || !primary.active()) {
                this.this$0.logger.trace("primary shard [{}] is not yet active, scheduling a retry: action [{}], request [{}], cluster state version [{}]", (Object)((ReplicationRequest)this.request).shardId(), (Object)this.this$0.actionName, this.request, (Object)state.version());
                this.retryBecauseUnavailable(((ReplicationRequest)this.request).shardId(), "primary shard is not active");
                return true;
            }
            if (!state.nodes().nodeExists(primary.currentNodeId())) {
                this.this$0.logger.trace("primary shard [{}] is assigned to an unknown node [{}], scheduling a retry: action [{}], request [{}], cluster state version [{}]", (Object)((ReplicationRequest)this.request).shardId(), (Object)primary.currentNodeId(), (Object)this.this$0.actionName, this.request, (Object)state.version());
                this.retryBecauseUnavailable(((ReplicationRequest)this.request).shardId(), "primary shard isn't assigned to a known node.");
                return true;
            }
            return false;
        }

        private ShardRouting primary(ClusterState state) {
            IndexShardRoutingTable indexShard = state.getRoutingTable().shardRoutingTable(((ReplicationRequest)this.request).shardId());
            return indexShard.primaryShard();
        }

        private void performAction(final DiscoveryNode node, String action, final boolean isPrimaryAction, final TransportRequest requestToPerform) {
            this.this$0.transportService.sendRequest(node, action, requestToPerform, this.this$0.transportOptions, new TransportResponseHandler<Response>(){

                @Override
                public Response read(StreamInput in) throws IOException {
                    Object response = ReroutePhase.this.this$0.newResponseInstance();
                    ((ReplicationResponse)response).readFrom(in);
                    return response;
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleResponse(Response response) {
                    ReroutePhase.this.finishOnSuccess(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    try {
                        Throwable cause = exp.unwrapCause();
                        if (cause instanceof ConnectTransportException || cause instanceof NodeClosedException || isPrimaryAction && ReroutePhase.this.this$0.retryPrimaryException(cause)) {
                            ReroutePhase.this.this$0.logger.trace(() -> new ParameterizedMessage("received an error from node [{}] for request [{}], scheduling a retry", (Object)node.getId(), (Object)requestToPerform), (Throwable)exp);
                            ReroutePhase.this.retry(exp);
                        } else {
                            ReroutePhase.this.finishAsFailed(exp);
                        }
                    }
                    catch (Exception e) {
                        e.addSuppressed(exp);
                        ReroutePhase.this.finishWithUnexpectedFailure(e);
                    }
                }
            });
        }

        void retry(Exception failure) {
            assert (failure != null);
            if (this.observer.isTimedOut()) {
                this.finishAsFailed(failure);
                return;
            }
            TransportReplicationAction.setPhase(this.task, "waiting_for_retry");
            ((ReplicationRequest)this.request).onRetry();
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    ReroutePhase.this.run();
                }

                @Override
                public void onClusterServiceClose() {
                    ReroutePhase.this.finishAsFailed(new NodeClosedException(ReroutePhase.this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    ReroutePhase.this.run();
                }
            });
        }

        void finishAsFailed(Exception failure) {
            if (this.finished.compareAndSet(false, true)) {
                TransportReplicationAction.setPhase(this.task, "failed");
                this.this$0.logger.trace(() -> new ParameterizedMessage("operation failed. action [{}], request [{}]", (Object)this.this$0.actionName, this.request), (Throwable)failure);
                this.listener.onFailure(failure);
            } else assert (false) : "finishAsFailed called but operation is already finished";
        }

        void finishWithUnexpectedFailure(Exception failure) {
            this.this$0.logger.warn(() -> new ParameterizedMessage("unexpected error during the primary phase for action [{}], request [{}]", (Object)this.this$0.actionName, this.request), (Throwable)failure);
            if (this.finished.compareAndSet(false, true)) {
                TransportReplicationAction.setPhase(this.task, "failed");
                this.listener.onFailure(failure);
            } else assert (false) : "finishWithUnexpectedFailure called but operation is already finished";
        }

        void finishOnSuccess(Response response) {
            if (this.finished.compareAndSet(false, true)) {
                TransportReplicationAction.setPhase(this.task, "finished");
                if (this.this$0.logger.isTraceEnabled()) {
                    this.this$0.logger.trace("operation succeeded. action [{}],request [{}]", (Object)this.this$0.actionName, this.request);
                }
                this.listener.onResponse(response);
            } else assert (false) : "finishOnSuccess called but operation is already finished";
        }

        void retryBecauseUnavailable(ShardId shardId, String message) {
            this.retry(new UnavailableShardsException(shardId, "{} Timeout: [{}], request: [{}]", message, ((ReplicationRequest)this.request).timeout(), this.request));
        }
    }

    private final class AsyncReplicaAction
    extends AbstractRunnable
    implements ActionListener<Releasable> {
        private final ReplicaRequest request;
        private final String targetAllocationID;
        private final long primaryTerm;
        private final long globalCheckpoint;
        private final long maxSeqNoOfUpdatesOrDeletes;
        private final TransportChannel channel;
        private final IndexShard replica;
        private final ReplicationTask task;
        private final ClusterStateObserver observer;
        final /* synthetic */ TransportReplicationAction this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        AsyncReplicaAction(ReplicaRequest maxSeqNoOfUpdatesOrDeletes, String string, long channel, long l3, long l4, TransportChannel transportChannel, ReplicationTask replicationTask) {
            void globalCheckpoint;
            void primaryTerm;
            void task;
            void request;
            this.this$0 = (TransportReplicationAction)l;
            this.observer = new ClusterStateObserver(this.this$0.clusterService, null, this.this$0.logger, this.this$0.threadPool.getThreadContext());
            this.request = request;
            this.channel = (TransportChannel)channel;
            this.task = task;
            this.targetAllocationID = (String)targetAllocationID;
            this.primaryTerm = primaryTerm;
            this.globalCheckpoint = globalCheckpoint;
            this.maxSeqNoOfUpdatesOrDeletes = (long)maxSeqNoOfUpdatesOrDeletes;
            ShardId shardId = request.shardId();
            assert (shardId != null) : "request shardId must be set";
            this.replica = l.getIndexShard(shardId);
        }

        @Override
        public void onResponse(Releasable releasable) {
            try {
                ReplicaResult replicaResult = this.this$0.shardOperationOnReplica(this.request, this.replica);
                releasable.close();
                ReplicaResponse response = new ReplicaResponse(this.replica.getLocalCheckpoint(), this.replica.getGlobalCheckpoint());
                replicaResult.respond(new ResponseListener(response));
            }
            catch (Exception e) {
                Releasables.closeWhileHandlingException(releasable);
                this.onFailure(e);
            }
        }

        @Override
        public void onFailure(Exception e) {
            if (e instanceof RetryOnReplicaException) {
                this.this$0.logger.trace(() -> new ParameterizedMessage("Retrying operation on replica, action [{}], request [{}]", (Object)this.this$0.transportReplicaAction, this.request), (Throwable)e);
                ((ReplicationRequest)this.request).onRetry();
                this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        String extraMessage = "action [" + AsyncReplicaAction.this.this$0.transportReplicaAction + "], request[" + AsyncReplicaAction.this.request + "]";
                        TransportChannelResponseHandler<TransportResponse.Empty> handler = new TransportChannelResponseHandler<TransportResponse.Empty>(AsyncReplicaAction.this.this$0.logger, AsyncReplicaAction.this.channel, extraMessage, in -> TransportResponse.Empty.INSTANCE);
                        AsyncReplicaAction.this.this$0.transportService.sendRequest(AsyncReplicaAction.this.this$0.clusterService.localNode(), AsyncReplicaAction.this.this$0.transportReplicaAction, new ConcreteReplicaRequest<ReplicationRequest>(AsyncReplicaAction.this.request, AsyncReplicaAction.this.targetAllocationID, AsyncReplicaAction.this.primaryTerm, AsyncReplicaAction.this.globalCheckpoint, AsyncReplicaAction.this.maxSeqNoOfUpdatesOrDeletes), handler);
                    }

                    @Override
                    public void onClusterServiceClose() {
                        AsyncReplicaAction.this.responseWithFailure(new NodeClosedException(AsyncReplicaAction.this.this$0.clusterService.localNode()));
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        throw new AssertionError((Object)"Cannot happen: there is not timeout");
                    }
                });
            } else {
                this.responseWithFailure(e);
            }
        }

        protected void responseWithFailure(Exception e) {
            try {
                TransportReplicationAction.setPhase(this.task, "finished");
                this.channel.sendResponse(e);
            }
            catch (IOException responseException) {
                responseException.addSuppressed(e);
                this.this$0.logger.warn(() -> new ParameterizedMessage("failed to send error message back to client for action [{}]", (Object)this.this$0.transportReplicaAction), (Throwable)responseException);
            }
        }

        @Override
        protected void doRun() throws Exception {
            TransportReplicationAction.setPhase(this.task, "replica");
            String actualAllocationId = this.replica.routingEntry().allocationId().getId();
            if (!actualAllocationId.equals(this.targetAllocationID)) {
                throw new ShardNotFoundException(this.replica.shardId(), "expected allocation id [{}] but found [{}]", this.targetAllocationID, actualAllocationId);
            }
            this.this$0.acquireReplicaOperationPermit(this.replica, this.request, this, this.primaryTerm, this.globalCheckpoint, this.maxSeqNoOfUpdatesOrDeletes);
        }

        private class ResponseListener
        implements ActionListener<TransportResponse.Empty> {
            private final ReplicaResponse replicaResponse;

            ResponseListener(ReplicaResponse replicaResponse) {
                this.replicaResponse = replicaResponse;
            }

            @Override
            public void onResponse(TransportResponse.Empty response) {
                if (AsyncReplicaAction.this.this$0.logger.isTraceEnabled()) {
                    AsyncReplicaAction.this.this$0.logger.trace("action [{}] completed on shard [{}] for request [{}]", (Object)AsyncReplicaAction.this.this$0.transportReplicaAction, (Object)AsyncReplicaAction.this.request.shardId(), (Object)AsyncReplicaAction.this.request);
                }
                TransportReplicationAction.setPhase(AsyncReplicaAction.this.task, "finished");
                try {
                    AsyncReplicaAction.this.channel.sendResponse(this.replicaResponse);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                AsyncReplicaAction.this.responseWithFailure(e);
            }
        }
    }

    public static class RetryOnReplicaException
    extends ElasticsearchException {
        public RetryOnReplicaException(ShardId shardId, String msg) {
            super(msg, new Object[0]);
            this.setShard(shardId);
        }

        public RetryOnReplicaException(StreamInput in) throws IOException {
            super(in);
        }
    }

    public class ReplicaOperationTransportHandler
    implements TransportRequestHandler<ConcreteReplicaRequest<ReplicaRequest>> {
        @Override
        public void messageReceived(ConcreteReplicaRequest<ReplicaRequest> replicaRequest, TransportChannel channel) throws Exception {
            throw new UnsupportedOperationException("the task parameter is required for this operation");
        }

        @Override
        public void messageReceived(ConcreteReplicaRequest<ReplicaRequest> replicaRequest, TransportChannel channel, Task task) throws Exception {
            new AsyncReplicaAction(TransportReplicationAction.this, (ReplicationRequest)replicaRequest.getRequest(), replicaRequest.getTargetAllocationID(), replicaRequest.getPrimaryTerm(), replicaRequest.getGlobalCheckpoint(), replicaRequest.getMaxSeqNoOfUpdatesOrDeletes(), channel, (ReplicationTask)task).run();
        }
    }

    public static class ReplicaResult {
        final Exception finalFailure;

        public ReplicaResult(Exception finalFailure) {
            this.finalFailure = finalFailure;
        }

        public ReplicaResult() {
            this(null);
        }

        public void respond(ActionListener<TransportResponse.Empty> listener) {
            if (this.finalFailure == null) {
                listener.onResponse(TransportResponse.Empty.INSTANCE);
            } else {
                listener.onFailure(this.finalFailure);
            }
        }
    }

    protected static class PrimaryResult<ReplicaRequest extends ReplicationRequest<ReplicaRequest>, Response extends ReplicationResponse>
    implements ReplicationOperation.PrimaryResult<ReplicaRequest> {
        final ReplicaRequest replicaRequest;
        public final Response finalResponseIfSuccessful;
        public final Exception finalFailure;

        public PrimaryResult(ReplicaRequest replicaRequest, Response finalResponseIfSuccessful, Exception finalFailure) {
            assert (finalFailure != null ^ finalResponseIfSuccessful != null) : "either a response or a failure has to be not null, found [" + finalFailure + "] failure and [" + finalResponseIfSuccessful + "] response";
            this.replicaRequest = replicaRequest;
            this.finalResponseIfSuccessful = finalResponseIfSuccessful;
            this.finalFailure = finalFailure;
        }

        public PrimaryResult(ReplicaRequest replicaRequest, Response replicationResponse) {
            this(replicaRequest, replicationResponse, null);
        }

        @Override
        public ReplicaRequest replicaRequest() {
            return this.replicaRequest;
        }

        @Override
        public void setShardInfo(ReplicationResponse.ShardInfo shardInfo) {
            if (this.finalResponseIfSuccessful != null) {
                ((ReplicationResponse)this.finalResponseIfSuccessful).setShardInfo(shardInfo);
            }
        }

        public void respond(ActionListener<Response> listener) {
            if (this.finalResponseIfSuccessful != null) {
                listener.onResponse(this.finalResponseIfSuccessful);
            } else {
                listener.onFailure(this.finalFailure);
            }
        }
    }

    class AsyncPrimaryAction
    extends AbstractRunnable {
        private final Request request;
        private final String targetAllocationID;
        private final long primaryTerm;
        private final TransportChannel channel;
        private final ReplicationTask replicationTask;
        final /* synthetic */ TransportReplicationAction this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        AsyncPrimaryAction(Request primaryTerm, String string, long channel, TransportChannel transportChannel, ReplicationTask replicationTask) {
            void replicationTask2;
            void request;
            this.this$0 = (TransportReplicationAction)this$0;
            this.request = request;
            this.targetAllocationID = targetAllocationID;
            this.primaryTerm = primaryTerm;
            this.channel = channel;
            this.replicationTask = replicationTask2;
        }

        @Override
        protected void doRun() throws Exception {
            ShardId shardId = ((ReplicationRequest)this.request).shardId();
            IndexShard indexShard = this.this$0.getIndexShard(shardId);
            ShardRouting shardRouting = indexShard.routingEntry();
            if (!shardRouting.primary()) {
                throw new ReplicationOperation.RetryOnPrimaryException(shardId, "actual shard is not a primary " + shardRouting);
            }
            String actualAllocationId = shardRouting.allocationId().getId();
            if (!actualAllocationId.equals(this.targetAllocationID)) {
                throw new ShardNotFoundException(shardId, "expected allocation id [{}] but found [{}]", this.targetAllocationID, actualAllocationId);
            }
            long actualTerm = indexShard.getPendingPrimaryTerm();
            if (actualTerm != this.primaryTerm) {
                throw new ShardNotFoundException(shardId, "expected allocation id [{}] with term [{}] but found [{}]", this.targetAllocationID, this.primaryTerm, actualTerm);
            }
            this.this$0.acquirePrimaryOperationPermit(indexShard, this.request, ActionListener.wrap(releasable -> this.runWithPrimaryShardReference(this.this$0.new PrimaryShardReference(indexShard, (Releasable)releasable)), e -> {
                if (e instanceof ShardNotInPrimaryModeException) {
                    this.onFailure(new ReplicationOperation.RetryOnPrimaryException(shardId, "shard is not in primary mode", (Throwable)e));
                } else {
                    this.onFailure((Exception)e);
                }
            }));
        }

        void runWithPrimaryShardReference(PrimaryShardReference primaryShardReference) {
            try {
                ClusterState clusterState = this.this$0.clusterService.state();
                IndexMetaData indexMetaData = clusterState.metaData().getIndexSafe(primaryShardReference.routingEntry().index());
                ClusterBlockException blockException = this.this$0.blockExceptions(clusterState, indexMetaData.getIndex().getName());
                if (blockException != null) {
                    this.this$0.logger.trace("cluster is blocked, action failed on primary", (Throwable)blockException);
                    throw blockException;
                }
                if (primaryShardReference.isRelocated()) {
                    primaryShardReference.close();
                    TransportReplicationAction.setPhase(this.replicationTask, "primary_delegation");
                    ShardRouting primary = primaryShardReference.routingEntry();
                    assert (primary.relocating()) : "indexShard is marked as relocated but routing isn't" + primary;
                    Writeable.Reader<ReplicationResponse> reader = in -> {
                        Object response = this.this$0.newResponseInstance();
                        ((ReplicationResponse)response).readFrom(in);
                        return response;
                    };
                    DiscoveryNode relocatingNode = clusterState.nodes().get(primary.relocatingNodeId());
                    this.this$0.transportService.sendRequest(relocatingNode, this.this$0.transportPrimaryAction, new ConcreteShardRequest(this.request, primary.allocationId().getRelocationId(), this.primaryTerm), this.this$0.transportOptions, new TransportChannelResponseHandler<Response>(this.this$0.logger, this.channel, "rerouting indexing to target primary " + primary, reader){

                        @Override
                        public void handleResponse(Response response) {
                            TransportReplicationAction.setPhase(AsyncPrimaryAction.this.replicationTask, "finished");
                            super.handleResponse(response);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            TransportReplicationAction.setPhase(AsyncPrimaryAction.this.replicationTask, "finished");
                            super.handleException(exp);
                        }
                    });
                } else {
                    TransportReplicationAction.setPhase(this.replicationTask, "primary");
                    ActionListener listener = this.createResponseListener(primaryShardReference);
                    this.createReplicatedOperation(this.request, ActionListener.wrap(result -> result.respond(listener), listener::onFailure), primaryShardReference).execute();
                }
            }
            catch (Exception e) {
                Releasables.closeWhileHandlingException(primaryShardReference);
                this.onFailure(e);
            }
        }

        @Override
        public void onFailure(Exception e) {
            TransportReplicationAction.setPhase(this.replicationTask, "finished");
            try {
                this.channel.sendResponse(e);
            }
            catch (IOException inner) {
                inner.addSuppressed(e);
                this.this$0.logger.warn("failed to send response", (Throwable)inner);
            }
        }

        private ActionListener<Response> createResponseListener(final PrimaryShardReference primaryShardReference) {
            return new ActionListener<Response>(){

                @Override
                public void onResponse(Response response) {
                    block5: {
                        if (AsyncPrimaryAction.this.this$0.syncGlobalCheckpointAfterOperation) {
                            IndexShard shard = primaryShardReference.indexShard;
                            try {
                                shard.maybeSyncGlobalCheckpoint("post-operation");
                            }
                            catch (Exception e) {
                                if (ExceptionsHelper.unwrap(e, AlreadyClosedException.class, IndexShardClosedException.class) != null) break block5;
                                AsyncPrimaryAction.this.this$0.logger.info(new ParameterizedMessage("{} failed to execute post-operation global checkpoint sync", (Object)shard.shardId()), (Throwable)e);
                            }
                        }
                    }
                    primaryShardReference.close();
                    TransportReplicationAction.setPhase(AsyncPrimaryAction.this.replicationTask, "finished");
                    try {
                        AsyncPrimaryAction.this.channel.sendResponse((TransportResponse)response);
                    }
                    catch (IOException e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    primaryShardReference.close();
                    TransportReplicationAction.setPhase(AsyncPrimaryAction.this.replicationTask, "finished");
                    try {
                        AsyncPrimaryAction.this.channel.sendResponse(e);
                    }
                    catch (IOException e1) {
                        AsyncPrimaryAction.this.this$0.logger.warn("failed to send response", (Throwable)e);
                    }
                }
            };
        }

        protected ReplicationOperation<Request, ReplicaRequest, PrimaryResult<ReplicaRequest, Response>> createReplicatedOperation(Request request, ActionListener<PrimaryResult<ReplicaRequest, Response>> listener, PrimaryShardReference primaryShardReference) {
            return new ReplicationOperation(request, primaryShardReference, listener, this.this$0.newReplicasProxy(this.primaryTerm), this.this$0.logger, this.this$0.actionName);
        }
    }

    protected class PrimaryOperationTransportHandler
    implements TransportRequestHandler<ConcreteShardRequest<Request>> {
        @Override
        public void messageReceived(ConcreteShardRequest<Request> request, TransportChannel channel) throws Exception {
            throw new UnsupportedOperationException("the task parameter is required for this operation");
        }

        @Override
        public void messageReceived(ConcreteShardRequest<Request> request, TransportChannel channel, Task task) {
            new AsyncPrimaryAction(TransportReplicationAction.this, (ReplicationRequest)request.request, request.targetAllocationID, request.primaryTerm, channel, (ReplicationTask)task).run();
        }
    }

    protected class OperationTransportHandler
    implements TransportRequestHandler<Request> {
        @Override
        public void messageReceived(Request request, final TransportChannel channel, Task task) throws Exception {
            TransportReplicationAction.this.execute(task, request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(e);
                        TransportReplicationAction.this.logger.warn(() -> new ParameterizedMessage("Failed to send response for {}", (Object)TransportReplicationAction.this.actionName), (Throwable)inner);
                    }
                }
            });
        }

        @Override
        public void messageReceived(Request request, TransportChannel channel) throws Exception {
            throw new UnsupportedOperationException("the task parameter is required for this operation");
        }
    }
}

