/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.CompositeAggregationCursor;
import org.elasticsearch.xpack.sql.execution.search.PagingListCursor;
import org.elasticsearch.xpack.sql.execution.search.ScrollCursor;
import org.elasticsearch.xpack.sql.execution.search.extractor.BucketExtractors;
import org.elasticsearch.xpack.sql.execution.search.extractor.HitExtractors;
import org.elasticsearch.xpack.sql.expression.function.scalar.Processors;
import org.elasticsearch.xpack.sql.expression.literal.Intervals;
import org.elasticsearch.xpack.sql.plugin.TextFormatterCursor;
import org.elasticsearch.xpack.sql.session.Cursor;

public final class Cursors {
    private static final NamedWriteableRegistry WRITEABLE_REGISTRY = new NamedWriteableRegistry(Cursors.getNamedWriteables());

    private Cursors() {
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "0", in -> Cursor.EMPTY));
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "s", ScrollCursor::new));
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "c", CompositeAggregationCursor::new));
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "f", TextFormatterCursor::new));
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "p", PagingListCursor::new));
        entries.addAll(Processors.getNamedWriteables());
        entries.addAll(HitExtractors.getNamedWriteables());
        entries.addAll(BucketExtractors.getNamedWriteables());
        entries.addAll(Intervals.getNamedWriteables());
        return entries;
    }

    public static String encodeToString(Version version, Cursor info) {
        String string;
        if (info == Cursor.EMPTY) {
            return "";
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            try (OutputStream base64 = Base64.getEncoder().wrap(os);
                 OutputStreamStreamOutput out = new OutputStreamStreamOutput(base64);){
                Version.writeVersion((Version)version, (StreamOutput)out);
                out.writeNamedWriteable((NamedWriteable)info);
            }
            string = os.toString(StandardCharsets.UTF_8.name());
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new SqlIllegalArgumentException("Unexpected failure retrieving next page", ex);
            }
        }
        os.close();
        return string;
    }

    public static Cursor decodeFromString(String info) {
        Cursor cursor;
        if (info.isEmpty()) {
            return Cursor.EMPTY;
        }
        byte[] bytes = info.getBytes(StandardCharsets.UTF_8);
        NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(StreamInput.wrap((byte[])Base64.getDecoder().decode(bytes)), WRITEABLE_REGISTRY);
        try {
            Version version = Version.readVersion((StreamInput)in);
            if (version.after(Version.CURRENT)) {
                throw new SqlIllegalArgumentException("Unsupported cursor version " + version);
            }
            in.setVersion(version);
            cursor = (Cursor)in.readNamedWriteable(Cursor.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SqlIllegalArgumentException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SqlIllegalArgumentException("Unexpected failure decoding cursor", ex);
            }
        }
        in.close();
        return cursor;
    }
}

