/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.LocateFunctionPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.LocateFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class Locate
extends ScalarFunction {
    private final Expression pattern;
    private final Expression source;
    private final Expression start;

    public Locate(Source source, Expression pattern, Expression src, Expression start) {
        super(source, start != null ? Arrays.asList(pattern, src, start) : Arrays.asList(pattern, src));
        this.pattern = pattern;
        this.source = src;
        this.start = start;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution patternResolution = TypeResolutions.isStringAndExact(this.pattern, this.sourceText(), Expressions.ParamOrdinal.FIRST);
        if (patternResolution.unresolved()) {
            return patternResolution;
        }
        Expression.TypeResolution sourceResolution = TypeResolutions.isStringAndExact(this.source, this.sourceText(), Expressions.ParamOrdinal.SECOND);
        if (sourceResolution.unresolved()) {
            return sourceResolution;
        }
        return this.start == null ? Expression.TypeResolution.TYPE_RESOLVED : TypeResolutions.isNumeric(this.start, this.sourceText(), Expressions.ParamOrdinal.THIRD);
    }

    @Override
    protected Pipe makePipe() {
        return new LocateFunctionPipe(this.source(), this, Expressions.pipe(this.pattern), Expressions.pipe(this.source), this.start == null ? null : Expressions.pipe(this.start));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Locate::new, this.pattern, this.source, this.start);
    }

    @Override
    public boolean foldable() {
        return this.pattern.foldable() && this.source.foldable() && (this.start == null || this.start.foldable());
    }

    @Override
    public Object fold() {
        return LocateFunctionProcessor.doProcess(this.pattern.fold(), this.source.fold(), this.start == null ? null : this.start.fold());
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate patternScript = this.asScript(this.pattern);
        ScriptTemplate sourceScript = this.asScript(this.source);
        ScriptTemplate startScript = this.start == null ? null : this.asScript(this.start);
        return this.asScriptFrom(patternScript, sourceScript, startScript);
    }

    private ScriptTemplate asScriptFrom(ScriptTemplate patternScript, ScriptTemplate sourceScript, ScriptTemplate startScript) {
        if (this.start == null) {
            return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{sql}.%s(%s,%s)"), "locate", patternScript.template(), sourceScript.template()), ParamsBuilder.paramsBuilder().script(patternScript.params()).script(sourceScript.params()).build(), this.dataType());
        }
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{sql}.%s(%s,%s,%s)"), "locate", patternScript.template(), sourceScript.template(), startScript.template()), ParamsBuilder.paramsBuilder().script(patternScript.params()).script(sourceScript.params()).script(startScript.params()).build(), this.dataType());
    }

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable(field.exactAttribute().name()).build(), this.dataType());
    }

    @Override
    public DataType dataType() {
        return DataType.INTEGER;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 3) {
            throw new IllegalArgumentException("expected [3] children but received [" + newChildren.size() + "]");
        }
        return new Locate(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }
}

