/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeHistogramFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeProcessor;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

public class Year
extends DateTimeHistogramFunction {
    private static long YEAR_IN_MILLIS = TimeUnit.DAYS.toMillis(1L) * 365L;

    public Year(Source source, Expression field, ZoneId zoneId) {
        super(source, field, zoneId, DateTimeProcessor.DateTimeExtractor.YEAR);
    }

    @Override
    protected NodeInfo.NodeCtor2<Expression, ZoneId, BaseDateTimeFunction> ctorForInfo() {
        return Year::new;
    }

    @Override
    protected Year replaceChild(Expression newChild) {
        return new Year(this.source(), newChild, this.zoneId());
    }

    @Override
    public String dateTimeFormat() {
        return "year";
    }

    @Override
    public Expression orderBy() {
        return this.field();
    }

    @Override
    public long interval() {
        return YEAR_IN_MILLIS;
    }
}

