/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.CategorizerState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.persistence.BatchedJobsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedStateDocIdsIterator;
import org.elasticsearch.xpack.ml.job.retention.MlDataRemover;

public class UnusedStateRemover
implements MlDataRemover {
    private static final Logger LOGGER = LogManager.getLogger(UnusedStateRemover.class);
    private final Client client;
    private final ClusterService clusterService;

    public UnusedStateRemover(Client client, ClusterService clusterService) {
        this.client = Objects.requireNonNull(client);
        this.clusterService = Objects.requireNonNull(clusterService);
    }

    @Override
    public void remove(ActionListener<Boolean> listener) {
        try {
            List<String> unusedStateDocIds = this.findUnusedStateDocIds();
            if (unusedStateDocIds.size() > 0) {
                this.executeDeleteUnusedStateDocs(unusedStateDocIds, listener);
            } else {
                listener.onResponse((Object)true);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private List<String> findUnusedStateDocIds() {
        Set<String> jobIds = this.getJobIds();
        ArrayList<String> stateDocIdsToDelete = new ArrayList<String>();
        BatchedStateDocIdsIterator stateDocIdsIterator = new BatchedStateDocIdsIterator(this.client, AnomalyDetectorsIndex.jobStateIndexPattern());
        while (stateDocIdsIterator.hasNext()) {
            Deque stateDocIds = stateDocIdsIterator.next();
            for (String stateDocId : stateDocIds) {
                String jobId = JobIdExtractor.extractJobId(stateDocId);
                if (jobId == null || jobIds.contains(jobId)) continue;
                stateDocIdsToDelete.add(stateDocId);
            }
        }
        return stateDocIdsToDelete;
    }

    private Set<String> getJobIds() {
        HashSet<String> jobIds = new HashSet<String>();
        jobIds.addAll(MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).getJobs().keySet());
        BatchedJobsIterator jobsIterator = new BatchedJobsIterator(this.client, AnomalyDetectorsIndex.configIndexName());
        while (jobsIterator.hasNext()) {
            Deque jobs = jobsIterator.next();
            jobs.stream().map(Job.Builder::getId).forEach(jobIds::add);
        }
        return jobIds;
    }

    private void executeDeleteUnusedStateDocs(List<String> unusedDocIds, ActionListener<Boolean> listener) {
        LOGGER.info("Found [{}] unused state documents; attempting to delete", (Object)unusedDocIds.size());
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()}).types(new String[]{"doc"}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(unusedDocIds.toArray(new String[0])));
        this.client.execute((Action)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, ActionListener.wrap(response -> {
            if (response.getBulkFailures().size() > 0 || response.getSearchFailures().size() > 0) {
                LOGGER.error("Some unused state documents could not be deleted due to failures: {}", (Object)(Strings.collectionToCommaDelimitedString((Iterable)response.getBulkFailures()) + "," + Strings.collectionToCommaDelimitedString((Iterable)response.getSearchFailures())));
            } else {
                LOGGER.info("Successfully deleted all unused state documents");
            }
            listener.onResponse((Object)true);
        }, e -> {
            LOGGER.error("Error deleting unused model state documents: ", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private static class JobIdExtractor {
        private static List<Function<String, String>> extractors = Arrays.asList(ModelState::extractJobId, Quantiles::extractJobId, CategorizerState::extractJobId);

        private JobIdExtractor() {
        }

        private static String extractJobId(String docId) {
            for (Function<String, String> extractor : extractors) {
                String jobId = extractor.apply(docId);
                if (jobId == null) continue;
                return jobId;
            }
            return null;
        }
    }
}

