/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.ml.job.retention.AbstractExpiredJobDataRemover;
import org.elasticsearch.xpack.ml.notifications.Auditor;

public class ExpiredResultsRemover
extends AbstractExpiredJobDataRemover {
    private static final Logger LOGGER = LogManager.getLogger(ExpiredResultsRemover.class);
    private final Auditor auditor;

    public ExpiredResultsRemover(Client client, ClusterService clusterService, Auditor auditor) {
        super(client, clusterService);
        this.auditor = Objects.requireNonNull(auditor);
    }

    @Override
    protected Long getRetentionDays(Job job) {
        return job.getResultsRetentionDays();
    }

    @Override
    protected void removeDataBefore(final Job job, final long cutoffEpochMs, final ActionListener<Boolean> listener) {
        LOGGER.debug("Removing results of job [{}] that have a timestamp before [{}]", (Object)job.getId(), (Object)cutoffEpochMs);
        DeleteByQueryRequest request = this.createDBQRequest(job, cutoffEpochMs);
        this.getClient().execute((Action)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<BulkByScrollResponse>(){

            public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                try {
                    if (bulkByScrollResponse.getDeleted() > 0L) {
                        ExpiredResultsRemover.this.auditResultsWereDeleted(job.getId(), cutoffEpochMs);
                    }
                    listener.onResponse((Object)true);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)((Object)new ElasticsearchException("Failed to remove expired results for job [" + job.getId() + "]", (Throwable)e, new Object[0])));
            }
        });
    }

    private DeleteByQueryRequest createDBQRequest(Job job, long cutoffEpochMs) {
        DeleteByQueryRequest request = new DeleteByQueryRequest();
        request.setSlices(5);
        request.indices(new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)job.getId())});
        TermsQueryBuilder excludeFilter = QueryBuilders.termsQuery((String)Result.RESULT_TYPE.getPreferredName(), (String[])new String[]{"model_size_stats", "model_forecast_request_stats", "model_forecast"});
        BoolQueryBuilder query = ExpiredResultsRemover.createQuery(job.getId(), cutoffEpochMs).filter((QueryBuilder)QueryBuilders.existsQuery((String)Result.RESULT_TYPE.getPreferredName())).mustNot((QueryBuilder)excludeFilter);
        request.setQuery((QueryBuilder)query);
        return request;
    }

    private void auditResultsWereDeleted(String jobId, long cutoffEpochMs) {
        Instant instant = Instant.ofEpochMilli(cutoffEpochMs);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneOffset.systemDefault());
        String formatted = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zonedDateTime);
        String msg = Messages.getMessage((String)"Deleted results prior to {1}", (Object[])new Object[]{formatted});
        LOGGER.debug("[{}] {}", (Object)jobId, (Object)msg);
        this.auditor.info(jobId, msg);
    }
}

