/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ml.action.DeleteModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshotField;
import org.elasticsearch.xpack.ml.job.retention.AbstractExpiredJobDataRemover;
import org.elasticsearch.xpack.ml.utils.VolatileCursorIterator;

public class ExpiredModelSnapshotsRemover
extends AbstractExpiredJobDataRemover {
    private static final Logger LOGGER = LogManager.getLogger(ExpiredModelSnapshotsRemover.class);
    private static final int MODEL_SNAPSHOT_SEARCH_SIZE = 10000;
    private final ThreadPool threadPool;

    public ExpiredModelSnapshotsRemover(Client client, ClusterService clusterService, ThreadPool threadPool) {
        super(client, clusterService);
        this.threadPool = Objects.requireNonNull(threadPool);
    }

    @Override
    protected Long getRetentionDays(Job job) {
        return job.getModelSnapshotRetentionDays();
    }

    @Override
    protected void removeDataBefore(Job job, long cutoffEpochMs, ActionListener<Boolean> listener) {
        if (job.getModelSnapshotId() == null) {
            listener.onResponse((Object)true);
            return;
        }
        LOGGER.debug("Removing model snapshots of job [{}] that have a timestamp before [{}]", (Object)job.getId(), (Object)cutoffEpochMs);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)job.getId())});
        TermQueryBuilder activeSnapshotFilter = QueryBuilders.termQuery((String)ModelSnapshotField.SNAPSHOT_ID.getPreferredName(), (String)job.getModelSnapshotId());
        TermQueryBuilder retainFilter = QueryBuilders.termQuery((String)ModelSnapshot.RETAIN.getPreferredName(), (boolean)true);
        BoolQueryBuilder query = ExpiredModelSnapshotsRemover.createQuery(job.getId(), cutoffEpochMs).filter((QueryBuilder)QueryBuilders.existsQuery((String)ModelSnapshot.SNAPSHOT_DOC_COUNT.getPreferredName())).mustNot((QueryBuilder)activeSnapshotFilter).mustNot((QueryBuilder)retainFilter);
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)query).size(10000));
        this.getClient().execute((Action)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)new ThreadedActionListener(LOGGER, this.threadPool, "ml_utility", this.expiredSnapshotsListener(job.getId(), listener), false));
    }

    private ActionListener<SearchResponse> expiredSnapshotsListener(final String jobId, final ActionListener<Boolean> listener) {
        return new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                try {
                    ArrayList<ModelSnapshot> modelSnapshots = new ArrayList<ModelSnapshot>();
                    for (SearchHit hit : searchResponse.getHits()) {
                        modelSnapshots.add(ModelSnapshot.fromJson((BytesReference)hit.getSourceRef()));
                    }
                    ExpiredModelSnapshotsRemover.this.deleteModelSnapshots(new VolatileCursorIterator(modelSnapshots), (ActionListener<Boolean>)listener);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)((Object)new ElasticsearchException("[" + jobId + "] Search for expired snapshots failed", (Throwable)e, new Object[0])));
            }
        };
    }

    private void deleteModelSnapshots(final Iterator<ModelSnapshot> modelSnapshotIterator, final ActionListener<Boolean> listener) {
        if (!modelSnapshotIterator.hasNext()) {
            listener.onResponse((Object)true);
            return;
        }
        final ModelSnapshot modelSnapshot = modelSnapshotIterator.next();
        DeleteModelSnapshotAction.Request deleteSnapshotRequest = new DeleteModelSnapshotAction.Request(modelSnapshot.getJobId(), modelSnapshot.getSnapshotId());
        this.getClient().execute((Action)DeleteModelSnapshotAction.INSTANCE, (ActionRequest)deleteSnapshotRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                try {
                    ExpiredModelSnapshotsRemover.this.deleteModelSnapshots(modelSnapshotIterator, (ActionListener<Boolean>)listener);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)((Object)new ElasticsearchException("[" + modelSnapshot.getJobId() + "] Failed to delete snapshot [" + modelSnapshot.getSnapshotId() + "]", (Throwable)e, new Object[0])));
            }
        });
    }
}

