/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedUpdate;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;

public class TransportUpdateDatafeedAction
extends TransportMasterNodeAction<UpdateDatafeedAction.Request, PutDatafeedAction.Response> {
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final JobConfigProvider jobConfigProvider;
    private final MlConfigMigrationEligibilityCheck migrationEligibilityCheck;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportUpdateDatafeedAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, NamedXContentRegistry xContentRegistry) {
        super(settings, "cluster:admin/xpack/ml/datafeeds/update", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, UpdateDatafeedAction.Request::new);
        this.datafeedConfigProvider = new DatafeedConfigProvider(client, xContentRegistry);
        this.jobConfigProvider = new JobConfigProvider(client, xContentRegistry);
        this.migrationEligibilityCheck = new MlConfigMigrationEligibilityCheck(settings, clusterService);
        this.xContentRegistry = xContentRegistry;
    }

    protected String executor() {
        return "same";
    }

    protected PutDatafeedAction.Response newResponse() {
        return new PutDatafeedAction.Response();
    }

    protected void masterOperation(UpdateDatafeedAction.Request request, ClusterState state, ActionListener<PutDatafeedAction.Response> listener) throws Exception {
        boolean datafeedConfigIsInClusterState;
        if (this.migrationEligibilityCheck.datafeedIsEligibleForMigration(request.getUpdate().getId(), state)) {
            listener.onFailure((Exception)ExceptionsHelper.configHasNotBeenMigrated((String)"update datafeed", (String)request.getUpdate().getId()));
            return;
        }
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)state);
        boolean bl = datafeedConfigIsInClusterState = mlMetadata.getDatafeed(request.getUpdate().getId()) != null;
        if (datafeedConfigIsInClusterState) {
            this.updateDatafeedInClusterState(request, listener);
        } else {
            this.updateDatafeedInIndex(request, state, listener);
        }
    }

    private void updateDatafeedInIndex(UpdateDatafeedAction.Request request, ClusterState state, ActionListener<PutDatafeedAction.Response> listener) throws Exception {
        Map headers = this.threadPool.getThreadContext().getHeaders();
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
        if (MlTasks.getDatafeedTask((String)request.getUpdate().getId(), (PersistentTasksCustomMetaData)tasks) != null) {
            listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Cannot update datafeed [{0}] while its status is {1}", (Object[])new Object[]{request.getUpdate().getId(), DatafeedState.STARTED}), (Object[])new Object[0]));
            return;
        }
        String datafeedId = request.getUpdate().getId();
        CheckedConsumer updateConsumer = ok -> this.datafeedConfigProvider.updateDatefeedConfig(request.getUpdate().getId(), request.getUpdate(), headers, this.jobConfigProvider::validateDatafeedJob, this.clusterService.state().nodes().getMinNodeVersion(), (ActionListener<DatafeedConfig>)ActionListener.wrap(updatedConfig -> listener.onResponse((Object)new PutDatafeedAction.Response(updatedConfig)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        if (request.getUpdate().getJobId() != null) {
            this.checkJobDoesNotHaveADifferentDatafeed(request.getUpdate().getJobId(), datafeedId, (ActionListener<Boolean>)ActionListener.wrap((CheckedConsumer)updateConsumer, arg_0 -> listener.onFailure(arg_0)));
        } else {
            updateConsumer.accept((Object)Boolean.TRUE);
        }
    }

    private void checkJobDoesNotHaveADifferentDatafeed(String jobId, String datafeedId, ActionListener<Boolean> listener) {
        this.datafeedConfigProvider.findDatafeedsForJobIds(Collections.singletonList(jobId), (ActionListener<Set<String>>)ActionListener.wrap(datafeedIds -> {
            if (datafeedIds.isEmpty()) {
                listener.onResponse((Object)Boolean.TRUE);
            } else if (datafeedIds.size() == 1 && datafeedIds.contains(datafeedId)) {
                listener.onResponse((Object)Boolean.TRUE);
            } else {
                listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)("A datafeed [" + (String)datafeedIds.iterator().next() + "] already exists for job [" + jobId + "]"), (Object[])new Object[0]));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void updateDatafeedInClusterState(final UpdateDatafeedAction.Request request, ActionListener<PutDatafeedAction.Response> listener) {
        final Map headers = this.threadPool.getThreadContext().getHeaders();
        this.clusterService.submitStateUpdateTask("update-datafeed-" + request.getUpdate().getId(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<PutDatafeedAction.Response>((AckedRequest)request, listener){
            private volatile DatafeedConfig updatedDatafeed;

            protected PutDatafeedAction.Response newResponse(boolean acknowledged) {
                if (acknowledged) {
                    TransportUpdateDatafeedAction.this.logger.info("Updated datafeed [{}]", (Object)request.getUpdate().getId());
                }
                return new PutDatafeedAction.Response(this.updatedDatafeed);
            }

            public ClusterState execute(ClusterState currentState) {
                DatafeedUpdate update = request.getUpdate();
                MlMetadata currentMetadata = MlMetadata.getMlMetadata((ClusterState)currentState);
                PersistentTasksCustomMetaData persistentTasks = (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks");
                MlMetadata newMetadata = new MlMetadata.Builder(currentMetadata).updateDatafeed(update, persistentTasks, headers, TransportUpdateDatafeedAction.this.xContentRegistry).build();
                this.updatedDatafeed = newMetadata.getDatafeed(update.getId());
                return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ml", (MetaData.Custom)newMetadata).build()).build();
            }
        });
    }

    protected ClusterBlockException checkBlock(UpdateDatafeedAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

