/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.StopDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.ml.action.TransportStartDatafeedAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfigReader;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;

public class TransportStopDatafeedAction
extends TransportTasksAction<TransportStartDatafeedAction.DatafeedTask, StopDatafeedAction.Request, StopDatafeedAction.Response, StopDatafeedAction.Response> {
    private final PersistentTasksService persistentTasksService;
    private final DatafeedConfigProvider datafeedConfigProvider;

    @Inject
    public TransportStopDatafeedAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, PersistentTasksService persistentTasksService, DatafeedConfigProvider datafeedConfigProvider) {
        super(settings, "cluster:admin/xpack/ml/datafeed/stop", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, StopDatafeedAction.Request::new, StopDatafeedAction.Response::new, "ml_utility");
        this.persistentTasksService = persistentTasksService;
        this.datafeedConfigProvider = datafeedConfigProvider;
    }

    static void sortDatafeedIdsByTaskState(Set<String> expandedDatafeedIds, PersistentTasksCustomMetaData tasks, List<String> startedDatafeedIds, List<String> stoppingDatafeedIds) {
        for (String expandedDatafeedId : expandedDatafeedIds) {
            TransportStopDatafeedAction.addDatafeedTaskIdAccordingToState(expandedDatafeedId, MlTasks.getDatafeedState((String)expandedDatafeedId, (PersistentTasksCustomMetaData)tasks), startedDatafeedIds, stoppingDatafeedIds);
        }
    }

    private static void addDatafeedTaskIdAccordingToState(String datafeedId, DatafeedState datafeedState, List<String> startedDatafeedIds, List<String> stoppingDatafeedIds) {
        switch (datafeedState) {
            case STARTED: {
                startedDatafeedIds.add(datafeedId);
                break;
            }
            case STOPPED: {
                break;
            }
            case STOPPING: {
                stoppingDatafeedIds.add(datafeedId);
                break;
            }
        }
    }

    protected void doExecute(Task task, StopDatafeedAction.Request request, ActionListener<StopDatafeedAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (!nodes.isLocalNodeElectedMaster()) {
            if (nodes.getMasterNode() == null) {
                listener.onFailure((Exception)new MasterNotDiscoveredException("no known master node"));
            } else {
                this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, StopDatafeedAction.Response::new));
            }
        } else {
            DatafeedConfigReader datafeedConfigReader = new DatafeedConfigReader(this.datafeedConfigProvider);
            datafeedConfigReader.expandDatafeedIds(request.getDatafeedId(), request.allowNoDatafeeds(), state, (ActionListener<SortedSet<String>>)ActionListener.wrap(expandedIds -> {
                PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
                ArrayList<String> startedDatafeeds = new ArrayList<String>();
                ArrayList<String> stoppingDatafeeds = new ArrayList<String>();
                TransportStopDatafeedAction.sortDatafeedIdsByTaskState(expandedIds, tasks, startedDatafeeds, stoppingDatafeeds);
                if (startedDatafeeds.isEmpty() && stoppingDatafeeds.isEmpty()) {
                    listener.onResponse((Object)new StopDatafeedAction.Response(true));
                    return;
                }
                request.setResolvedStartedDatafeedIds(startedDatafeeds.toArray(new String[startedDatafeeds.size()]));
                if (request.isForce()) {
                    this.forceStopDatafeed(request, listener, tasks, startedDatafeeds);
                } else {
                    this.normalStopDatafeed(task, request, listener, tasks, startedDatafeeds, stoppingDatafeeds);
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void normalStopDatafeed(Task task, StopDatafeedAction.Request request, ActionListener<StopDatafeedAction.Response> listener, PersistentTasksCustomMetaData tasks, List<String> startedDatafeeds, List<String> stoppingDatafeeds) {
        HashSet<String> executorNodes = new HashSet<String>();
        for (String datafeedId : startedDatafeeds) {
            PersistentTasksCustomMetaData.PersistentTask datafeedTask = MlTasks.getDatafeedTask((String)datafeedId, (PersistentTasksCustomMetaData)tasks);
            if (datafeedTask == null) {
                String msg = "Requested datafeed [" + datafeedId + "] be stopped, but datafeed's task could not be found.";
                assert (datafeedTask != null) : msg;
                this.logger.error(msg);
                continue;
            }
            if (datafeedTask.isAssigned()) {
                executorNodes.add(datafeedTask.getExecutorNode());
                continue;
            }
            this.persistentTasksService.sendRemoveRequest(datafeedTask.getId(), ActionListener.wrap(r -> {}, e -> {}));
        }
        request.setNodes(executorNodes.toArray(new String[executorNodes.size()]));
        List allDataFeedsToWaitFor = Stream.concat(startedDatafeeds.stream().map(MlTasks::datafeedTaskId), stoppingDatafeeds.stream().map(MlTasks::datafeedTaskId)).collect(Collectors.toList());
        ActionListener finalListener = ActionListener.wrap(r -> this.waitForDatafeedStopped(allDataFeedsToWaitFor, request, (StopDatafeedAction.Response)r, listener), arg_0 -> listener.onFailure(arg_0));
        super.doExecute(task, (BaseTasksRequest)request, finalListener);
    }

    private void forceStopDatafeed(final StopDatafeedAction.Request request, final ActionListener<StopDatafeedAction.Response> listener, PersistentTasksCustomMetaData tasks, final List<String> startedDatafeeds) {
        final AtomicInteger counter = new AtomicInteger();
        final AtomicArray failures = new AtomicArray(startedDatafeeds.size());
        for (String datafeedId : startedDatafeeds) {
            PersistentTasksCustomMetaData.PersistentTask datafeedTask = MlTasks.getDatafeedTask((String)datafeedId, (PersistentTasksCustomMetaData)tasks);
            if (datafeedTask != null) {
                this.persistentTasksService.sendRemoveRequest(datafeedTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

                    public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
                        if (counter.incrementAndGet() == startedDatafeeds.size()) {
                            TransportStopDatafeedAction.this.sendResponseOrFailure(request.getDatafeedId(), (ActionListener<StopDatafeedAction.Response>)listener, (AtomicArray<Exception>)failures);
                        }
                    }

                    public void onFailure(Exception e) {
                        int slot = counter.incrementAndGet();
                        if (!(e instanceof ResourceNotFoundException && Strings.isAllOrWildcard((String[])new String[]{request.getDatafeedId()}))) {
                            failures.set(slot - 1, (Object)e);
                        }
                        if (slot == startedDatafeeds.size()) {
                            TransportStopDatafeedAction.this.sendResponseOrFailure(request.getDatafeedId(), (ActionListener<StopDatafeedAction.Response>)listener, (AtomicArray<Exception>)failures);
                        }
                    }
                });
                continue;
            }
            String msg = "Requested datafeed [" + datafeedId + "] be force-stopped, but datafeed's task could not be found.";
            assert (datafeedTask != null) : msg;
            this.logger.error(msg);
            int slot = counter.incrementAndGet();
            failures.set(slot - 1, (Object)new RuntimeException(msg));
            if (slot != startedDatafeeds.size()) continue;
            this.sendResponseOrFailure(request.getDatafeedId(), listener, (AtomicArray<Exception>)failures);
        }
    }

    protected void taskOperation(final StopDatafeedAction.Request request, final TransportStartDatafeedAction.DatafeedTask datafeedTask, final ActionListener<StopDatafeedAction.Response> listener) {
        DatafeedState taskState = DatafeedState.STOPPING;
        datafeedTask.updatePersistentTaskState((PersistentTaskState)taskState, ActionListener.wrap(task -> this.threadPool.executor("ml_utility").execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                if (e instanceof ResourceNotFoundException && Strings.isAllOrWildcard((String[])new String[]{request.getDatafeedId()})) {
                    datafeedTask.stop("stop_datafeed (api)", request.getStopTimeout());
                    listener.onResponse((Object)new StopDatafeedAction.Response(true));
                } else {
                    listener.onFailure(e);
                }
            }

            protected void doRun() throws Exception {
                datafeedTask.stop("stop_datafeed (api)", request.getStopTimeout());
                listener.onResponse((Object)new StopDatafeedAction.Response(true));
            }
        }), e -> {
            if (e instanceof ResourceNotFoundException) {
                listener.onResponse((Object)new StopDatafeedAction.Response(true));
            } else {
                listener.onFailure(e);
            }
        }));
    }

    private void sendResponseOrFailure(String datafeedId, ActionListener<StopDatafeedAction.Response> listener, AtomicArray<Exception> failures) {
        List caughtExceptions = failures.asList();
        if (caughtExceptions.size() == 0) {
            listener.onResponse((Object)new StopDatafeedAction.Response(true));
            return;
        }
        String msg = "Failed to stop datafeed [" + datafeedId + "] with [" + caughtExceptions.size() + "] failures, rethrowing last, all Exceptions: [" + caughtExceptions.stream().map(Throwable::getMessage).collect(Collectors.joining(", ")) + "]";
        ElasticsearchException e = new ElasticsearchException(msg, (Throwable)caughtExceptions.get(0), new Object[0]);
        listener.onFailure((Exception)e);
    }

    void waitForDatafeedStopped(List<String> datafeedPersistentTaskIds, StopDatafeedAction.Request request, final StopDatafeedAction.Response response, final ActionListener<StopDatafeedAction.Response> listener) {
        this.persistentTasksService.waitForPersistentTasksCondition(persistentTasksCustomMetaData -> {
            for (String persistentTaskId : datafeedPersistentTaskIds) {
                if (persistentTasksCustomMetaData.getTask(persistentTaskId) == null) continue;
                return false;
            }
            return true;
        }, request.getTimeout(), (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean result) {
                listener.onResponse((Object)response);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    protected StopDatafeedAction.Response newResponse(StopDatafeedAction.Request request, List<StopDatafeedAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (request.getResolvedStartedDatafeedIds().length != tasks.size()) {
            if (!taskOperationFailures.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
            }
            if (!failedNodeExceptions.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
            }
            return new StopDatafeedAction.Response(true);
        }
        return new StopDatafeedAction.Response(tasks.stream().allMatch(StopDatafeedAction.Response::isStopped));
    }

    protected StopDatafeedAction.Response readTaskResponse(StreamInput in) throws IOException {
        return new StopDatafeedAction.Response(in);
    }
}

