/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.rollup.action.GetRollupIndexCapsAction;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;

public class TransportPutDatafeedAction
extends TransportMasterNodeAction<PutDatafeedAction.Request, PutDatafeedAction.Response> {
    private final XPackLicenseState licenseState;
    private final Client client;
    private final SecurityContext securityContext;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final JobConfigProvider jobConfigProvider;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportPutDatafeedAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, Client client, XPackLicenseState licenseState, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry) {
        super(settings, "cluster:admin/xpack/ml/datafeeds/put", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, PutDatafeedAction.Request::new);
        this.licenseState = licenseState;
        this.client = client;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.datafeedConfigProvider = new DatafeedConfigProvider(client, xContentRegistry);
        this.jobConfigProvider = new JobConfigProvider(client, xContentRegistry);
        this.xContentRegistry = xContentRegistry;
    }

    protected String executor() {
        return "same";
    }

    protected PutDatafeedAction.Response newResponse() {
        return new PutDatafeedAction.Response();
    }

    protected void masterOperation(PutDatafeedAction.Request request, ClusterState state, ActionListener<PutDatafeedAction.Response> listener) {
        if (this.licenseState.isAuthAllowed()) {
            String[] indices = request.getDatafeed().getIndices().toArray(new String[0]);
            String username = this.securityContext.getUser().principal();
            HasPrivilegesRequest privRequest = new HasPrivilegesRequest();
            privRequest.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
            privRequest.username(username);
            privRequest.clusterPrivileges(Strings.EMPTY_ARRAY);
            RoleDescriptor.IndicesPrivileges.Builder indicesPrivilegesBuilder = RoleDescriptor.IndicesPrivileges.builder().indices(indices);
            ActionListener privResponseListener = ActionListener.wrap(r -> this.handlePrivsResponse(username, request, (HasPrivilegesResponse)r, listener), arg_0 -> listener.onFailure(arg_0));
            ActionListener getRollupIndexCapsActionHandler = ActionListener.wrap(response -> {
                if (response.getJobs().isEmpty()) {
                    indicesPrivilegesBuilder.privileges(new String[]{"indices:data/read/search"});
                } else {
                    indicesPrivilegesBuilder.privileges(new String[]{"indices:data/read/search", "indices:admin/xpack/rollup/search"});
                }
                privRequest.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{indicesPrivilegesBuilder.build()});
                this.client.execute((Action)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    indicesPrivilegesBuilder.privileges(new String[]{"indices:data/read/search"});
                    privRequest.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{indicesPrivilegesBuilder.build()});
                    this.client.execute((Action)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
                } else {
                    listener.onFailure(e);
                }
            });
            if (RemoteClusterLicenseChecker.containsRemoteIndex((List)request.getDatafeed().getIndices())) {
                getRollupIndexCapsActionHandler.onResponse((Object)new GetRollupIndexCapsAction.Response());
            } else {
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)GetRollupIndexCapsAction.INSTANCE, (ActionRequest)new GetRollupIndexCapsAction.Request(indices), (ActionListener)getRollupIndexCapsActionHandler);
            }
        } else {
            this.putDatafeed(request, this.threadPool.getThreadContext().getHeaders(), listener);
        }
    }

    private void handlePrivsResponse(String username, PutDatafeedAction.Request request, HasPrivilegesResponse response, ActionListener<PutDatafeedAction.Response> listener) throws IOException {
        if (response.isCompleteMatch()) {
            this.putDatafeed(request, this.threadPool.getThreadContext().getHeaders(), listener);
        } else {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.startObject();
            for (ResourcePrivileges index : response.getIndexPrivileges()) {
                builder.field(index.getResource());
                builder.map(index.getPrivileges());
            }
            builder.endObject();
            listener.onFailure((Exception)Exceptions.authorizationError((String)"Cannot create datafeed [{}] because user {} lacks permissions on the indices: {}", (Object[])new Object[]{request.getDatafeed().getId(), username, Strings.toString((XContentBuilder)builder)}));
        }
    }

    private void putDatafeed(PutDatafeedAction.Request request, Map<String, String> headers, ActionListener<PutDatafeedAction.Response> listener) {
        String jobId;
        String datafeedId = request.getDatafeed().getId();
        ElasticsearchException validationError = this.checkConfigsAreNotDefinedInClusterState(datafeedId, jobId = request.getDatafeed().getJobId());
        if (validationError != null) {
            listener.onFailure((Exception)((Object)validationError));
            return;
        }
        DatafeedConfig.validateAggregations((AggregatorFactories.Builder)request.getDatafeed().getParsedAggregations(this.xContentRegistry));
        CheckedConsumer validationOk = ok -> this.datafeedConfigProvider.putDatafeedConfig(request.getDatafeed(), headers, (ActionListener<IndexResponse>)ActionListener.wrap(indexResponse -> listener.onResponse((Object)new PutDatafeedAction.Response(request.getDatafeed())), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        CheckedConsumer jobOk = ok -> this.jobConfigProvider.validateDatafeedJob(request.getDatafeed(), (ActionListener<Boolean>)ActionListener.wrap((CheckedConsumer)validationOk, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        this.checkJobDoesNotHaveADatafeed(jobId, (ActionListener<Boolean>)ActionListener.wrap((CheckedConsumer)jobOk, arg_0 -> listener.onFailure(arg_0)));
    }

    @Nullable
    private ElasticsearchException checkConfigsAreNotDefinedInClusterState(String datafeedId, String jobId) {
        ClusterState clusterState = this.clusterService.state();
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)clusterState);
        if (mlMetadata.getDatafeed(datafeedId) != null) {
            return ExceptionsHelper.datafeedAlreadyExists((String)datafeedId);
        }
        if (mlMetadata.getDatafeedByJobId(jobId).isPresent()) {
            return ExceptionsHelper.conflictStatusException((String)("Cannot create datafeed [" + datafeedId + "] as a job [" + jobId + "] defined in the cluster state references a datafeed with the same Id"), (Object[])new Object[0]);
        }
        return null;
    }

    private void checkJobDoesNotHaveADatafeed(String jobId, ActionListener<Boolean> listener) {
        this.datafeedConfigProvider.findDatafeedsForJobIds(Collections.singletonList(jobId), (ActionListener<Set<String>>)ActionListener.wrap(datafeedIds -> {
            if (datafeedIds.isEmpty()) {
                listener.onResponse((Object)Boolean.TRUE);
            } else {
                listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)("A datafeed [" + (String)datafeedIds.iterator().next() + "] already exists for job [" + jobId + "]"), (Object[])new Object[0]));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(PutDatafeedAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void doExecute(Task task, PutDatafeedAction.Request request, ActionListener<PutDatafeedAction.Response> listener) {
        if (this.licenseState.isMachineLearningAllowed()) {
            super.doExecute(task, (MasterNodeRequest)request, listener);
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }
}

