/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.DeleteDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;

public class TransportDeleteDatafeedAction
extends TransportMasterNodeAction<DeleteDatafeedAction.Request, AcknowledgedResponse> {
    private final Client client;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final ClusterService clusterService;
    private final PersistentTasksService persistentTasksService;
    private final MlConfigMigrationEligibilityCheck migrationEligibilityCheck;

    @Inject
    public TransportDeleteDatafeedAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, PersistentTasksService persistentTasksService, NamedXContentRegistry xContentRegistry) {
        super(settings, "cluster:admin/xpack/ml/datafeeds/delete", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, DeleteDatafeedAction.Request::new);
        this.client = client;
        this.datafeedConfigProvider = new DatafeedConfigProvider(client, xContentRegistry);
        this.persistentTasksService = persistentTasksService;
        this.clusterService = clusterService;
        this.migrationEligibilityCheck = new MlConfigMigrationEligibilityCheck(settings, clusterService);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    protected void masterOperation(DeleteDatafeedAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        if (this.migrationEligibilityCheck.datafeedIsEligibleForMigration(request.getDatafeedId(), state)) {
            listener.onFailure((Exception)ExceptionsHelper.configHasNotBeenMigrated((String)"delete datafeed", (String)request.getDatafeedId()));
            return;
        }
        if (request.isForce()) {
            this.forceDeleteDatafeed(request, state, listener);
        } else {
            this.deleteDatafeedConfig(request, state, listener);
        }
    }

    private void forceDeleteDatafeed(DeleteDatafeedAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        ActionListener finalListener = ActionListener.wrap(response -> this.deleteDatafeedConfig(request, state, listener), arg_0 -> listener.onFailure(arg_0));
        ActionListener isolateDatafeedHandler = ActionListener.wrap(response -> this.removeDatafeedTask(request, state, (ActionListener<Boolean>)finalListener), arg_0 -> listener.onFailure(arg_0));
        IsolateDatafeedAction.Request isolateDatafeedRequest = new IsolateDatafeedAction.Request(request.getDatafeedId());
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)IsolateDatafeedAction.INSTANCE, (ActionRequest)isolateDatafeedRequest, (ActionListener)isolateDatafeedHandler);
    }

    private void removeDatafeedTask(DeleteDatafeedAction.Request request, ClusterState state, final ActionListener<Boolean> listener) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
        PersistentTasksCustomMetaData.PersistentTask datafeedTask = MlTasks.getDatafeedTask((String)request.getDatafeedId(), (PersistentTasksCustomMetaData)tasks);
        if (datafeedTask == null) {
            listener.onResponse((Object)true);
        } else {
            this.persistentTasksService.sendRemoveRequest(datafeedTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
                    listener.onResponse((Object)Boolean.TRUE);
                }

                public void onFailure(Exception e) {
                    if (e instanceof ResourceNotFoundException) {
                        listener.onResponse((Object)true);
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        }
    }

    private void deleteDatafeedConfig(DeleteDatafeedAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)this.clusterService.state().getMetaData().custom("persistent_tasks");
        if (MlTasks.getDatafeedTask((String)request.getDatafeedId(), (PersistentTasksCustomMetaData)tasks) != null) {
            listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Cannot delete datafeed [{0}] while its status is {1}", (Object[])new Object[]{request.getDatafeedId(), DatafeedState.STARTED}), (Object[])new Object[0]));
            return;
        }
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)state);
        if (mlMetadata.getDatafeed(request.getDatafeedId()) != null) {
            this.deleteDatafeedFromMetadata(request, listener);
        } else {
            this.datafeedConfigProvider.deleteDatafeedConfig(request.getDatafeedId(), (ActionListener<DeleteResponse>)ActionListener.wrap(deleteResponse -> listener.onResponse((Object)new AcknowledgedResponse(true)), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void deleteDatafeedFromMetadata(final DeleteDatafeedAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("delete-datafeed-" + request.getDatafeedId(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            public ClusterState execute(ClusterState currentState) {
                XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)currentState);
                MlMetadata currentMetadata = MlMetadata.getMlMetadata((ClusterState)currentState);
                PersistentTasksCustomMetaData persistentTasks = (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks");
                MlMetadata newMetadata = new MlMetadata.Builder(currentMetadata).removeDatafeed(request.getDatafeedId(), persistentTasks).build();
                return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ml", (MetaData.Custom)newMetadata).build()).build();
            }
        });
    }

    protected ClusterBlockException checkBlock(DeleteDatafeedAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

