/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.action.TransportOpenJobAction;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.notifications.Auditor;

public class TransportCloseJobAction
extends TransportTasksAction<TransportOpenJobAction.JobTask, CloseJobAction.Request, CloseJobAction.Response, CloseJobAction.Response> {
    private final ClusterService clusterService;
    private final Client client;
    private final Auditor auditor;
    private final PersistentTasksService persistentTasksService;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final JobManager jobManager;

    @Inject
    public TransportCloseJobAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, Auditor auditor, PersistentTasksService persistentTasksService, DatafeedConfigProvider datafeedConfigProvider, JobManager jobManager, Client client) {
        super(settings, "cluster:admin/xpack/ml/job/close", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, CloseJobAction.Request::new, CloseJobAction.Response::new, "same");
        this.clusterService = clusterService;
        this.client = client;
        this.auditor = auditor;
        this.persistentTasksService = persistentTasksService;
        this.datafeedConfigProvider = datafeedConfigProvider;
        this.jobManager = jobManager;
    }

    protected void doExecute(Task task, CloseJobAction.Request request, ActionListener<CloseJobAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (!request.isLocal() && !nodes.isLocalNodeElectedMaster()) {
            if (nodes.getMasterNode() == null) {
                listener.onFailure((Exception)new MasterNotDiscoveredException("no known master node"));
            } else {
                this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, CloseJobAction.Response::new));
            }
        } else {
            PersistentTasksCustomMetaData tasksMetaData = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
            this.jobManager.expandJobIds(request.getJobId(), request.allowNoJobs(), (ActionListener<SortedSet<String>>)ActionListener.wrap(expandedJobIds -> this.validate((Collection<String>)expandedJobIds, request.isForce(), MlMetadata.getMlMetadata((ClusterState)state), tasksMetaData, (ActionListener<OpenAndClosingIds>)ActionListener.wrap(response -> {
                request.setOpenJobIds(response.openJobIds.toArray(new String[0]));
                if (response.openJobIds.isEmpty() && response.closingJobIds.isEmpty()) {
                    listener.onResponse((Object)new CloseJobAction.Response(true));
                    return;
                }
                if (!request.isForce()) {
                    HashSet<String> executorNodes = new HashSet<String>();
                    PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.metaData().custom("persistent_tasks");
                    for (String resolvedJobId : request.getOpenJobIds()) {
                        PersistentTasksCustomMetaData.PersistentTask jobTask = MlTasks.getJobTask((String)resolvedJobId, (PersistentTasksCustomMetaData)tasks);
                        if (jobTask == null || !jobTask.isAssigned()) {
                            String message = "Cannot close job [" + resolvedJobId + "] because the job does not have an assigned node. Use force close to close the job";
                            listener.onFailure((Exception)org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)message, (Object[])new Object[0]));
                            return;
                        }
                        executorNodes.add(jobTask.getExecutorNode());
                    }
                    request.setNodes(executorNodes.toArray(new String[executorNodes.size()]));
                }
                if (request.isForce()) {
                    ArrayList<String> jobIdsToForceClose = new ArrayList<String>(response.openJobIds);
                    jobIdsToForceClose.addAll(response.closingJobIds);
                    this.forceCloseJob(state, request, jobIdsToForceClose, listener);
                } else {
                    this.normalCloseJob(state, task, request, response.openJobIds, response.closingJobIds, listener);
                }
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    void validate(Collection<String> expandedJobIds, boolean forceClose, MlMetadata mlMetadata, PersistentTasksCustomMetaData tasksMetaData, ActionListener<OpenAndClosingIds> listener) {
        this.checkDatafeedsHaveStopped(expandedJobIds, tasksMetaData, mlMetadata, (ActionListener<Boolean>)ActionListener.wrap(response -> {
            OpenAndClosingIds ids = new OpenAndClosingIds();
            ArrayList<String> failedJobs = new ArrayList<String>();
            for (String jobId : expandedJobIds) {
                TransportCloseJobAction.addJobAccordingToState(jobId, tasksMetaData, ids.openJobIds, ids.closingJobIds, failedJobs);
            }
            if (!forceClose && failedJobs.size() > 0) {
                if (expandedJobIds.size() == 1) {
                    listener.onFailure((Exception)org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)"cannot close job [{}] because it failed, use force close", (Object[])new Object[]{expandedJobIds.iterator().next()}));
                    return;
                }
                listener.onFailure((Exception)org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)"one or more jobs have state failed, use force close", (Object[])new Object[0]));
                return;
            }
            ids.openJobIds.addAll(failedJobs);
            listener.onResponse((Object)ids);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    void checkDatafeedsHaveStopped(Collection<String> jobIds, PersistentTasksCustomMetaData tasksMetaData, MlMetadata mlMetadata, ActionListener<Boolean> listener) {
        for (String jobId : jobIds) {
            DatafeedState datafeedState;
            Optional datafeed = mlMetadata.getDatafeedByJobId(jobId);
            if (!datafeed.isPresent() || (datafeedState = MlTasks.getDatafeedState((String)((DatafeedConfig)datafeed.get()).getId(), (PersistentTasksCustomMetaData)tasksMetaData)) == DatafeedState.STOPPED) continue;
            listener.onFailure((Exception)org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"cannot close job datafeed [{0}] hasn''t been stopped", (Object[])new Object[]{((DatafeedConfig)datafeed.get()).getId()}), (Object[])new Object[0]));
            return;
        }
        this.datafeedConfigProvider.findDatafeedsForJobIds(jobIds, (ActionListener<Set<String>>)ActionListener.wrap(datafeedIds -> {
            for (String datafeedId : datafeedIds) {
                DatafeedState datafeedState = MlTasks.getDatafeedState((String)datafeedId, (PersistentTasksCustomMetaData)tasksMetaData);
                if (datafeedState == DatafeedState.STOPPED) continue;
                listener.onFailure((Exception)org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"cannot close job datafeed [{0}] hasn''t been stopped", (Object[])new Object[]{datafeedId}), (Object[])new Object[0]));
                return;
            }
            listener.onResponse((Object)Boolean.TRUE);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    static void addJobAccordingToState(String jobId, PersistentTasksCustomMetaData tasksMetaData, List<String> openJobs, List<String> closingJobs, List<String> failedJobs) {
        JobState jobState = MlTasks.getJobState((String)jobId, (PersistentTasksCustomMetaData)tasksMetaData);
        switch (jobState) {
            case CLOSING: {
                closingJobs.add(jobId);
                break;
            }
            case FAILED: {
                failedJobs.add(jobId);
                break;
            }
            case OPENING: 
            case OPENED: {
                openJobs.add(jobId);
                break;
            }
        }
    }

    static WaitForCloseRequest buildWaitForCloseRequest(List<String> openJobIds, List<String> closingJobIds, PersistentTasksCustomMetaData tasks, Auditor auditor) {
        PersistentTasksCustomMetaData.PersistentTask jobTask;
        WaitForCloseRequest waitForCloseRequest = new WaitForCloseRequest();
        for (String jobId : openJobIds) {
            jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetaData)tasks);
            if (jobTask == null) continue;
            auditor.info(jobId, "Job is closing");
            waitForCloseRequest.persistentTaskIds.add(jobTask.getId());
            waitForCloseRequest.jobsToFinalize.add(jobId);
        }
        for (String jobId : closingJobIds) {
            jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetaData)tasks);
            if (jobTask == null) continue;
            waitForCloseRequest.persistentTaskIds.add(jobTask.getId());
        }
        return waitForCloseRequest;
    }

    protected void taskOperation(final CloseJobAction.Request request, final TransportOpenJobAction.JobTask jobTask, final ActionListener<CloseJobAction.Response> listener) {
        JobTaskState taskState = new JobTaskState(JobState.CLOSING, jobTask.getAllocationId());
        jobTask.updatePersistentTaskState((PersistentTaskState)taskState, ActionListener.wrap(task -> this.threadPool.executor("ml_utility").execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                if (e instanceof ResourceNotFoundException && Strings.isAllOrWildcard((String[])new String[]{request.getJobId()})) {
                    jobTask.closeJob("close job (api)");
                    listener.onResponse((Object)new CloseJobAction.Response(true));
                } else {
                    listener.onFailure(e);
                }
            }

            protected void doRun() throws Exception {
                jobTask.closeJob("close job (api)");
                listener.onResponse((Object)new CloseJobAction.Response(true));
            }
        }), arg_0 -> listener.onFailure(arg_0)));
    }

    protected CloseJobAction.Response newResponse(CloseJobAction.Request request, List<CloseJobAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (request.getOpenJobIds().length != tasks.size()) {
            if (!taskOperationFailures.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
            }
            if (!failedNodeExceptions.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
            }
            return new CloseJobAction.Response(true);
        }
        return new CloseJobAction.Response(tasks.stream().allMatch(CloseJobAction.Response::isClosed));
    }

    protected CloseJobAction.Response readTaskResponse(StreamInput in) throws IOException {
        return new CloseJobAction.Response(in);
    }

    private void forceCloseJob(ClusterState currentState, final CloseJobAction.Request request, List<String> jobIdsToForceClose, final ActionListener<CloseJobAction.Response> listener) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks");
        final int numberOfJobs = jobIdsToForceClose.size();
        final AtomicInteger counter = new AtomicInteger();
        final AtomicArray failures = new AtomicArray(numberOfJobs);
        for (String jobId : jobIdsToForceClose) {
            PersistentTasksCustomMetaData.PersistentTask jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetaData)tasks);
            if (jobTask == null) continue;
            this.auditor.info(jobId, "Job is closing (forced)");
            this.persistentTasksService.sendRemoveRequest(jobTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                    if (counter.incrementAndGet() == numberOfJobs) {
                        this.sendResponseOrFailure(request.getJobId(), (ActionListener<CloseJobAction.Response>)listener, (AtomicArray<Exception>)failures);
                    }
                }

                public void onFailure(Exception e) {
                    int slot = counter.incrementAndGet();
                    if (!(e instanceof ResourceNotFoundException && Strings.isAllOrWildcard((String[])new String[]{request.getJobId()}))) {
                        failures.set(slot - 1, (Object)e);
                    }
                    if (slot == numberOfJobs) {
                        this.sendResponseOrFailure(request.getJobId(), (ActionListener<CloseJobAction.Response>)listener, (AtomicArray<Exception>)failures);
                    }
                }

                private void sendResponseOrFailure(String jobId, ActionListener<CloseJobAction.Response> listener2, AtomicArray<Exception> failures2) {
                    List catchedExceptions = failures2.asList();
                    if (catchedExceptions.size() == 0) {
                        listener2.onResponse((Object)new CloseJobAction.Response(true));
                        return;
                    }
                    String msg = "Failed to force close job [" + jobId + "] with [" + catchedExceptions.size() + "] failures, rethrowing last, all Exceptions: [" + catchedExceptions.stream().map(Throwable::getMessage).collect(Collectors.joining(", ")) + "]";
                    ElasticsearchException e = new ElasticsearchException(msg, (Throwable)catchedExceptions.get(0), new Object[0]);
                    listener2.onFailure((Exception)e);
                }
            });
        }
    }

    private void normalCloseJob(ClusterState currentState, Task task, CloseJobAction.Request request, List<String> openJobIds, List<String> closingJobIds, ActionListener<CloseJobAction.Response> listener) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks");
        WaitForCloseRequest waitForCloseRequest = TransportCloseJobAction.buildWaitForCloseRequest(openJobIds, closingJobIds, tasks, this.auditor);
        if (!waitForCloseRequest.hasJobsToWaitFor()) {
            listener.onResponse((Object)new CloseJobAction.Response(true));
            return;
        }
        boolean noOpenJobsToClose = openJobIds.isEmpty();
        if (noOpenJobsToClose) {
            this.waitForJobClosed(request, waitForCloseRequest, new CloseJobAction.Response(true), listener);
            return;
        }
        ActionListener finalListener = ActionListener.wrap(r -> this.waitForJobClosed(request, waitForCloseRequest, (CloseJobAction.Response)r, listener), arg_0 -> listener.onFailure(arg_0));
        super.doExecute(task, (BaseTasksRequest)request, finalListener);
    }

    void waitForJobClosed(CloseJobAction.Request request, WaitForCloseRequest waitForCloseRequest, final CloseJobAction.Response response, final ActionListener<CloseJobAction.Response> listener) {
        this.persistentTasksService.waitForPersistentTasksCondition(persistentTasksCustomMetaData -> {
            for (String persistentTaskId : waitForCloseRequest.persistentTaskIds) {
                if (persistentTasksCustomMetaData.getTask(persistentTaskId) == null) continue;
                return false;
            }
            return true;
        }, request.getCloseTimeout(), (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean result) {
                listener.onResponse((Object)response);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    static class WaitForCloseRequest {
        List<String> persistentTaskIds = new ArrayList<String>();
        List<String> jobsToFinalize = new ArrayList<String>();

        WaitForCloseRequest() {
        }

        public boolean hasJobsToWaitFor() {
            return !this.persistentTaskIds.isEmpty();
        }
    }

    class OpenAndClosingIds {
        List<String> openJobIds = new ArrayList<String>();
        List<String> closingJobIds = new ArrayList<String>();

        OpenAndClosingIds() {
        }
    }
}

