/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.InMemoryExtendedOperationHandler;
import com.unboundid.ldap.listener.InMemoryRequestHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.WhoAmIExtendedResult;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class WhoAmIExtendedOperationHandler
extends InMemoryExtendedOperationHandler {
    @Override
    public String getExtendedOperationHandlerName() {
        return "Who Am I?";
    }

    @Override
    public List<String> getSupportedExtendedRequestOIDs() {
        return Arrays.asList("1.3.6.1.4.1.4203.1.11.3");
    }

    @Override
    public ExtendedResult processExtendedOperation(InMemoryRequestHandler handler, int messageID, ExtendedRequest request) {
        for (Control c : request.getControls()) {
            if (!c.isCritical()) continue;
            return new ExtendedResult(messageID, ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_WHO_AM_I_EXTOP_UNSUPPORTED_CONTROL.get(c.getOID()), null, null, null, null, null);
        }
        String authorizationID = "dn:" + handler.getAuthenticatedDN().toString();
        return new WhoAmIExtendedResult(messageID, ResultCode.SUCCESS, null, null, null, authorizationID, null);
    }
}

