/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.sql.action.SqlTranslateAction;
import org.elasticsearch.xpack.sql.action.SqlTranslateRequest;
import org.elasticsearch.xpack.sql.action.SqlTranslateResponse;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.Protocol;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;

public class SqlTranslateRequestBuilder
extends ActionRequestBuilder<SqlTranslateRequest, SqlTranslateResponse, SqlTranslateRequestBuilder> {
    public SqlTranslateRequestBuilder(ElasticsearchClient client, SqlTranslateAction action) {
        this(client, action, Mode.PLAIN, null, null, Collections.emptyList(), Protocol.TIME_ZONE, 1000, Protocol.REQUEST_TIMEOUT, Protocol.PAGE_TIMEOUT);
    }

    public SqlTranslateRequestBuilder(ElasticsearchClient client, SqlTranslateAction action, Mode mode, String query, QueryBuilder filter, List<SqlTypedParamValue> params, TimeZone timeZone, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout) {
        super(client, action, new SqlTranslateRequest(mode, query, params, filter, timeZone, fetchSize, requestTimeout, pageTimeout));
    }

    public SqlTranslateRequestBuilder query(String query) {
        ((SqlTranslateRequest)this.request).query(query);
        return this;
    }

    public SqlTranslateRequestBuilder timeZone(TimeZone timeZone) {
        ((SqlTranslateRequest)this.request).timeZone(timeZone);
        return this;
    }
}

